<?php
namespace ZeroV99\ShipmentTracking\helpers;

if (!defined('ABSPATH')) {
    exit;
}

/**
 * Handles deactivation tasks for the zeroV99 Shipment Tracking plugin.
 *
 * This class is responsible for performing cleanup tasks when the plugin is deactivated,
 * such as marking orders that were previously in the "Shipped" status and changing their
 * status back to "Processing".
 */
class ZeroV99_Shipment_Tracking_Deactivator
{
    /**
     * Executes deactivation tasks for the plugin.
     *
     * This function finds all orders with the "Shipped" status, marks them as previously shipped
     * (to preserve their state for potential reactivation), and changes their status to "Processing".
     */
    public static function deactivate()
    {
        $orders = wc_get_orders(array(
            'status' => 'wc-shipped',
            'limit' => -1,
        ));

        foreach ($orders as $order) {
            $order->update_meta_data(ZeroV99_Shipment_Tracking_Config::META_WAS_SHIPPED_BEFORE_DEACTIVATION, 'yes');

            $order->update_status('wc-processing', __('Plugin deactivated: Status changed from Shipped to Processing.', 'zerov99-shipment-tracking'));
           
            $order->save();
        }
    }
}
