<?php

namespace ZeroV99\ShipmentTracking\helpers;

if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly
}

/**
 * Configuration constants for the ZeroV99 Shipment Tracking plugin
 * 
 * This class contains all the meta keys, options, tasks, and transients used throughout the plugin.
 * All constants are organized by their purpose and usage context.
 */
class ZeroV99_Shipment_Tracking_Config
{

    /**
     * Plugin version
     */
    const PLUGIN_VERSION = '1.0.0';
    
    /**
     * Order meta keys - Used to store shipment tracking information on WC_Order objects
     */
    const META_CARRIER_NAME = '_zerov99_carrier_name';
    const META_TRACKING_CODE = '_zerov99_tracking_code';
    const META_CARRIER_WEBSITE = '_zerov99_carrier_website';
    const META_PICKUP_DATE = '_zerov99_pickup_date';
    const META_SEND_EMAIL = '_zerov99_send_email';
    const META_LAST_SHIPPED_DATE = '_zerov99_last_shipped_date';
    const META_ORDER_PICKED_UP = '_zerov99_order_picked_up';
    const META_WAS_SHIPPED_BEFORE_DEACTIVATION = '_zerov99_was_shipped_before_deactivation';


     /**
     * Plugin options - Stored in wp_options table
     */
    const OPTION_ENABLE_SHIPPED_STATUS = 'zerov99_enable_shipped_status';
    const OPTION_SHIPPED_LABEL_COLOR = 'zerov99_shipped_label_color';
    const OPTION_SHIPPING_PROVIDERS = 'zerov99_shipping_providers';
    const OPTION_ENABLE_AUTO_COMPLETE = 'zerov99_enable_auto_complete';
    const OPTION_AUTO_COMPLETE_DAYS = 'zerov99_auto_complete_days';
    const OPTION_DELETE_PLUGIN_DATA = 'zerov99_delete_plugin_data';
    const OPTION_SEND_EMAIL = 'zerov99_send_email';

    /**
     * Scheduled tasks - Used with Action Scheduler
     */
    const TASK_AUTO_COMPLETE_SHIPPED_ORDERS = 'zerov99_auto_complete_shipped_orders';


      /**
     * Transients - Temporary cached data
     */
     const TRANSIENT_FORM_ERROR_NOTICE = 'zerov99_form_error_notice';

    
}