<?php
namespace ZeroV99\ShipmentTracking\helpers;

if (!defined('ABSPATH')) {
    exit;
}

use ZeroV99\ShipmentTracking\admin\ZeroV99_Shipment_Tracking_Status_Shipped;



/**
 * Handles activation tasks for the ZzeroV99 Shipment Tracking plugin.
 *
 * This class is responsible for performing setup tasks when the plugin is activated,
 * such as registering the custom "Shipped" order status, enabling the status by default,
 * and restoring orders to the "Shipped" status if they were previously marked as such.
 */
class ZeroV99_Shipment_Tracking_Activator
{
    /**
     * Executes activation tasks for the plugin.
     *
     * This function registers the custom "Shipped" order status, enables it by default,
     * and restores orders to the "Shipped" status if they were previously marked as such
     * before the plugin was deactivated.
     */
    public static function activate()
    {

        ZeroV99_Shipment_Tracking_Status_Shipped::register_shipped_order_status();

        update_option(ZeroV99_Shipment_Tracking_Config::OPTION_ENABLE_SHIPPED_STATUS, 'yes');

        ZeroV99_Shipment_Tracking_Status_Shipped::restore_shipped_orders();
    }
}
