<?php
namespace ZeroV99\ShipmentTracking\admin\settings;

if (! defined('ABSPATH')) {
    exit;
}

use ZeroV99\ShipmentTracking\helpers\ZeroV99_Shipment_Tracking_Config;

/**
 * Handles the custom settings field for shipping providers in the zerov99 Shipment Tracking plugin.
 *
 * This class is responsible for rendering the custom field for the shipping providers table
 * in the WooCommerce settings. It includes a template to display the table and manage the providers.
 */
class ZeroV99_Shipment_Tracking_Settings_Shipping_Providers
{

    /**
     * Constructor.
     *
     * Initializes the class and hooks into WooCommerce settings to render the custom field
     * for the shipping providers table.
     */
    public function __construct()
    { 
        add_action('woocommerce_admin_field_zerov99_shipping_providers_table', [$this, 'output_shipping_providers_table']);
    }

    /**
     * Outputs the custom field for the shipping providers table.
     *
     * This function retrieves the list of shipping providers from the plugin options and
     * includes a template file to render the table in the WooCommerce settings.
     *
     * @param array $value The field data, including 'name' and other attributes.
     */
    public function output_shipping_providers_table($value)
    {
        $providers = get_option(ZeroV99_Shipment_Tracking_Config::OPTION_SHIPPING_PROVIDERS, array());

        include plugin_dir_path(dirname(__FILE__, 3)) . 'templates/admin/zerov99_shipping_providers_table.php';
    }
}


