<?php

namespace ZeroV99\ShipmentTracking\admin\settings;

if (!defined('ABSPATH')) {
    exit;
}

use ZeroV99\ShipmentTracking\helpers\ZeroV99_Shipment_Tracking_Config;

/**
 * Handles settings and options related to shipping providers in the zerov99 Shipment Tracking plugin.
 *
 * This class is responsible for sanitizing and managing the shipping providers option
 * in the WooCommerce settings. It ensures that the data is properly sanitized before being saved.
 */
class ZeroV99_Shipment_Tracking_Settings_Provider_Options
{
    /**
     * Constructor.
     *
     * Initializes the class and hooks into WooCommerce settings to sanitize the shipping providers option.
     */
    public function __construct()
    {
        add_filter('woocommerce_admin_settings_sanitize_option_' . ZeroV99_Shipment_Tracking_Config::OPTION_SHIPPING_PROVIDERS, [$this, 'sanitize_option_shipping_providers']);
    }

    /**
     * Sanitizes the shipping providers option.
     *
     * This function is a placeholder for sanitizing the shipping providers option.
     * Currently, it returns the value unchanged, but it can be extended to include
     * custom sanitization logic if needed.
     *
     * @param mixed $value The current value of the shipping providers option.
     * @return mixed The sanitized value (unchanged in this case).
     */
    public function sanitize_option_shipping_providers($value)
    {
        return $value;
    }
}