<?php

namespace ZeroV99\ShipmentTracking\admin;

if (!defined('ABSPATH')) {
    exit;
}

use ZeroV99\ShipmentTracking\helpers\ZeroV99_Shipment_Tracking_Config;

/**
 * Handles the display of admin notices in the WordPress admin area.
 *
 * This class is responsible for showing error notices in the admin area,
 * particularly for errors related to the zerov99 Shipment Tracking plugin.
 */
class ZeroV99_Shipment_Tracking_Admin_Notices
{
    /**
     * Constructor.
     *
     * Initializes the class and hooks into the `admin_notices` action to display
     * error messages stored in a transient.
     */
    public function __construct()
    {
        add_action('admin_notices', function () {
            if ($error_message = get_transient(ZeroV99_Shipment_Tracking_Config::TRANSIENT_FORM_ERROR_NOTICE)) {
                echo '<div class="notice notice-error"><p>' . esc_html($error_message) . '</p></div>';
                delete_transient(ZeroV99_Shipment_Tracking_Config::TRANSIENT_FORM_ERROR_NOTICE);
            }
        });

    }

    /**
     * Handles errors by setting a transient error message and redirecting.
     *
     * @param string $error_message The error message to display.
     * @param string $redirect_url  The URL to redirect to.
     */
    public static function handle_form_error($error_message, $redirect_url)
    {
        set_transient(ZeroV99_Shipment_Tracking_Config::TRANSIENT_FORM_ERROR_NOTICE, $error_message, 60);
        wp_safe_redirect($redirect_url);
        exit;
    }
}