<?php

namespace ZeroV99\ShipmentTracking\admin;

if (!defined('ABSPATH')) {
    exit;
}

use ZeroV99\ShipmentTracking\helpers\ZeroV99_Shipment_Tracking_Config;
use function ZeroV99\ShipmentTracking\helpers\get_asset_version;

/**
 * Loads admin assets for different WooCommerce screens.
 */
class ZeroV99_Shipment_Tracking_Admin_Assets
{
    public function __construct()
    {
        add_action('admin_enqueue_scripts', [$this, 'enqueue_admin_assets']);
    }

    /**
     * Enqueues scripts and styles depending on the current admin screen.
     *
     * @param string $hook The current page hook.
     */
    public function enqueue_admin_assets($hook)
    {
        $screen = get_current_screen();
        $plugin_url = plugin_dir_url(dirname(__FILE__, 2));
        $plugin_path  = plugin_dir_path(dirname(__FILE__, 2));
        //$is_production = !defined('WP_DEBUG') || !WP_DEBUG;
        //$version = $is_production ? '1.0' : time();
        $is_dev       = defined('WP_DEBUG') && WP_DEBUG;

        // Plugins page: show confirmation before deactivation
        if ($hook === 'plugins.php') {
            $file_name = 'zerov99-shipment-tracking-admin-deactivate-confirm' . ($is_dev ? '.js' : '.min.js');
            $relative_path = "assets/js/{$file_name}";


            wp_enqueue_script(
                'zerov99-deactivate-confirm-js',
                $plugin_url . $relative_path,
                ['jquery'],
                get_asset_version($plugin_path . $relative_path),
                true
            );

            wp_localize_script('zerov99-deactivate-confirm-js', 'zerov99Admin', [
                'deactivateConfirm' => __('Are you sure you want to deactivate this plugin? All shipped orders will change to processing', 'zerov99-shipment-tracking'),
            ]);
        }

        // Orders screen (HPOS): tracking actions, badge styles, inline CSS
        if ($screen && $screen->id === 'woocommerce_page_wc-orders') {
            $css_file_name = 'zerov99-orders-styles' . ($is_dev ? '.css' : '.min.css');
            $js_file_name  = 'zerov99-combined-orders' . ($is_dev ? '.js' : '.min.js');

            $css_path = "assets/css/{$css_file_name}";
            $js_path  = "assets/js/{$js_file_name}";

            wp_enqueue_style(
                'zerov99-orders-styles',
                $plugin_url . $css_path,
                [],
                get_asset_version($plugin_path . $css_path)
            );

            wp_enqueue_script(
                'zerov99-combined-orders-js',
                $plugin_url . $js_path,
                ['jquery'],
                get_asset_version($plugin_path . $js_path),
                true
            );

            // Inline CSS
            $shipped_color = get_option(ZeroV99_Shipment_Tracking_Config::OPTION_SHIPPED_LABEL_COLOR, '#4CAF50');
            $localized_message = __('This order has been shipped and is on its way to the customer.', 'zerov99-shipment-tracking');
            $inline_styles = "
                mark.order-status.status-shipped { background-color: " . esc_attr($shipped_color) . "; }
                .wc-action-button-zerov99-shipped::after { font-family: woocommerce !important; content: '\\e01a' !important; }
                mark.order-status.status-shipped:hover::after { content: '" . esc_attr($localized_message) . "'; white-space: pre-wrap; }
            ";
            wp_add_inline_style('zerov99-orders-styles', $inline_styles);

            // Data from PHP to JS
            $providers = get_option(ZeroV99_Shipment_Tracking_Config::OPTION_SHIPPING_PROVIDERS, []);
            wp_localize_script('zerov99-combined-orders-js', 'zerov99Data', [
                'providers' => $providers,
                'serverAlert' => __('There was an error communicating with the server.', 'zerov99-shipment-tracking'),
            ]);
        }

        // Settings screen: shipping provider table and autocomplete option task)
        if ($screen && $screen->id === 'woocommerce_page_wc-settings') {
            $css_file_name = 'zerov99-shipping-providers' . ($is_dev ? '.css' : '.min.css');
            $js_file_name  = 'zerov99-settings' . ($is_dev ? '.js' : '.min.js');

            $css_path = "assets/css/{$css_file_name}";
            $js_path  = "assets/js/{$js_file_name}";

            wp_enqueue_style(
                'zerov99-shipping-providers-styles',
                $plugin_url . $css_path,
                [],
                get_asset_version($plugin_path . $css_path)
            );

            wp_enqueue_script(
                'zerov99-settings-js',
                $plugin_url . $js_path,
                ['jquery', 'jquery-ui-sortable'],
                get_asset_version($plugin_path . $js_path),
                true
            );
        }
    }
}
