<?php

namespace ZeroV99\ShipmentTracking;

if (!defined('ABSPATH')) {
    exit;
} 

use ZeroV99\ShipmentTracking\admin\settings\ZeroV99_Shipment_Tracking_Settings;
use ZeroV99\ShipmentTracking\admin\settings\ZeroV99_Shipment_Tracking_Settings_Provider_Options;
use ZeroV99\ShipmentTracking\admin\settings\ZeroV99_Shipment_Tracking_Settings_Shipping_Providers;
use ZeroV99\ShipmentTracking\admin\ZeroV99_Shipment_Tracking_Admin_Assets;
use ZeroV99\ShipmentTracking\admin\ZeroV99_Shipment_Tracking_Order_Actions;
use ZeroV99\ShipmentTracking\admin\ZeroV99_Shipment_Tracking_Metabox;
use ZeroV99\ShipmentTracking\admin\ZeroV99_Shipment_Tracking_Modal;
use ZeroV99\ShipmentTracking\admin\ZeroV99_Shipment_Tracking_Completed_Metabox;
use ZeroV99\ShipmentTracking\admin\ZeroV99_Shipment_Tracking_Status_Shipped;
use ZeroV99\ShipmentTracking\admin\ZeroV99_Shipment_Tracking_Admin_Notices;
use ZeroV99\ShipmentTracking\frontend\ZeroV99_Order_Tracking_Details;
use ZeroV99\ShipmentTracking\helpers\ZeroV99_Shipment_Tracking_Activator;
use ZeroV99\ShipmentTracking\helpers\ZeroV99_Shipment_Tracking_Deactivator;
use ZeroV99\ShipmentTracking\helpers\ZeroV99_Shipment_Tracking_Data_Cleanup;
use ZeroV99\ShipmentTracking\tasks\ZeroV99_Auto_Complete_Shipped_Orders;

/**
 * Main plugin class responsible for initializing all components.
 *
 * This class handles the activation, deactivation, and initialization of all
 * plugin components, including admin, frontend, and helper classes.
 */
class ZeroV99_Shipment_Tracking
{
    /**
     * Initializes the plugin by registering hooks and initializing classes.
     *
     * This method sets up activation/deactivation hooks, registers custom order statuses,
     * and initializes all necessary plugin components.
     */
    public static function init()
    {
        // Register activation and deactivation hooks
        register_activation_hook(plugin_dir_path(__DIR__) . 'zerov99-shipment-tracking.php', [ZeroV99_Shipment_Tracking_Activator::class, 'activate']);
        register_deactivation_hook(plugin_dir_path(__DIR__) . 'zerov99-shipment-tracking.php', [ZeroV99_Shipment_Tracking_Deactivator::class, 'deactivate']);

        // Register custom order status
        add_action('init', [ZeroV99_Shipment_Tracking_Status_Shipped::class, 'register_shipped_order_status']);
        add_filter('wc_order_statuses', [ZeroV99_Shipment_Tracking_Status_Shipped::class, 'add_shipped_to_order_statuses']);

        // Initialize admin classes
        self::initialize_admin_classes();

        // Initialize frontend classes
        self::initialize_frontend_classes();

        // Initialize helper classes
        self::initialize_helper_classes();
    }

    /**
     * Initializes admin-related classes.
     */
    private static function initialize_admin_classes()
    {
        ZeroV99_Shipment_Tracking_Settings::init();
        new ZeroV99_Shipment_Tracking_Admin_Assets();
        new ZeroV99_Shipment_Tracking_Order_Actions();
        new ZeroV99_Shipment_Tracking_Metabox();
        new ZeroV99_Shipment_Tracking_Modal();
        new ZeroV99_Shipment_Tracking_Completed_Metabox();
        new ZeroV99_Shipment_Tracking_Settings_Shipping_Providers();
        new ZeroV99_Shipment_Tracking_Settings_Provider_Options();
        new ZeroV99_Shipment_Tracking_Admin_Notices();
    }

    /**
     * Initializes frontend-related classes.
     */
    private static function initialize_frontend_classes()
    {
        new ZeroV99_Order_Tracking_Details();
    }

    /**
     * Initializes helper-related classes.
     */
    private static function initialize_helper_classes()
    {
        new ZeroV99_Shipment_Tracking_Data_Cleanup();
        new ZeroV99_Auto_Complete_Shipped_Orders();
    }
}