<?php
/**
 * Plugin Name: ZeroState
 * Description: A plugin to reset your WordPress site to a clean, default state, preserving only the current admin account and the ZeroState plugin.
 * Version: 1.0.3
 * Author: mdashar
 * License: GPL-2.0-or-later
 * License URI: https://www.gnu.org/licenses/gpl-2.0.html
 * Text Domain: zerostate
 * Requires at least: 5.0
 * Requires PHP: 7.2
 *
 * @package ZeroState
 */

if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly.
}

// Define plugin constants.
define('ZEROSTATE_VERSION', '1.0.3');
define('ZEROSTATE_PLUGIN_DIR', plugin_dir_path(__FILE__));
define('ZEROSTATE_PLUGIN_URL', plugin_dir_url(__FILE__));

// Load plugin dependencies.
require_once ZEROSTATE_PLUGIN_DIR . 'includes/class-zerostate.php';
require_once ZEROSTATE_PLUGIN_DIR . 'admin/zerostate-settings.php';

// Register uninstall hook.
function zerostate_uninstall() {
    delete_option('zerostate_version');
}
register_uninstall_hook(__FILE__, 'zerostate_uninstall');

// Initialize plugin.
function zerostate_init() {
    if (get_option('zerostate_version') !== ZEROSTATE_VERSION) {
        update_option('zerostate_version', ZEROSTATE_VERSION);
    }
}
add_action('init', 'zerostate_init');
?>