<?php
/*
  Plugin Name: zenVPN — Invisibility cloak for your wp-admin
  Description: Secure access to your WordPress wp-admin directory
  Version: 1.0.7
  License: GPLv3
  Author: zenvpn.net
 */

 if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

// Define constants for plugin prefix and text domain
const ZV_PREFIX = 'zenvpn_';
const ZV_VERSION = '1.0.7';
const ZEN_VPN_API_URL = 'https://app.zenvpn.net';
const ZEN_VPN_WEBSITE = 'https://app.zenvpn.net';
const ZEN_VPN_APP = 'https://app.zenvpn.net';

// Require the Autoloader class file
require_once __DIR__ . DIRECTORY_SEPARATOR . 'Autoloader.php';

use zenVPN\Autoloader;
use zenVPN\Ajax\ZV_AJAX;
use zenVPN\Blocker\ZV_IP_Blocker;
use zenVPN\Enqueuer\ZV_Scripts;
use zenVPN\Settings\ZV_Settings;

// Create an instance of the Autoloader class
$autoloader = new Autoloader();

// Register the autoloader
$autoloader->register();

/**
 * @var array<SettingMeta>
 */
$settings = [
    [
        'name' => ZV_PREFIX . 'token',
        'title' => __( 'Token', 'zenvpn' ),
        'callback' => 'token_field_callback',
        'section' => ZV_PREFIX . 'main_section',
        'args' => [
            'label_for' => ZV_PREFIX . 'token',
            'class' => ZV_PREFIX . 'row',
            'description' => __('Your zenVPN API key', 'zenvpn' )
        ]
    ],
    [
        'name' => ZV_PREFIX . 'protect_wp_admin',
        'title' => __( 'Protect files', 'zenvpn' ),
        'callback' => 'protect_admin_field_callback',
        'section' => ZV_PREFIX . 'main_section',
        'args' => [
            'label_for' => ZV_PREFIX . 'protect_wp_admin',
            'class' => ZV_PREFIX . 'row',
            'description' => __('Allow /wp-admin access only via authorized zenVPN tunnel', 'zenvpn' )
        ]
    ]
];

// Create instances of the classes and hook them to the appropriate actions
$zenvpn_settings = ZV_Settings::init($settings);
$zenvpn_scripts = new ZV_Scripts();
$zenvpn_ip_blocker = new ZV_IP_Blocker();
$zenvpn_ajax = new ZV_AJAX();

// Register deactivation hook
register_deactivation_hook(__FILE__, array($zenvpn_settings, 'unregister_settings'));

// Add action hook to enqueue scripts and styles
add_action('admin_enqueue_scripts', array($zenvpn_scripts, 'enqueue_scripts'));

// Register settings
add_action('admin_menu', array($zenvpn_settings, 'register_settings'));

// Add options page
add_action('admin_menu', array($zenvpn_settings, 'add_options_page'));

// Block access to WP files from external IPs
add_action('init', array($zenvpn_ip_blocker, 'block_wp_file_access'));

// Hook your PHP function to the wp_ajax_ action
add_action('wp_ajax_zenvpn_save_plugin_settings', array($zenvpn_ajax, 'save_plugin_settings'));
// Hook your PHP function to the wp_ajax_nopriv_ action (optional)
add_action('wp_ajax_nopriv_zenvpn_save_plugin_settings', array($zenvpn_ajax, 'save_plugin_settings'));

// Hook your PHP function to the wp_ajax_ action
add_action('wp_ajax_zenvpn_test_connection', array($zenvpn_ajax, 'test_connection'));
// Hook your PHP function to the wp_ajax_nopriv_ action (optional)
add_action('wp_ajax_nopriv_zenvpn_test_connection', array($zenvpn_ajax, 'test_connection'));

// Hook your PHP function to the wp_ajax_ action
add_action('wp_ajax_zenvpn_load_token_value', array($zenvpn_ajax, 'load_token_value'));
// Hook your PHP function to the wp_ajax_nopriv_ action (optional)
add_action('wp_ajax_nopriv_zenvpn_load_token_value', array($zenvpn_ajax, 'load_token_value'));

// Add redirect on activation
function zenvpn_activation_redirect( string $plugin ): void {
    if( $plugin == plugin_basename( __FILE__ ) ) {
        exit( wp_redirect( admin_url( 'options-general.php?page=zenvpn_settings' ) ) );
    }
}
add_action( 'activated_plugin', 'zenvpn_activation_redirect' );