<?php
/**
 * ZenVPN Settings
 *
 * @package zenVPN
 * @subpackage settings
 * @license https://www.gnu.org/licenses/gpl-3.0.txt GNU/GPLv3
 */

namespace zenVPN\Settings;

interface ZV_Settings_Interface {
	/**
	 * Register settings.
	 *
	 * @return void
	 */
	public function register_settings(): void;

	/**
	 * Validate received settings.
	 *
	 * @param array{token?: string, zenvpn_protect_wp_admin?: bool} $input array of settings.
	 * @return array{token?: string, zenvpn_protect_wp_admin?: bool}
	 */
	public function validate_settings( array $input ): array;

	/**
	 * Add option page.
	 *
	 * @return void
	 */
	public function add_options_page(): void;

	/**
	 * Render option's page markup.
	 *
	 * @return void
	 */
	public function render_options_page(): void;

	/**
	 * Unregister settings.
	 *
	 * @return void
	 */
	public function unregister_settings(): void;
}
