jQuery(document)
    .ready($ => {
        const form = $('#settingsForm');
        const saveButton = $('#saveButton');
        const testButton = $('#testButton');
        const editButton = $('#editButton');
        const cancelButton = $('#cancelButton');
        const statusMessageBlock = $('#statusMessage');
        const wpAdminCheckbox = $('#zenvpn_protect_wp_admin');
        const tokenField = $('#zenvpn_token');
        const optionsBlock = $('#optionsBlock');
        const buttonsBlock = $('#buttonsBlock');

        const ZV_TEST_CONNECTION_ACTION = 'zenvpn_test_connection';

        /** @param {boolean} value */
        function setEditParam(value) {
            const url = new URL(location.href);
            if (value) {
                url.searchParams.set('edit', 'true');

            } else {
                url.searchParams.delete('edit');
            }
            history.replaceState(null, null, url.toString());
        }

        function toggleElements() {
            const url = new URL(location.href);
            const editing = url.searchParams.has('edit');
            if (editing) {
                tokenField.prop('disabled', false);
                editButton.addClass('hidden');
                cancelButton.show();
            } else {
                tokenField.prop('disabled', true);
                editButton.removeClass('hidden');
            }
            testButton.toggleClass('hidden', !editing);
            buttonsBlock.toggleClass('hidden', !editing);
            if (tokenField.val().trim().length > 0) {
                optionsBlock.toggleClass('hidden', editing);
            }
        }

        function sendAjax(data, action) {
            data = {
                ...data,
                action,
                security: zenvpn_settings_data.security,
            };
            return $.post(zenvpn_settings_data.ajax_url, data);
        }

        /**
     * @param {number} code
     * @param {string} message
     */
        function doStatusCodeActions(code, message) {
            const url = new URL(location.href);
            const editing = url.searchParams.has('edit');
            let statusText = message;
            let statusType = 'error';
            const notEditSuccessMessage = 'Settings successfully saved.';
            const notEditFailureMessage = 'Unable to save settings';
            const errorNoTunnel = 'Unable to activate protection. ' +
                'You currently do not have a zenVPN tunnel to this website set up on zenvpn.net';
            const errorNotConnected = 'Unable to activate protection. Please note that when the protection ' +
                'is activated you will only be able to access admin panel while connected via zenVPN. ' +
                'Please connect with your zenVPN desktop client before enabling the protection.';
            switch (code) {
            case 200:
                if (!editing) {
                    statusText = notEditSuccessMessage;
                }
                statusType = 'success';
                break;
            case 204:
                statusType = 'warning';
                if (!editing) {
                    statusText = errorNotConnected;
                    statusType = 'error';
                }
                break;
            case 404:
                statusType = 'warning';
                if (!editing) {
                    statusText = errorNoTunnel;
                    statusType = 'error';
                }
                break;
            case 403:
                statusType = 'error';
                break;
            default:
                if (!editing) {
                    statusText = notEditFailureMessage;
                }
                break;
            }
            setStatusMessage(statusText, statusType);
        }

        const setStatusMessage = (message, message_type) => {
            statusMessageBlock.html(message);
            statusMessageBlock.removeClass('success warning error hidden')
                .addClass(message_type)
        }

        function handleAjax({data}) {
            const url = new URL(location.href);
            const editing = url.searchParams.has('edit');
            if (data) {
                const {
                    code,
                    message,
                } = data;
                if (code) {
                    if (editing && (code === 200 || code === 204 || code === 404)) {
                        saveButton.prop('disabled', false);
                    }

                    doStatusCodeActions(code, message);
                }
            }
        }

        function handleAjaxError(response) {
            if (typeof(response.responseJSON) === 'undefined') {
                statusMessageBlock.html('An error has occurred. Try reloading this page');
                statusMessageBlock.removeClass('success warning error hidden').addClass('error');
                return;
            }
            const { data } = response.responseJSON;
            if (data) {
                const {
                    code,
                    message,
                } = data;
                if (code) {
                    doStatusCodeActions(code, message);
                }
            }
        }

        function loadTokenValue() {
            sendAjax({}, 'zenvpn_load_token_value')
                .done((response) => {
                    tokenField.val(response.data);
                })
                .fail(handleAjaxError);
        }

        function checkPageState() {
            const url = new URL(location.href);
	    const noToken = tokenField.val() === '';
            const editing = url.searchParams.has('edit') || noToken;
            setEditParam(editing);
            toggleElements();
            if (noToken){
                cancelButton.hide();
            }
        }

        function clearStatusMessage() {
            statusMessageBlock.html('')
                .addClass('hidden');
        }

        saveButton.on('click', () => {
            clearStatusMessage();

            const formData = form.serializeArray();

            const settingsData = formData.reduce((acc, item) => {
                if (item.name.includes('zenvpn_settings')) {
                    acc[item.name] = item.value;
                }
                return acc;
            }, {});

            sendAjax(settingsData, 'zenvpn_save_plugin_settings')
                .done(() => {
                    handleAjax
                    setTimeout(()=> {showDefaultStatusMessage()}, 2000);
                })
                .fail(handleAjaxError);

            setEditParam(false);
            toggleElements();
        });

        testButton.on('click', () => {
            clearStatusMessage();
            const token = tokenField.val();

            sendAjax({ token }, ZV_TEST_CONNECTION_ACTION)
                .done(handleAjax)
                .fail(handleAjaxError);
        });

        editButton.on('click', () => {
            clearStatusMessage();
            setEditParam(true);
            toggleElements();
        });

        cancelButton.on('click', () => {
            clearStatusMessage();
            setEditParam(false);
            toggleElements();
            loadTokenValue();
        });

        wpAdminCheckbox.on('change', (/** @type {Event & {target: HTMLInputElement}} */ {target: input}) => {
            const checked = input.checked;

            const token = tokenField.val();
            const wpAdminValue = checked ? 1 : 0;

            const settingsData = {};
            settingsData['zenvpn_settings[token]'] = token;
            settingsData['zenvpn_settings[zenvpn_protect_wp_admin]'] = wpAdminValue;

            sendAjax({token}, ZV_TEST_CONNECTION_ACTION)
                .done((response) => {
                    if (response.data.code === 200) {
                        sendAjax(settingsData, 'zenvpn_save_plugin_settings')
                            .done(() => {
                                handleAjax
                                setTimeout(()=> {showDefaultStatusMessage()}, 2000);
                            })
                            .fail(handleAjaxError);
                    } else {
                        input.checked = !checked;
                    }
                }, handleAjax)
                .fail(handleAjaxError);
        });

        const showDefaultStatusMessage = () => {
            var successStatusText = "Tunneling through zenVPN OK. You may activate IP shield now.";
            var successStatusType = 'success';
            var failedStatusText = "Plugin installed, please connect via zenVPN cloud to continue setting up.";
            var failedStatusType = 'error';
            const token = tokenField.val();

            if (wpAdminCheckbox.prop('checked')) {
                successStatusText = "zenVPN is protecting your website.";
                successStatusType = 'success';
                failedStatusText = "Plugin installed, please connect via zenVPN cloud to continue setting up.";
                sendAjax({ token }, ZV_TEST_CONNECTION_ACTION)
                    .done((response) => {
                        if (response.data.code === 200) {
                            setStatusMessage(successStatusText, successStatusType)
                        } else {
                            setStatusMessage(failedStatusText, failedStatusType);
			    wpAdminCheckbox.prop('checked', false);
                        }
                    })
                    .fail(() => {
                        setStatusMessage(failedStatusText, failedStatusType);
                    });
            } else {
                if (token == '') {
                    setStatusMessage(failedStatusText, failedStatusType);
                    return;
                } else {
                    sendAjax({ token }, ZV_TEST_CONNECTION_ACTION)
                        .done((response) => {
                            if (response.data.code === 200) {
                                setStatusMessage(successStatusText, successStatusType)
                            } else {
                                setStatusMessage(failedStatusText, failedStatusType);
                            }
                        })
                        .fail(() => {
                            setStatusMessage(failedStatusText, failedStatusType);
                        });
                    return;
                }
            }
        };

        tokenField.on('input', () => {
            saveButton.prop('disabled', true);
        });

        checkPageState();
        showDefaultStatusMessage();

        $.get('https://app.zenvpn.net/r/analytics/wp-plugin?event=settings_loaded&domain='+location.host);
    });
