<?php
namespace ZenCommunity;

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

class RewriteRules { 
    public static function init(){
        add_filter('query_vars', [ __CLASS__, 'set_query_vars' ]);
        add_action('init', [ __CLASS__, 'add_rewrite_rules' ] );
    }

    public static function add_rewrite_rules(){
        $path = $GLOBALS['zencommunity_settings']->path ?? '';
        if ( empty( $path ) ) return;
        
        $path = ltrim( $path, '/' );

        $path = str_replace( '.', '\.', $path );
        add_rewrite_rule(
            '^' . $path . '(?:/([a-zA-Z0-9_-]+))*/?$',
            'index.php?' . ZENCOMMUNITY_APP_ROUTE_QUERY_VAR . '=community',
            'top'
        );
    }

    public static function set_query_vars($vars){
        $vars[] = ZENCOMMUNITY_APP_ROUTE_QUERY_VAR;
        return $vars;
    }
}