<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}
add_action( 'admin_bar_menu', 'zencommunity_top_bar_link', 999 );

add_action( 'admin_notices', 'zencommunity_configuration_check' );

/**
 * Register addon 
 * @param calllable $register
 */
add_action( 'zencommunity/addon/register', 'zencommunity_register_addon' );

add_action( 'zencommunity/activate', 'zencommunity_activate_addon_on_plugin_activation' );

/**
 * Delete unused media uploads
 */
add_action( 'init', 'zencommunity_cleanup_uploads' );
add_action( 'zencommunity_cleanup_uploads', [ \ZenCommunity\Database\Models\Attachment::class, 'delete_unused_files' ] );


/**
 * Triggered when a new feed is created.
 *
 * @param int   $id   Feed ID.
 * @param array $data Feed data including title, content, user_id, group_id, etc.
 */
add_action( "zencommunity/feed/created", 'zencommunity_notification_feed_created', 10, 3 );

/**
 * Triggered when a feed or comment is liked.
 *
 * @param int        $reaction_id Reaction ID.
 * @param int        $feed_id     Feed ID.
 * @param int        $user_id     ID of user who liked.
 * @param int|null   $comment_id  Optional comment ID.
 * @param array      $feed        Feed data.
 */
add_action( "zencommunity/feed/react", 'zencommunity_notification_like', 10, 6 );


/**
 * Triggered when a comment or reply is created on a feed.
 *
 * @param int        $new_comment_id New comment or reply ID.
 * @param int        $feed_id        Feed ID.
 * @param int        $user_id        Commenting user ID.
 * @param int|null   $comment_id     Optional parent comment ID.
 * @param array      $feed           Feed data.
 */
add_action( "zencommunity/feed/comment_created", 'zencommunity_notification_comment', 10, 6 );

/**
 * Triggered when users are mentioned in a feed.
 *
 * @param int   $feed_id         Feed ID.
 * @param array $newly_mentioned Array of usernames mentioned.
 */
add_action( "zencommunity/feed/mentioned", 'zencommunity_notification_mentioned_on_feed', 10, 4 );


/**
 * Triggered when users are mentioned in a comment.
 *
 * @param int   $comment_id      Comment ID.
 * @param array $newly_mentioned Array of usernames mentioned.
 */
add_action( "zencommunity/comment/mentioned", 'zencommunity_notification_mentioned_on_comment', 10, 4 );


/**
 * Triggered when a user is added to a group.
 *
 * @param int   $group_id Group ID.
 * @param array $data     User data including user_id and role.
 */
add_action( "zencommunity/group/user_added", 'zencommunity_notification_member_added', 10, 2 );

/**
 * Triggered when a user's role is changed in a group.
 *
 * @param int    $group_id Group ID.
 * @param int    $user_id  User ID.
 * @param string $role     New role name.
 */
add_action( "zencommunity/group/user_role_changed", 'zencommunity_notification_member_role_changed', 10, 3 );




/**
 * Triggered when a new feed is created.
 *
 * @param int   $id   Feed ID.
 * @param array $data Feed data including title, content, user_id, group_id, etc.
 */
add_action( "zencommunity/feed/created", 'zencommunity_activity_feed_created', 10, 3 );

/**
 * Triggered when a comment or reply is created on a feed.
 *
 * @param int        $new_comment_id New comment or reply ID.
 * @param int        $feed_id        Feed ID.
 * @param int        $user_id        Commenting user ID.
 * @param int|null   $comment_id     Optional parent comment ID.
 * @param array      $feed           Feed data.
 */
add_action( "zencommunity/feed/comment_created", 'zencommunity_activity_comment', 10, 5 );


add_action( 'zencommunity/feed/deleted', 'zencommunity_remove_feed_activity', 10, 2 );
add_action( "zencommunity/feed/comment_deleted", 'zencommunity_remove_comment_activity', 10, 4 );

add_action( "zencommunity/group/deleted", 'zencommunity_remove_group_activity', 10, 1 );
add_action( "zencommunity/category/deleted", 'zencommunity_remove_category_activity', 10, 1 );