<?php
namespace ZenCommunity\Frontend;

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

class Template { 
    public static function init(){
        $self = new self();
        add_filter( 'template_include', [ $self, 'template_include' ] );
    } 

    public function template_include( ?string $template ) : ?string {
        global $zencommunity_settings;
        $slug = get_query_var( ZENCOMMUNITY_APP_ROUTE_QUERY_VAR );
        $load_on_entire_site = $zencommunity_settings->load_on_entire_site ?? false;
        if ( $load_on_entire_site || 'community' === $slug ) {
            return ZENCOMMUNITY_TEMPLATES_DIR_PATH . 'app.php';
        }
        return $template;
    }
}