<?php
namespace ZenCommunity\Database;
use ZenCommunity\Database\Utils\Migration;
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * @class Migrator
 */
class Migrator {
	protected array $migrations = [
		Migrations\CreateProfileTable::class,
		Migrations\CreateGroupTable::class,
		Migrations\CreateGroupMemberTable::class,
		Migrations\CreateFeedTable::class,
		Migrations\CreateMediaTable::class,
		Migrations\CreateCommentTable::class,
		Migrations\CreateReactionTable::class,
		Migrations\CreateActivityTable::class,
		Migrations\CreateNotificationTable::class,
		Migrations\CreateNotifiedUsersTable::class,
	];

	public static function init() : void {
		( new static )->migrate_all();
	}

	public function migrate_all() : void {
		array_map( fn( string $class ) => $this->migrate( new $class ), $this->migrations );
	}

	protected function migrate( Migration $migration ) : void {
		$migration->migrate();
	}
}