<?php
namespace ZenCommunity;

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

class Admin {
	protected static $instance = null;

	protected static $client = null;

	public static function get_instance() {
		if ( null === self::$instance ) {
			self::$instance = new self();
		}


		return self::$instance;
	}

	protected function __construct() {
		if ( ! did_action( 'plugins_loaded' ) ) {
			add_action( 'plugins_loaded', [ $this, 'get_sdk' ] );
		} else {
			$this->get_sdk();
		}
	}

	public function get_sdk() {
		if ( null === self::$client ) {
			self::$client = se_license_init( [
				'package_file'        => ZENCOMMUNITY_PLUGIN_FILE,
				'package_name'        => 'ZenCommunity', // translation remove due to load too early
				'product_id'          => 163,
				'is_free'             => true,
				'slug'                => 'zencommunity',
				'basename'            => ZENCOMMUNITY_PLUGIN_BASENAME,
				'package_type'        => 'plugin',
				'package_version'     => ZENCOMMUNITY_VERSION,
				'allow_local'         => true,
				'license_server'      => 'https://store.kodezen.com/',
				'purchase_url'        => 'https://store.kodezen.com/product/zencommunity/',
				'product_logo'        => defined( 'ZENCOMMUNITY_ASSETS_URI' ) ? ZENCOMMUNITY_ASSETS_URI . 'images/icon_logo.png' : '',
				'store_dashboard_url' => 'https://store.kodezen.com/dashboard/license-keys/',
				'terms_url'           => 'https://kodezen.com/terms-and-conditions/',
				'privacy_policy_url'  => 'https://store.kodezen.com/privacy-policy/',
				'ticket_recipient'    => 'support@kodezen.com',
				'primary_color'       => '#2A3BEE',
				'first_install_time'  => get_option( 'zencommunity_first_install_time' ),
				'optin_notice_delay'  => 3 * DAY_IN_SECONDS,
			] );
		}

		return self::$client;
	}
}

// End of file admin.php
