<?php
namespace ZenCommunity;

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

class AdminMenu {
	public static function init() {
        add_action( 'admin_menu', function() : void {
			$self = new static;
			add_filter( ZENCOMMUNITY_PLUGIN_SLUG . '/admin_menu', [ $self, 'admin_menu' ], 10, 2 );
			Classes\MenuBuilder::init();
		});
	}
	
	public function admin_menu( array $menus, Classes\MenuBuilder $menu_builder ) : void {
		$menu_builder->add_menu(
			__( 'ZenCommunity', 'zencommunity' ),
			__( 'ZenCommunity', 'zencommunity' ),
			'manage_options', //'manage_options',
			'zencommunity-settings',
			[ $this, 'settings_page' ],
			plugins_url( 'assets/images/icon_logo.png', ZENCOMMUNITY_PLUGIN_FILE )
		);
	}

	public function settings_page() : void {
		Helper::get_template( 'admin/settings.php' );
	}
}