<?php

namespace ZenCommunity\Addons\Learndash\Feeds;

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}
use WP_User;
class QuizEndFeed extends Abstracts\EventFeed {
	public function init(): void {
		add_action(
			'learndash_quiz_completed',
			[ $this, 'notify' ],
			999, 3
		);
	}
	
	public function notify( ?array $quiz, ?WP_User $user ): void {
		$course_permalink = get_permalink( $quiz['course']->ID );
		$course_title = $quiz['course']->post_title;
		
		$this->course_id = $quiz['course']->ID;
		$this->title     = __( 'Quiz Solved', 'zencommunity' );
		$this->message   = sprintf(
			/* translators: %s is the username */
			'<p>%s ' . __( 'solved a', 'zencommunity' ) . ' <a href="%s">' . __( 'quiz', 'zencommunity' ) . '</a> ' . __( 'at %s.', 'zencommunity' ) . ' ' . __( 'Now, it\'s your turn to give it a try!', 'zencommunity' ) . '</p>',
			wp_strip_all_tags( $user ? $user->display_name : '' ),
			esc_url( $course_permalink ),
			wp_strip_all_tags( $course_title )
		);
		$this->event     = 'quiz_end';
		$this->push();
	}
}
