<?php

namespace ZenCommunity\Addons\Email;

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

use ZenCommunity\Database\Models\Profile;
class Hooks {
	public static function init() : void {
		add_action( 'zencommunity/activate', [ static::class, 'rescan_templates' ] );
		add_action( 'zencommunity_pro/activate', [ static::class, 'rescan_templates' ] );
		add_action( 'zencommunity/addon/activate', [ static::class, 'rescan_templates' ] );
		add_filter( 'zencommunity/email/template/registered', [ static::class, 'register_templates' ] );

		
		add_action( 
			'zencommunity/notification/created', 
			[ static::class, 'notify' ]
		);
	}
	
	public static function notify( array $notification ) : void {
		try {
			foreach( $notification['to_user_ids'] as $user_id ) {
				$meta = $notification['data']['meta'] ?? '{}';
				$notification['data']['meta'] = is_string( $meta ) ? json_decode( $meta, true ) :  $meta;
				$notification['data']['to_user_id'] = $user_id;
				// print_r($user_id);
				$notification['data']['from_user'] = Profile::by_id( $user_id );
				// WP_SEND_JSON($notification);
				( 
					new Template( 
						$notification['data']['event_type'], 
						$notification['data']
					) 
				)->send();
			}
		}
		catch( \Throwable $e ) {
			error_log( print_r( [ 
				'origin' => 'notification', 
				'file' => $e->getFile(), 
				'line' => $e->getLine(), 
				'msg' => $e->getMessage(),
			], true ) );
		}
		
	}
	public static function rescan_templates() : void {
		Database\Models\Template::rescan_templates();
	}

	public static function register_templates( array $templates ) : array {
		$templates[] = [
			'label'=> 'Feeds',
			'sub_title'=> 'Stay in the loop with community activity.',
			'events'=> [
				'feed_posted' => [
					'template' => ' <p><strong>{{author_name}}</strong> has created a new feed in the group <strong>{{group_name}}</strong>.</p>
					<p>The feed title is:</p>
					<p style="font-size: 18px; font-weight: bold; color: #0073aa;">{{feed_title}}</p>

					<p>Visit the group to view the new feed and join the conversation.</p>',
					'subject' => 'A new Feed is posted',
					'heading' => 'A new Feed is posted',
				],
				
				'feed_comment' => [
					'template' => '
						<p><strong>{{author_name}}</strong> has commented on your feed: <strong>{{feed_title}}</strong>.</p>

						<p>The comment:</p>
						<p style="background-color: #f1f1f1; padding: 15px; border-left: 4px solid #0073aa; font-style: italic;">
							{{comment_rendered}}
						</p>

						<p>Visit your feed to view the full comment and respond.</p>
					',
					'subject' => 'New Comment on Your Feed',
					'heading' => 'Someone commented on your feed',
				],
				
				'comment_reply' => [
					'template' => '
						<p><strong>{{author_name}}</strong> has Replied your comment on  <strong>{{feed_title}}</strong>.</p>

						<p>The Reply:</p>
						<p style="background-color: #f1f1f1; padding: 15px; border-left: 4px solid #0073aa; font-style: italic;">
							{{comment_rendered}}
						</p>

						<p>Visit your feed to view the full comment and respond.</p>
					',
					'subject' => 'New Reply on your Comment',
					'heading' => 'Someone replied on your comment',
				],
				'mentioned_in_comment' => [
					'template' => '
						<p><strong>{{author_name}}</strong> mentioned you in a comment on <strong>{{feed_title}}</strong>.</p>

						<p><strong>The Comment:</strong></p>
						<blockquote style="background-color: #f9f9f9; padding: 15px; border-left: 4px solid #0073aa; font-style: italic;">
							{{comment_rendered}}
						</blockquote>
					',
					'subject' => 'You Were Mentioned in a Comment',
					'heading' => 'You Were Mentioned!',
				],
				'mentioned_in_feed' => [
					'template' => '
						<p><strong>{{author_name}}</strong> mentioned you in the feed <strong>{{feed_title}}</strong>.</p>
					',
					'subject' => 'You Were Mentioned in a Comment',
					'heading' => 'You Were Mentioned!',
				],

			],
		];
		return $templates;
	}
}