<?php

namespace ZenCommunity\Addons\AcademyLms\Feeds;

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}
use stdClass;
class QuizStartFeed extends Abstracts\EventFeed {
	public function init(): void {
		add_action(
			'academy_quizzes/api/after_quiz_attempt_start',
			[ $this, 'notify' ],
			999, 3
		);
	}
	public function notify( stdClass $quiz ): void {
		if (
			empty( $quiz->course_id ) ||
			empty( $quiz->user_id )
		) {
			return;
		}
		$course_permalink = get_permalink( $quiz->course_id );
		$course_title = get_the_title( $quiz->course_id );
		$user = get_userdata( $quiz->user_id );
		$this->course_id = $quiz->course_id;
		$this->title     = __( 'Quiz Attempt', 'zencommunity' );
		$this->message   = sprintf(
			/* translators:  %s is the username1, %s is the username2 */
			'<p>' . __( '%s is attempting to solve the', 'zencommunity' ) . ' <a href="%s">' . __( 'quiz', 'zencommunity' ) . '</a> ' . __( 'at %s.', 'zencommunity' ) . ' ' . __( 'Now, it\'s your turn to give it a try!', 'zencommunity' ) . '</p>',
			wp_strip_all_tags( $user ? $user->display_name : '' ),
			esc_url( $course_permalink ),
			wp_strip_all_tags( $course_title )
		);
		$this->event     = 'quiz_start';
		$this->push();
	}
}
