<?php
namespace ZenCommunity\Addons\AcademyLms\Feeds;

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

class CourseCompletedFeed extends Abstracts\EventFeed {
	public function init(): void {
		add_action(
			'academy/admin/course_complete_after',
			[ $this, 'notify' ],
			10, 2
		);

	}
	public function notify( int $course_id, int $user_id ) : void {
		if ( empty( $user_id ) ) {
			return;
		}
		$course_permalink = get_permalink( $course_id );
		$course_title = get_the_title( $course_id );
		$user = get_userdata( $user_id );
		$this->course_id = $course_id;
		$this->title     = sprintf(
			/* translators:  %s is the username, %s is the groupname */
			__( '%1$s is just completed @ %2$s!', 'zencommunity' ),
			esc_html( $user ? $user->display_name : '' ),
			esc_html( $course_title )
		);
		$this->message   = sprintf(
			'<h3>' . __( '🎉 Congratulations on completing the', 'zencommunity' ) . ' <a href="%s">%s</a>, %s! 🎉</h3><p>' . __( 'You\'ve worked hard, and we\'re so proud of your achievement! 🚀', 'zencommunity' ) . '</p>',
			esc_url( $course_permalink ),
			esc_html( $course_title ),
			esc_html( $user ? $user->display_name : '' )
		);
		$this->event     = 'course_complete';
		$this->push();
	}
}
