<?php

namespace ZenCommunity\Addons\AcademyLms\Feeds;

use ZenCommunity\Addons\AcademyLms\Classes\TrackCurriculumChanges;
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}
class AnswerFeed extends Abstracts\EventFeed {
	public function init(): void {
		add_action(
			'academy/frontend/insert_course_qa_answered',
			[ $this, 'notify' ],
			10, 1
		);
	}
	public function notify( array $answer ): void {

		if (
			empty( $answer ) ||
			empty( $answer['_post'] ?? '' ) ||
			empty( $answer['author'] ?? '' ) ||
			empty( $answer['content'] ?? '' ) ||
			empty( $answer['parent'] ?? '' ) ||
			empty( $answer['post'] ?? '' )
		) {
			return;
		}

		$question = $answer['parent'] ? get_comment( $answer['parent'] ) : null;

		$course_permalink = $answer['_post']['permalink'];
		$course_title     = $answer['_post']['title'];

		$this->course_id = $question ? $question->comment_post_ID : '';

		/* translators: %s is the username */
		$this->title     = sprintf( __( 'Question answerd by %s', 'zencommunity' ), esc_html( $answer['author_name'] ) );
		if ( $answer['author'] === $question ? $question->user_id : '' ) {
			$this->message = sprintf(
				/* translators: %s is the username */
				'<h3><a href="%s">' . __( '%s has replied at his/her comment', 'zencommunity' ) . '</a></h3>
                <blockquote>%s</blockquote>',
				esc_url( $course_permalink ),
				esc_html( $answer['author_name'] ),
				esc_html( $answer['content']['rendered'] )
			);
		} else {
			$this->message = sprintf(
				/* translators:  %s is the username, %s is the username, %s is the groupname */
				'<h3><a href="%s">' . __( 'A question from %1$s has been answered by %2$s @%3$s', 'zencommunity' ) . '</a></h3>
                <h4>' . __( 'Question', 'zencommunity' ) . '</h4>
                <p>%s</p>
                <h4>' . __( 'Answer', 'zencommunity' ) . '</h4>
                <blockquote>%s</blockquote>',
				esc_url( $course_permalink ),
				esc_html( $question ? $question->comment_author : '' ),
				esc_html( $answer['author_name'] ),
				esc_html( $course_title ),
				esc_html( $question ? $question->comment_content : '' ),
				esc_html( $answer['content']['rendered'] )
			);
		}//end if

		$this->event     = 'question_answer';
		$this->push();
	}
}
