<?php

namespace ZenCommunity\Addons\AcademyLms;

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

use ZenCommunity\Exceptions\ZencommunityException;
use ZenCommunity\Classes\Addon\Base;
class AcademyLms extends Base {

	public function __construct() {
		$this->name 		= 'Academy LMS';
		$this->icon_src 	= 'academy-lms.svg';
		$this->version 		= '1.0.0';
		$this->description  = 'Connect ZenCommunity with Academy LMS.';
	}
	
	/**
	 * Run when addon is activated.
	 */
	public function activate(): void{
		if ( ! is_plugin_active( 'academy/academy.php' ) ) {
			throw new ZencommunityException( esc_html( __( 'AcademyLMS plugin needs to activate.', 'zencommunity' ) ), 400 );
		}

		Database\Migrator::init();
    }

	/**
	 * Run when addon is deactivated.
	 */
	public function deactivate(): void{
		// 
    }

	/**
	 * Bootstrap addon logic.
	 */
	public function boot(): void{
		Hooks::init();
		RestApiInit::init();
		EventRegistration::init();
    }
}
