export const AlignHorizontalCenterIcon = () => (<svg xmlns="http://www.w3.org/2000/svg" width="17" height="17" viewBox="0 0 17 17" fill="none">
	<g clip-path="url(#clip0_714_23796)">
		<path d="M6.5 5.41699C6.5 5.0488 6.20152 4.75033 5.83333 4.75033H4.5C4.13181 4.75033 3.83333 5.0488 3.83333 5.41699V12.0837C3.83333 12.4518 4.13181 12.7503 4.5 12.7503H5.83333C6.20152 12.7503 6.5 12.4518 6.5 12.0837V5.41699ZM13.1667 6.75033C13.1667 6.38214 12.8682 6.08366 12.5 6.08366H11.1667C10.7985 6.08366 10.5 6.38214 10.5 6.75033V10.7503C10.5 11.1185 10.7985 11.417 11.1667 11.417H12.5C12.8682 11.417 13.1667 11.1185 13.1667 10.7503V6.75033ZM14.5 10.7503C14.5 11.8549 13.6046 12.7503 12.5 12.7503V15.417C12.5 15.7852 12.2015 16.0837 11.8333 16.0837C11.4651 16.0837 11.1667 15.7852 11.1667 15.417V12.7503C10.0621 12.7503 9.16667 11.8549 9.16667 10.7503V6.75033C9.16667 5.64576 10.0621 4.75033 11.1667 4.75033V2.08366C11.1667 1.71547 11.4651 1.41699 11.8333 1.41699C12.2015 1.41699 12.5 1.71547 12.5 2.08366V4.75033C13.6046 4.75033 14.5 5.64576 14.5 6.75033V10.7503ZM7.83333 12.0837C7.83333 13.1882 6.9379 14.0837 5.83333 14.0837V15.417C5.83333 15.7852 5.53486 16.0837 5.16667 16.0837C4.79848 16.0837 4.5 15.7852 4.5 15.417V14.0837C3.39543 14.0837 2.5 13.1882 2.5 12.0837V5.41699C2.5 4.31242 3.39543 3.41699 4.5 3.41699V2.08366C4.5 1.71547 4.79848 1.41699 5.16667 1.41699C5.53486 1.41699 5.83333 1.71547 5.83333 2.08366V3.41699C6.9379 3.41699 7.83333 4.31242 7.83333 5.41699V12.0837Z" fill="var(--zencom-font-color)" />
	</g>
	<defs>
		<clipPath id="clip0_714_23796">
			<rect width="16" height="16" fill="white" transform="translate(0.5 0.75)" />
		</clipPath>
	</defs>
</svg>)

export const UserRoundIcon = () => (<svg xmlns="http://www.w3.org/2000/svg" width="17" height="17" viewBox="0 0 17 17" fill="none">
	<path d="M9.83366 6.08301C9.83366 4.61025 8.63975 3.41634 7.16699 3.41634C5.69423 3.41634 4.50033 4.61025 4.50033 6.08301C4.50033 7.55577 5.69423 8.74967 7.16699 8.74967C8.63975 8.74967 9.83366 7.55577 9.83366 6.08301ZM14.5003 14.083C14.5003 12.0759 13.2912 10.1759 12.1006 9.28288C11.9327 9.15699 11.8337 8.95949 11.8337 8.74967C11.8337 8.53997 11.9323 8.34239 12.0999 8.21647C12.4506 7.95342 12.731 7.60784 12.9163 7.21061C13.1016 6.81342 13.1861 6.37677 13.1624 5.93913C13.1387 5.50145 13.0074 5.07636 12.7803 4.7015C12.5531 4.3267 12.2373 4.01364 11.8604 3.79004C11.5437 3.60221 11.4388 3.19266 11.6266 2.87598C11.8145 2.55936 12.224 2.45509 12.5407 2.6429C13.1061 2.97828 13.5802 3.44789 13.9209 4.01009C14.2617 4.5724 14.4582 5.21033 14.4938 5.86686C14.5294 6.52337 14.4026 7.17858 14.1247 7.77441C13.9621 8.12291 13.7491 8.44334 13.4964 8.72949C14.7448 9.94473 15.8337 11.9343 15.8337 14.083C15.8337 14.4512 15.5352 14.7497 15.167 14.7497C14.7988 14.7497 14.5003 14.4512 14.5003 14.083ZM11.167 6.08301C11.167 7.38033 10.5487 8.5325 9.59147 9.26335C10.2626 9.55992 10.881 9.97797 11.4098 10.5068C12.535 11.6321 13.167 13.1584 13.167 14.7497C13.167 15.1179 12.8685 15.4163 12.5003 15.4163C12.1321 15.4163 11.8337 15.1179 11.8337 14.7497C11.8337 13.512 11.3423 12.3247 10.4671 11.4495C9.59195 10.5744 8.40467 10.083 7.16699 10.083C5.92932 10.083 4.74203 10.5744 3.86686 11.4495C2.99169 12.3247 2.50033 13.512 2.50033 14.7497C2.50033 15.1179 2.20185 15.4163 1.83366 15.4163C1.46547 15.4163 1.16699 15.1179 1.16699 14.7497C1.16699 13.1584 1.79894 11.6321 2.92415 10.5068C3.45287 9.97812 4.07094 9.55991 4.74186 9.26335C3.78487 8.53249 3.16699 7.38014 3.16699 6.08301C3.16699 3.87387 4.95785 2.08301 7.16699 2.08301C9.37613 2.08301 11.167 3.87387 11.167 6.08301Z" fill="var(--zencom-font-color)" />
</svg>)

export const Setting2Icon = () => (<svg xmlns="http://www.w3.org/2000/svg" width="17" height="17" viewBox="0 0 17 17" fill="none">
	<path d="M13.1667 12.0833C13.1667 11.347 12.5697 10.75 11.8333 10.75C11.097 10.75 10.5 11.347 10.5 12.0833C10.5 12.8197 11.097 13.4167 11.8333 13.4167C12.5697 13.4167 13.1667 12.8197 13.1667 12.0833ZM5.16667 2.75C6.41104 2.75 7.45573 3.60249 7.75 4.75521C7.7773 4.7518 7.80511 4.75 7.83333 4.75H13.8333C14.2015 4.75 14.5 5.04848 14.5 5.41667C14.5 5.78486 14.2015 6.08333 13.8333 6.08333H7.83333C7.80508 6.08333 7.77733 6.08089 7.75 6.07747C7.45595 7.2305 6.41126 8.08333 5.16667 8.08333C3.69391 8.08333 2.5 6.88943 2.5 5.41667C2.5 3.94391 3.69391 2.75 5.16667 2.75ZM14.5 12.0833C14.5 13.5561 13.3061 14.75 11.8333 14.75C10.5908 14.75 9.54668 13.9002 9.25065 12.75H3.83333C3.46514 12.75 3.16667 12.4515 3.16667 12.0833C3.16667 11.7151 3.46514 11.4167 3.83333 11.4167H9.25065C9.54668 10.2665 10.5908 9.41667 11.8333 9.41667C13.3061 9.41667 14.5 10.6106 14.5 12.0833ZM3.83333 5.41667C3.83333 6.15305 4.43029 6.75 5.16667 6.75C5.90305 6.75 6.5 6.15305 6.5 5.41667C6.5 4.68029 5.90305 4.08333 5.16667 4.08333C4.43029 4.08333 3.83333 4.68029 3.83333 5.41667Z" fill="var(--zencom-font-color)" />
</svg>)

export const UploadIcon = () => (<svg xmlns="http://www.w3.org/2000/svg" width="21" height="21" viewBox="0 0 21 21" fill="none">
	<path d="M2.16699 16.0835V12.7501C2.16699 12.2899 2.54009 11.9168 3.00033 11.9168C3.46056 11.9168 3.83366 12.2899 3.83366 12.7501V16.0835C3.83366 16.3045 3.92152 16.5164 4.0778 16.6727C4.23408 16.8289 4.44598 16.9168 4.66699 16.9168H16.3337C16.5547 16.9168 16.7666 16.8289 16.9229 16.6727C17.0791 16.5164 17.167 16.3045 17.167 16.0835V12.7501C17.167 12.2899 17.5401 11.9168 18.0003 11.9168C18.4606 11.9168 18.8337 12.2899 18.8337 12.7501V16.0835C18.8337 16.7465 18.5701 17.3822 18.1012 17.851C17.6324 18.3199 16.9967 18.5835 16.3337 18.5835H4.66699C4.00395 18.5835 3.36825 18.3199 2.89941 17.851C2.43057 17.3822 2.16699 16.7465 2.16699 16.0835ZM9.66699 12.7501V4.76185L6.92285 7.50599C6.59741 7.83143 6.0699 7.83143 5.74447 7.50599C5.41903 7.18055 5.41903 6.65304 5.74447 6.3276L9.91113 2.16094L9.97461 2.10397C10.3019 1.83701 10.7844 1.85584 11.0895 2.16094L15.2562 6.3276C15.5816 6.65304 15.5816 7.18055 15.2562 7.50599C14.9307 7.83143 14.4032 7.83143 14.0778 7.50599L11.3337 4.76185V12.7501C11.3337 13.2104 10.9606 13.5835 10.5003 13.5835C10.0401 13.5835 9.66699 13.2104 9.66699 12.7501Z" fill="var(--zencom-font-color)" />
</svg>)

export const GripIcon = () => (<svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 21 21" fill="none">
	<path d="M6.33301 16.5833C6.33301 15.6629 7.0792 14.9167 7.99967 14.9167C8.92015 14.9167 9.66634 15.6629 9.66634 16.5833C9.66634 17.5038 8.92015 18.25 7.99967 18.25C7.0792 18.25 6.33301 17.5038 6.33301 16.5833ZM11.333 16.5833C11.333 15.6629 12.0792 14.9167 12.9997 14.9167C13.9201 14.9167 14.6663 15.6629 14.6663 16.5833C14.6663 17.5038 13.9201 18.25 12.9997 18.25C12.0792 18.25 11.333 17.5038 11.333 16.5833ZM6.33301 10.75C6.33301 9.82953 7.0792 9.08333 7.99967 9.08333C8.92015 9.08333 9.66634 9.82953 9.66634 10.75C9.66634 11.6705 8.92015 12.4167 7.99967 12.4167C7.0792 12.4167 6.33301 11.6705 6.33301 10.75ZM11.333 10.75C11.333 9.82953 12.0792 9.08333 12.9997 9.08333C13.9201 9.08333 14.6663 9.82953 14.6663 10.75C14.6663 11.6705 13.9201 12.4167 12.9997 12.4167C12.0792 12.4167 11.333 11.6705 11.333 10.75ZM6.33301 4.91667C6.33301 3.99619 7.0792 3.25 7.99967 3.25C8.92015 3.25 9.66634 3.99619 9.66634 4.91667C9.66634 5.83714 8.92015 6.58333 7.99967 6.58333C7.0792 6.58333 6.33301 5.83714 6.33301 4.91667ZM11.333 4.91667C11.333 3.99619 12.0792 3.25 12.9997 3.25C13.9201 3.25 14.6663 3.99619 14.6663 4.91667C14.6663 5.83714 13.9201 6.58333 12.9997 6.58333C12.0792 6.58333 11.333 5.83714 11.333 4.91667Z" fill="#738496" />
</svg>)

export const HomeIconGradient = () => (<svg xmlns="http://www.w3.org/2000/svg" width="21" height="21" viewBox="0 0 21 21" fill="none">
	<path d="M18.5542 10.1276L11.0542 3.46096C10.9016 3.32508 10.7043 3.25 10.5 3.25C10.2957 3.25 10.0984 3.32508 9.94583 3.46096L2.44583 10.1276C2.36146 10.1996 2.29231 10.2877 2.24242 10.3867C2.19253 10.4857 2.16291 10.5937 2.15529 10.7044C2.14767 10.815 2.16221 10.926 2.19805 11.031C2.23389 11.1359 2.29032 11.2326 2.36402 11.3155C2.43772 11.3983 2.52722 11.4657 2.62727 11.5135C2.72732 11.5613 2.8359 11.5887 2.94667 11.594C3.05743 11.5993 3.16814 11.5825 3.27231 11.5445C3.37648 11.5065 3.47202 11.448 3.55333 11.3726L3.83249 11.1226V17.4168C3.83249 17.6378 3.92029 17.8498 4.07657 18.0061C4.23285 18.1623 4.44481 18.2501 4.66583 18.2501H7.99999C8.22101 18.2501 8.43297 18.1623 8.58925 18.0061C8.74553 17.8498 8.83333 17.6378 8.83333 17.4168V14.9168C8.83333 14.6958 8.92112 14.4838 9.0774 14.3275C9.23369 14.1713 9.44565 14.0835 9.66666 14.0835H11.3333C11.5543 14.0835 11.7663 14.1713 11.9226 14.3275C12.0789 14.4838 12.1667 14.6958 12.1667 14.9168V17.4168C12.1667 17.6378 12.2545 17.8498 12.4107 18.0061C12.567 18.1623 12.779 18.2501 13 18.2501H16.3333C16.5543 18.2501 16.7663 18.1623 16.9226 18.0061C17.0789 17.8498 17.1667 17.6378 17.1667 17.4168V11.1243L17.4458 11.3743C17.5276 11.4471 17.6229 11.503 17.7262 11.539C17.8296 11.5749 17.939 11.5902 18.0483 11.5838C18.1576 11.5775 18.2645 11.5497 18.363 11.502C18.4616 11.4543 18.5497 11.3877 18.6225 11.306C18.6953 11.2242 18.7512 11.1289 18.7872 11.0256C18.8231 10.9222 18.8384 10.8127 18.832 10.7035C18.8257 10.5942 18.7979 10.4873 18.7502 10.3888C18.7025 10.2902 18.6359 10.2021 18.5542 10.1293V10.1276Z" fill="url(#paint0_linear_576_63377)" />
	<defs>
		<linearGradient id="paint0_linear_576_63377" x1="4.91083" y1="7.66096" x2="16.0892" y2="18.8393" gradientUnits="userSpaceOnUse">
			<stop stop-color="#8590FF" />
			<stop offset="1" stop-color="#2A3BEE" />
		</linearGradient>
	</defs>
</svg>)

export const PeoplesIconGradient = () => (<svg xmlns="http://www.w3.org/2000/svg" width="21" height="21" viewBox="0 0 21 21" fill="none">
	<path d="M18.7279 14.4144C18.6789 14.1409 18.6069 13.8713 18.509 13.6084C18.2077 12.7966 17.6474 12.0548 16.8711 11.599C16.1504 11.1749 15.2839 11.0146 14.4337 10.9839C14.2399 10.9772 14.0451 10.9762 13.8503 10.9839C13.3513 11.0031 12.8552 11.0741 12.3822 11.2228C11.8813 11.3802 11.4466 11.6364 11.0762 11.9598C11.9187 12.5125 12.5338 13.3473 12.8725 14.2599C12.9896 14.5756 13.0759 14.899 13.1345 15.2272C13.193 15.5525 13.1537 15.8691 13.0395 16.1541C14.357 16.1541 15.8578 16.1541 17.1685 16.1541C18.1511 16.1541 18.8919 15.3231 18.7279 14.4144Z" fill="url(#paint0_linear_576_63388)" />
	<path d="M14.2037 9.88695C15.4953 9.88695 16.5422 8.84005 16.5422 7.54846C16.5422 6.25687 15.4953 5.20996 14.2037 5.20996C12.9121 5.20996 11.8652 6.25687 11.8652 7.54846C11.8652 8.84005 12.9121 9.88695 14.2037 9.88695Z" fill="url(#paint1_linear_576_63388)" />
	<path d="M13.1341 15.2266C13.0746 14.8984 12.9892 14.5741 12.8721 14.2593C12.5334 13.3468 11.9183 12.512 11.0758 11.9592C11.0192 11.9218 10.9644 11.8825 10.9059 11.8479C10.0404 11.3393 9.00211 11.1465 7.98115 11.11C7.74795 11.1014 7.51479 11.1014 7.28159 11.11C6.68282 11.133 6.08693 11.2184 5.51981 11.3959C3.77626 11.9419 2.68138 13.4754 2.29371 15.145C2.03463 16.2591 2.93471 17.3146 4.14953 17.3146C6.02264 17.3146 8.90136 17.3146 11.2638 17.3146C12.091 17.3146 12.7733 16.8233 13.041 16.1535C13.1542 15.8685 13.1945 15.5519 13.136 15.2266H13.1341Z" fill="url(#paint2_linear_576_63388)" />
	<path d="M7.70523 9.79421C9.25483 9.79421 10.511 8.53804 10.511 6.98843C10.511 5.43882 9.25483 4.18262 7.70523 4.18262C6.15562 4.18262 4.89941 5.43882 4.89941 6.98843C4.89941 8.53804 6.15562 9.79421 7.70523 9.79421Z" fill="url(#paint3_linear_576_63388)" />
	<defs>
		<linearGradient id="paint0_linear_576_63388" x1="12.3449" y1="12.5005" x2="16.0474" y2="17.4377" gradientUnits="userSpaceOnUse">
			<stop stop-color="#8590FF" />
			<stop offset="1" stop-color="#2A3BEE" />
		</linearGradient>
		<linearGradient id="paint1_linear_576_63388" x1="12.6384" y1="6.58529" x2="16.1042" y2="9.70204" gradientUnits="userSpaceOnUse">
			<stop stop-color="#8590FF" />
			<stop offset="1" stop-color="#2A3BEE" />
		</linearGradient>
		<linearGradient id="paint2_linear_576_63388" x1="4.05324" y1="12.93" x2="8.23635" y2="19.5399" gradientUnits="userSpaceOnUse">
			<stop stop-color="#8590FF" />
			<stop offset="1" stop-color="#2A3BEE" />
		</linearGradient>
		<linearGradient id="paint3_linear_576_63388" x1="5.82711" y1="5.83277" x2="9.9855" y2="9.57235" gradientUnits="userSpaceOnUse">
			<stop stop-color="#8590FF" />
			<stop offset="1" stop-color="#2A3BEE" />
		</linearGradient>
	</defs>
</svg>)

export const PeopleIconGradient = () => (<svg xmlns="http://www.w3.org/2000/svg" width="21" height="21" viewBox="0 0 21 21" fill="none">
	<path d="M16.7194 14.6613C16.7194 16.7226 13.9352 18.3946 10.5003 18.3946C7.06546 18.3946 4.28125 16.7226 4.28125 14.6613C4.28125 12.5987 7.06546 10.9268 10.5003 10.9268C13.9352 10.9268 16.7194 12.5987 16.7194 14.6613Z" fill="url(#paint0_linear_576_63401)" />
	<path d="M6.98828 6.61712C6.98828 4.67702 8.56032 3.10547 10.4999 3.10547C12.4395 3.10547 14.0116 4.67718 14.0116 6.61712C14.0116 8.55673 12.4397 10.1304 10.4999 10.1304C8.56015 10.1304 6.98828 8.55673 6.98828 6.61712Z" fill="url(#paint1_linear_576_63401)" />
	<defs>
		<linearGradient id="paint0_linear_576_63401" x1="6.33749" y1="13.1228" x2="11.4774" y2="20.8214" gradientUnits="userSpaceOnUse">
			<stop stop-color="#8590FF" />
			<stop offset="1" stop-color="#2A3BEE" />
		</linearGradient>
		<linearGradient id="paint1_linear_576_63401" x1="8.14935" y1="5.17122" x2="13.3549" y2="9.85144" gradientUnits="userSpaceOnUse">
			<stop stop-color="#8590FF" />
			<stop offset="1" stop-color="#2A3BEE" />
		</linearGradient>
	</defs>
</svg>)

export const UserIcon = () => (<svg xmlns="http://www.w3.org/2000/svg" width="21" height="21" viewBox="0 0 21 21" fill="none">
	<path d="M15.4997 18.2503V16.5837C15.4997 15.9206 15.2361 15.2849 14.7673 14.8161C14.2984 14.3472 13.6627 14.0837 12.9997 14.0837H7.99967C7.33663 14.0837 6.70094 14.3472 6.2321 14.8161C5.76326 15.2849 5.49967 15.9206 5.49967 16.5837V18.2503C5.49967 18.7106 5.12658 19.0837 4.66634 19.0837C4.2061 19.0837 3.83301 18.7106 3.83301 18.2503V16.5837C3.83301 15.4786 4.27231 14.4191 5.05371 13.6377C5.83511 12.8563 6.89461 12.417 7.99967 12.417H12.9997C14.1047 12.417 15.1642 12.8563 15.9456 13.6377C16.727 14.4191 17.1663 15.4786 17.1663 16.5837V18.2503C17.1663 18.7106 16.7932 19.0837 16.333 19.0837C15.8728 19.0837 15.4997 18.7106 15.4997 18.2503ZM12.9997 6.58366C12.9997 5.20295 11.8804 4.08366 10.4997 4.08366C9.11896 4.08366 7.99967 5.20295 7.99967 6.58366C7.99967 7.96437 9.11896 9.08366 10.4997 9.08366C11.8804 9.08366 12.9997 7.96437 12.9997 6.58366ZM14.6663 6.58366C14.6663 8.88485 12.8009 10.7503 10.4997 10.7503C8.19849 10.7503 6.33301 8.88485 6.33301 6.58366C6.33301 4.28247 8.19849 2.41699 10.4997 2.41699C12.8009 2.41699 14.6663 4.28247 14.6663 6.58366Z" fill="var(--zencom-font-color)" />
</svg>)

export const BookMarkIcon = () => (<svg xmlns="http://www.w3.org/2000/svg" width="21" height="21" viewBox="0 0 21 21" fill="none">
	<path d="M15.4997 4.91699C15.4997 4.69598 15.4118 4.48408 15.2555 4.3278C15.0993 4.17152 14.8874 4.08366 14.6663 4.08366H6.33301C6.11199 4.08366 5.9001 4.17152 5.74382 4.3278C5.58753 4.48408 5.49967 4.69598 5.49967 4.91699V16.814L10.0863 14.1935L10.1847 14.1455C10.4201 14.0494 10.6889 14.0654 10.9131 14.1935L15.4997 16.814V4.91699ZM17.1663 18.2503C17.1663 18.5474 17.0082 18.8223 16.7513 18.9714C16.4944 19.1204 16.1775 19.1212 15.9196 18.9738L10.4997 15.8765L5.07975 18.9738C4.82187 19.1212 4.50496 19.1204 4.24805 18.9714C3.99112 18.8223 3.83301 18.5474 3.83301 18.2503V4.91699C3.83301 4.25395 4.09659 3.61826 4.56543 3.14941C5.03427 2.68057 5.66997 2.41699 6.33301 2.41699H14.6663C15.3294 2.41699 15.9651 2.68057 16.4339 3.14941C16.9028 3.61825 17.1663 4.25395 17.1663 4.91699V18.2503Z" fill="var(--zencom-font-color)" />
</svg>)

export const UsersIcon = () => (<svg xmlns="http://www.w3.org/2000/svg" width="21" height="21" viewBox="0 0 21 21" fill="none">
	<path d="M12.9997 18.2503V16.5837C12.9997 15.9206 12.7361 15.2849 12.2673 14.8161C11.7984 14.3472 11.1627 14.0837 10.4997 14.0837H5.49967C4.83663 14.0837 4.20094 14.3472 3.7321 14.8161C3.26326 15.2849 2.99967 15.9206 2.99967 16.5837V18.2503C2.99967 18.7106 2.62658 19.0837 2.16634 19.0837C1.7061 19.0837 1.33301 18.7106 1.33301 18.2503V16.5837C1.33301 15.4786 1.77231 14.4191 2.55371 13.6377C3.33511 12.8563 4.39461 12.417 5.49967 12.417H10.4997C11.6047 12.417 12.6642 12.8563 13.4456 13.6377C14.227 14.4191 14.6663 15.4786 14.6663 16.5837V18.2503C14.6663 18.7106 14.2932 19.0837 13.833 19.0837C13.3728 19.0837 12.9997 18.7106 12.9997 18.2503ZM17.9997 18.2503V16.5845L17.9907 16.3778C17.9506 15.8976 17.7726 15.4377 17.4756 15.0545C17.1362 14.6168 16.661 14.3043 16.1247 14.1659C15.679 14.0508 15.4115 13.5959 15.5265 13.1502C15.6417 12.7047 16.0958 12.437 16.5413 12.5521C17.4352 12.7829 18.2275 13.3036 18.7931 14.0332C19.3587 14.7628 19.6656 15.6597 19.6663 16.5828V18.2503C19.6663 18.7106 19.2932 19.0837 18.833 19.0837C18.3728 19.0837 17.9997 18.7106 17.9997 18.2503ZM10.4997 6.58366C10.4997 5.20295 9.38039 4.08366 7.99967 4.08366C6.61896 4.08366 5.49967 5.20295 5.49967 6.58366C5.49967 7.96437 6.61896 9.08366 7.99967 9.08366C9.38039 9.08366 10.4997 7.96437 10.4997 6.58366ZM15.5062 6.58773C15.5062 6.03266 15.3216 5.49301 14.9813 5.05452C14.6409 4.61609 14.164 4.30353 13.6263 4.16585C13.1805 4.05168 12.9116 3.5977 13.0257 3.15186C13.1399 2.70606 13.5939 2.43713 14.0397 2.55127C14.936 2.78075 15.7307 3.30236 16.298 4.0332C16.8651 4.76396 17.1728 5.66273 17.1728 6.58773C17.1728 7.51291 16.8653 8.41222 16.298 9.14307C15.7307 9.87387 14.9359 10.3947 14.0397 10.6242C13.5939 10.7383 13.1399 10.4695 13.0257 10.0236C12.9116 9.57777 13.1805 9.12375 13.6263 9.0096C14.164 8.87191 14.6409 8.55943 14.9813 8.12093C15.3217 7.68243 15.5062 7.14283 15.5062 6.58773ZM12.1663 6.58366C12.1663 8.88485 10.3009 10.7503 7.99967 10.7503C5.69849 10.7503 3.83301 8.88485 3.83301 6.58366C3.83301 4.28247 5.69849 2.41699 7.99967 2.41699C10.3009 2.41699 12.1663 4.28247 12.1663 6.58366Z" fill="var(--zencom-font-color)" />
</svg>)

export const LogOutIcon = () => (<svg xmlns="http://www.w3.org/2000/svg" width="21" height="21" viewBox="0 0 21 21" fill="none">
	<path d="M2.16699 16.5837V4.91699C2.16699 4.25395 2.43057 3.61826 2.89941 3.14941C3.36826 2.68057 4.00395 2.41699 4.66699 2.41699H8.00033C8.46056 2.41699 8.83366 2.79009 8.83366 3.25033C8.83366 3.71056 8.46056 4.08366 8.00033 4.08366H4.66699C4.44598 4.08366 4.23408 4.17152 4.0778 4.3278C3.92152 4.48408 3.83366 4.69598 3.83366 4.91699V16.5837C3.83366 16.8047 3.92152 17.0166 4.0778 17.1729C4.23408 17.3291 4.44598 17.417 4.66699 17.417H8.00033C8.46056 17.417 8.83366 17.7901 8.83366 18.2503C8.83366 18.7106 8.46056 19.0837 8.00033 19.0837H4.66699C4.00395 19.0837 3.36825 18.8201 2.89941 18.3512C2.43057 17.8824 2.16699 17.2467 2.16699 16.5837ZM13.2445 5.99447C13.5699 5.66903 14.0974 5.66903 14.4229 5.99447L18.5895 10.1611C18.915 10.4866 18.915 11.0141 18.5895 11.3395L14.4229 15.5062C14.0974 15.8316 13.5699 15.8316 13.2445 15.5062C12.919 15.1807 12.919 14.6532 13.2445 14.3278L15.9886 11.5837H8.00033C7.54009 11.5837 7.16699 11.2106 7.16699 10.7503C7.16699 10.2901 7.54009 9.91699 8.00033 9.91699H15.9886L13.2445 7.17285C12.919 6.84741 12.919 6.3199 13.2445 5.99447Z" fill="var(--zencom-font-color)" />
</svg>)

export const checkDouble = () => (<svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 20 20" fill="none">
	<path d="M17.7437 7.74416C18.0692 7.41872 18.5967 7.41872 18.9221 7.74416C19.2476 8.0696 19.2476 8.59711 18.9221 8.92254L12.6721 15.1725C12.3467 15.498 11.8192 15.498 11.4938 15.1725L10.2438 13.9225C9.91831 13.5971 9.91831 13.0696 10.2438 12.7442C10.5692 12.4187 11.0967 12.4187 11.4221 12.7442L12.0829 13.405L17.7437 7.74416ZM14.4104 4.41083C14.7359 4.08539 15.2634 4.08539 15.5888 4.41083C15.9142 4.73626 15.9142 5.26377 15.5888 5.58921L6.42214 14.7559C6.0967 15.0813 5.56919 15.0813 5.24375 14.7559L1.07709 10.5892C0.751649 10.2638 0.751649 9.73626 1.07709 9.41083C1.40252 9.08539 1.93003 9.08539 2.25547 9.41083L5.83294 12.9883L14.4104 4.41083Z" fill="var(--zencom-font-color)" />
</svg>)

export const calenderLIght = () => (<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 16 16" fill="none">
	<path d="M13.3335 7.33317H2.66683V13.3332C2.66683 13.7014 2.96531 13.9998 3.3335 13.9998H12.6668C13.035 13.9998 13.3335 13.7014 13.3335 13.3332V7.33317ZM5.34001 11.3332C5.7082 11.3332 6.00667 11.6316 6.00667 11.9998C6.00667 12.368 5.7082 12.6665 5.34001 12.6665H5.3335C4.96531 12.6665 4.66683 12.368 4.66683 11.9998C4.66683 11.6316 4.96531 11.3332 5.3335 11.3332H5.34001ZM8.00667 11.3332C8.37486 11.3332 8.67334 11.6316 8.67334 11.9998C8.67334 12.368 8.37486 12.6665 8.00667 12.6665H8.00016C7.63197 12.6665 7.3335 12.368 7.3335 11.9998C7.3335 11.6316 7.63197 11.3332 8.00016 11.3332H8.00667ZM10.6733 11.3332C11.0415 11.3332 11.34 11.6316 11.34 11.9998C11.34 12.368 11.0415 12.6665 10.6733 12.6665H10.6668C10.2986 12.6665 10.0002 12.368 10.0002 11.9998C10.0002 11.6316 10.2986 11.3332 10.6668 11.3332H10.6733ZM5.34001 8.6665C5.7082 8.6665 6.00667 8.96498 6.00667 9.33317C6.00667 9.70136 5.7082 9.99984 5.34001 9.99984H5.3335C4.96531 9.99984 4.66683 9.70136 4.66683 9.33317C4.66683 8.96498 4.96531 8.6665 5.3335 8.6665H5.34001ZM8.00667 8.6665C8.37486 8.6665 8.67334 8.96498 8.67334 9.33317C8.67334 9.70136 8.37486 9.99984 8.00667 9.99984H8.00016C7.63197 9.99984 7.3335 9.70136 7.3335 9.33317C7.3335 8.96498 7.63197 8.6665 8.00016 8.6665H8.00667ZM10.6733 8.6665C11.0415 8.6665 11.34 8.96498 11.34 9.33317C11.34 9.70136 11.0415 9.99984 10.6733 9.99984H10.6668C10.2986 9.99984 10.0002 9.70136 10.0002 9.33317C10.0002 8.96498 10.2986 8.6665 10.6668 8.6665H10.6733ZM10.0002 3.99984V3.33317H6.00016V3.99984C6.00016 4.36803 5.70169 4.6665 5.3335 4.6665C4.96531 4.6665 4.66683 4.36803 4.66683 3.99984V3.33317H3.3335C2.96531 3.33317 2.66683 3.63165 2.66683 3.99984V5.99984H13.3335V3.99984C13.3335 3.63165 13.035 3.33317 12.6668 3.33317H11.3335V3.99984C11.3335 4.36803 11.035 4.6665 10.6668 4.6665C10.2986 4.6665 10.0002 4.36803 10.0002 3.99984ZM14.6668 13.3332C14.6668 14.4377 13.7714 15.3332 12.6668 15.3332H3.3335C2.22893 15.3332 1.3335 14.4377 1.3335 13.3332V3.99984C1.3335 2.89527 2.22893 1.99984 3.3335 1.99984H4.66683V1.33317C4.66683 0.964981 4.96531 0.666504 5.3335 0.666504C5.70169 0.666504 6.00016 0.964981 6.00016 1.33317V1.99984H10.0002V1.33317C10.0002 0.964981 10.2986 0.666504 10.6668 0.666504C11.035 0.666504 11.3335 0.964981 11.3335 1.33317V1.99984H12.6668C13.7714 1.99984 14.6668 2.89527 14.6668 3.99984V13.3332Z" fill="#454F59" />
</svg>)

export const timer = () => (<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 16 16" fill="none">
	<path d="M12.6667 9.33317C12.6667 6.75584 10.5773 4.6665 8 4.6665C5.42267 4.6665 3.33333 6.75584 3.33333 9.33317C3.33333 11.9105 5.42267 13.9998 8 13.9998C10.5773 13.9998 12.6667 11.9105 12.6667 9.33317ZM9.52865 6.86182C9.789 6.60147 10.211 6.60147 10.4714 6.86182C10.7317 7.12217 10.7317 7.54418 10.4714 7.80452L8.47135 9.80452C8.21101 10.0649 7.789 10.0649 7.52865 9.80452C7.2683 9.54418 7.2683 9.12216 7.52865 8.86182L9.52865 6.86182ZM9.33333 0.666504C9.70152 0.666504 10 0.964981 10 1.33317C10 1.70136 9.70152 1.99984 9.33333 1.99984H6.66667C6.29848 1.99984 6 1.70136 6 1.33317C6 0.964981 6.29848 0.666504 6.66667 0.666504H9.33333ZM14 9.33317C14 12.6469 11.3137 15.3332 8 15.3332C4.68629 15.3332 2 12.6469 2 9.33317C2 6.01946 4.68629 3.33317 8 3.33317C11.3137 3.33317 14 6.01946 14 9.33317Z" fill="#454F59" />
</svg>)

export const search = () => (<svg xmlns="http://www.w3.org/2000/svg" width="17" height="16" viewBox="0 0 17 16" fill="none">
	<g opacity="0.7">
		<path d="M12.4997 7.33301C12.4997 4.75568 10.4103 2.66634 7.83301 2.66634C5.25568 2.66634 3.16634 4.75568 3.16634 7.33301C3.16634 9.91034 5.25568 11.9997 7.83301 11.9997C10.4103 11.9997 12.4997 9.91034 12.4997 7.33301ZM13.833 7.33301C13.833 8.74965 13.3409 10.0507 12.5199 11.0771L14.971 13.5283C15.2314 13.7887 15.2314 14.2107 14.971 14.471C14.7107 14.7314 14.2887 14.7314 14.0283 14.471L11.5771 12.0199C10.5507 12.8409 9.24965 13.333 7.83301 13.333C4.5193 13.333 1.83301 10.6467 1.83301 7.33301C1.83301 4.0193 4.5193 1.33301 7.83301 1.33301C11.1467 1.33301 13.833 4.0193 13.833 7.33301Z" fill="currentColor" />
	</g>
</svg>)

export const edit = () => (<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 16 16" fill="var(--zencom-font-color)">
	<path d="M14.0001 3.21224C14.0001 2.89064 13.872 2.58225 13.6446 2.35482C13.4173 2.12749 13.1093 1.99947 12.7879 1.99935C12.4664 1.99931 12.1572 2.12633 11.9298 2.35352L11.9304 2.35417L10.9474 3.33724L12.6622 5.05208L13.6446 4.06966L13.7254 3.98047C13.9021 3.76477 14 3.49355 14.0001 3.21224ZM3.03199 11.2546L2.97796 11.3158C2.92777 11.3799 2.88933 11.4529 2.86533 11.5312L2.16611 13.832L4.47079 13.1335L4.54697 13.1055C4.62142 13.0725 4.68948 13.0259 4.74749 12.9681L11.7195 5.99479L10.0046 4.27995L3.03199 11.2546ZM15.3334 3.21224C15.3333 3.84531 15.0976 4.45424 14.6746 4.92122L14.5873 5.01237L13.1954 6.40365C13.1777 6.42673 13.1592 6.44958 13.1381 6.4707C13.1168 6.49199 13.0937 6.51084 13.0704 6.52865L5.68889 13.9121C5.45709 14.1432 5.17196 14.3143 4.85882 14.4095L1.95647 15.2897L1.76246 14.6517L1.77874 14.7057L1.95647 15.2897L1.95452 15.2904L1.82301 15.3203C1.69037 15.3413 1.5544 15.335 1.42327 15.3021C1.2483 15.2581 1.08809 15.1678 0.960377 15.0404C0.832625 14.9128 0.741652 14.7525 0.697356 14.5775C0.653148 14.4026 0.65682 14.219 0.708424 14.0462L0.709726 14.0436L1.32756 14.2305L1.3471 14.237L0.709726 14.0436L1.58993 11.1419L2.22796 11.3353L2.14397 11.3092L1.58993 11.1419L1.59059 11.14L1.6303 11.0241C1.71637 10.7946 1.84401 10.5831 2.0066 10.3997L2.09059 10.3099L9.47275 2.92578C9.48993 2.90359 9.50837 2.8817 9.52874 2.86133C9.54926 2.84082 9.57082 2.82196 9.59319 2.80469L10.9871 1.41146L11.0789 1.32422C11.5459 0.901461 12.1549 0.665936 12.7879 0.666016C13.463 0.66614 14.1106 0.934632 14.588 1.41211C15.0653 1.8896 15.3335 2.5371 15.3334 3.21224Z" fill="var(--zencom-font-color)" />
</svg>)

export const star = () => (<svg xmlns="http://www.w3.org/2000/svg" width="19" height="20" viewBox="0 0 19 20" fill="var(--zencom-font-color)">
	<path d="M9.60254 0.837077C9.80525 0.853631 10.0007 0.919851 10.1722 1.02913L10.256 1.08691L10.335 1.15202C10.4864 1.28772 10.6021 1.45854 10.6727 1.64925L10.7044 1.74609L10.7093 1.76237L12.0269 6.87549C12.0641 7.01956 12.1389 7.15112 12.2441 7.25635C12.3494 7.36153 12.4809 7.43643 12.625 7.47363L17.7373 8.79118L17.7511 8.79525L17.8488 8.82617C18.0402 8.89629 18.2113 9.0124 18.3477 9.1639L18.4136 9.24284L18.4722 9.32666C18.6002 9.527 18.6691 9.7605 18.6691 9.99967C18.6691 10.2732 18.5793 10.5397 18.4136 10.7573C18.2478 10.975 18.0149 11.1322 17.7511 11.2049L17.7373 11.2082L17.5298 10.4017L17.5282 10.3976L17.7373 11.2082L12.625 12.5257C12.4809 12.5629 12.3494 12.6385 12.2441 12.7438C12.139 12.8489 12.0633 12.98 12.026 13.1239L12.0269 13.1247L10.7085 18.237L10.7036 18.2533L9.91911 18.0335L9.9012 18.0286L10.7036 18.2533C10.6301 18.516 10.4725 18.7476 10.2552 18.9124C10.0379 19.0773 9.77278 19.1671 9.5 19.1672C9.22723 19.1672 8.96211 19.0773 8.74479 18.9124C8.52745 18.7476 8.36991 18.516 8.29639 18.2533L9.10286 18.027L9.08496 18.0319L8.29639 18.2533L8.2915 18.237L6.97396 13.1247L8.58854 12.7088L9.49919 16.2464L10.4123 12.7088L11.6948 13.0392L11.1268 12.8919L10.4123 12.7088L10.4595 12.5477C10.5817 12.1781 10.7894 11.8418 11.0658 11.5654C11.3817 11.2495 11.7766 11.0235 12.2091 10.9119L15.7484 9.99967L12.2091 9.0874C11.7766 8.97582 11.3816 8.75057 11.0658 8.43473C10.7893 8.15828 10.5817 7.82141 10.4595 7.45166L10.4123 7.29134L9.5 3.75212L8.58773 7.29134L8.09212 7.16357L7.76986 7.08057L8.58773 7.29134C8.4759 7.72355 8.25086 8.11915 7.93506 8.43473C7.65867 8.71092 7.32152 8.91726 6.95199 9.03939L6.79167 9.08659L3.25326 9.99886L6.79167 10.9119L6.95199 10.9591C7.32177 11.0814 7.65858 11.289 7.93506 11.5654C8.25079 11.8812 8.4761 12.2756 8.58773 12.708L8.58854 12.7088L6.97396 13.1247C6.93676 12.9806 6.86188 12.8491 6.75667 12.7438C6.67762 12.6648 6.58369 12.6025 6.48079 12.5607L6.37581 12.5257L1.26351 11.2074L1.47103 10.4017L1.46696 10.4155L1.26351 11.2074L1.24398 11.2025L1.14714 11.1707C0.925487 11.0879 0.731564 10.9432 0.588053 10.7533C0.444548 10.5633 0.358245 10.3373 0.33903 10.1014L0.334961 9.99967L0.33903 9.89795C0.358311 9.66224 0.444631 9.43589 0.588053 9.24609L0.652344 9.16797C0.809875 8.99136 1.01498 8.86269 1.24398 8.79769L1.2627 8.79199L1.46615 9.58301L1.46777 9.58708L1.2627 8.79199L6.37581 7.47282L6.48079 7.43783C6.58363 7.3961 6.67764 7.3345 6.75667 7.25553C6.86174 7.15054 6.93661 7.01924 6.97396 6.87549L8.29232 1.76237L9.10368 1.97152L9.09961 1.9707L8.29232 1.76237C8.29372 1.75691 8.29568 1.75152 8.2972 1.74609C8.37073 1.48342 8.52828 1.25177 8.74561 1.08691L8.82861 1.02913C9.02882 0.901442 9.26196 0.833008 9.50081 0.833008L9.60254 0.837077ZM2 15.833C1.53993 15.8328 1.16667 15.4598 1.16667 14.9997C1.16677 14.5682 1.49514 14.2138 1.91536 14.1712L2 14.1663C2.00011 13.7063 2.37333 13.3332 2.83333 13.333C3.26492 13.333 3.62008 13.6613 3.6626 14.0817L3.66667 14.1663L3.75212 14.1712C4.1723 14.2139 4.49989 14.5683 4.5 14.9997C4.5 15.4312 4.17238 15.7863 3.75212 15.8289L3.66667 15.833C3.66667 16.2932 3.29357 16.6663 2.83333 16.6663C2.40204 16.6662 2.04757 16.3385 2.00488 15.9185L2 15.833ZM15.3333 5.83301V4.99967H14.5C14.0399 4.99948 13.6667 4.62646 13.6667 4.16634C13.6668 3.70632 14.04 3.3332 14.5 3.33301H15.3333V2.49967C15.3334 2.03965 15.7067 1.66653 16.1667 1.66634C16.6268 1.66634 16.9999 2.03953 17 2.49967V3.33301H17.8333C18.2935 3.33301 18.6666 3.7062 18.6667 4.16634C18.6667 4.62658 18.2936 4.99967 17.8333 4.99967H17V5.83301C17 6.29324 16.6269 6.66634 16.1667 6.66634C15.7066 6.66615 15.3333 6.29313 15.3333 5.83301Z" fill="var(--zencom-font-color)" />
</svg>)

export const arrowRight = () => (<svg xmlns="http://www.w3.org/2000/svg" width="12" height="12" viewBox="0 0 12 12" fill="none">
	<path d="M5.52848 0.861949C5.78883 0.6016 6.21084 0.6016 6.47119 0.861949L11.1379 5.52862C11.3982 5.78897 11.3982 6.21098 11.1379 6.47132L6.47119 11.138C6.21084 11.3983 5.78883 11.3983 5.52848 11.138C5.26813 10.8776 5.26813 10.4556 5.52848 10.1953L9.05713 6.66664H1.33317C0.964981 6.66664 0.666504 6.36816 0.666504 5.99997C0.666504 5.63178 0.964981 5.3333 1.33317 5.3333H9.05713L5.52848 1.80466C5.26813 1.54431 5.26813 1.1223 5.52848 0.861949Z" fill="var(--zencom-font-color)" />
</svg>)

export const personAdd = () => (<svg xmlns="http://www.w3.org/2000/svg" width="15" height="14" viewBox="0 0 15 14" fill="none">
	<path d="M9.49984 13.1265V11.7932C9.49984 11.2627 9.28897 10.7542 8.9139 10.3791C8.53883 10.004 8.03027 9.79317 7.49984 9.79317H3.49984C2.9694 9.79317 2.46085 10.004 2.08577 10.3791C1.7107 10.7542 1.49984 11.2627 1.49984 11.7932V13.1265C1.49984 13.4947 1.20136 13.7932 0.833171 13.7932C0.464981 13.7932 0.166504 13.4947 0.166504 13.1265V11.7932C0.166504 10.9091 0.517945 10.0615 1.14307 9.4364C1.76819 8.81128 2.61578 8.45984 3.49984 8.45984H7.49984C8.38389 8.45984 9.23149 8.81128 9.85661 9.4364C10.4817 10.0615 10.8332 10.9091 10.8332 11.7932V13.1265C10.8332 13.4947 10.5347 13.7932 10.1665 13.7932C9.79831 13.7932 9.49984 13.4947 9.49984 13.1265ZM11.4998 8.45984V7.12651H10.1665C9.79831 7.12651 9.49984 6.82803 9.49984 6.45984C9.49984 6.09165 9.79831 5.79317 10.1665 5.79317H11.4998V4.45984C11.4998 4.09165 11.7983 3.79317 12.1665 3.79317C12.5347 3.79317 12.8332 4.09165 12.8332 4.45984V5.79317H14.1665C14.5347 5.79317 14.8332 6.09165 14.8332 6.45984C14.8332 6.82803 14.5347 7.12651 14.1665 7.12651H12.8332V8.45984C12.8332 8.82803 12.5347 9.12651 12.1665 9.12651C11.7983 9.12651 11.4998 8.82803 11.4998 8.45984ZM7.49984 3.79317C7.49984 2.6886 6.60441 1.79317 5.49984 1.79317C4.39527 1.79317 3.49984 2.6886 3.49984 3.79317C3.49984 4.89774 4.39527 5.79317 5.49984 5.79317C6.60441 5.79317 7.49984 4.89774 7.49984 3.79317ZM8.83317 3.79317C8.83317 5.63412 7.34079 7.12651 5.49984 7.12651C3.65889 7.12651 2.1665 5.63412 2.1665 3.79317C2.1665 1.95222 3.65889 0.459839 5.49984 0.459839C7.34079 0.459839 8.83317 1.95222 8.83317 3.79317Z" fill="var(--zencom-font-color)" />
</svg>)

export const personJoined = () => (<svg xmlns="http://www.w3.org/2000/svg" width="17" height="17" viewBox="0 0 17 17" fill="none">
	<path d="M10.4998 14.1265V12.7932C10.4998 12.2627 10.289 11.7542 9.9139 11.3791C9.53883 11.004 9.03027 10.7932 8.49984 10.7932H4.49984C3.9694 10.7932 3.46085 11.004 3.08577 11.3791C2.7107 11.7542 2.49984 12.2627 2.49984 12.7932V14.1265C2.49984 14.4947 2.20136 14.7932 1.83317 14.7932C1.46498 14.7932 1.1665 14.4947 1.1665 14.1265V12.7932C1.1665 11.9091 1.51795 11.0615 2.14307 10.4364C2.76819 9.81128 3.61578 9.45984 4.49984 9.45984H8.49984C9.38389 9.45984 10.2315 9.81128 10.8566 10.4364C11.4817 11.0615 11.8332 11.9091 11.8332 12.7932V14.1265C11.8332 14.4947 11.5347 14.7932 11.1665 14.7932C10.7983 14.7932 10.4998 14.4947 10.4998 14.1265ZM14.6951 5.65515C14.9555 5.3948 15.3775 5.3948 15.6379 5.65515C15.8982 5.9155 15.8982 6.33751 15.6379 6.59786L12.9712 9.26453C12.7108 9.52488 12.2888 9.52488 12.0285 9.26453L10.6951 7.93119C10.4348 7.67084 10.4348 7.24883 10.6951 6.98848C10.9555 6.72814 11.3775 6.72814 11.6379 6.98848L12.4998 7.85046L14.6951 5.65515ZM8.49984 4.79317C8.49984 3.6886 7.60441 2.79317 6.49984 2.79317C5.39527 2.79317 4.49984 3.6886 4.49984 4.79317C4.49984 5.89774 5.39527 6.79317 6.49984 6.79317C7.60441 6.79317 8.49984 5.89774 8.49984 4.79317ZM9.83317 4.79317C9.83317 6.63412 8.34079 8.12651 6.49984 8.12651C4.65889 8.12651 3.1665 6.63412 3.1665 4.79317C3.1665 2.95222 4.65889 1.45984 6.49984 1.45984C8.34079 1.45984 9.83317 2.95222 9.83317 4.79317Z" fill="var(--zencom-font-color)" />
</svg>)

export const personEdit = () => (<svg xmlns="http://www.w3.org/2000/svg" width="16" height="14" viewBox="0 0 16 14" fill="none">
	<path d="M0.666992 13.0007V11.6673C0.666992 10.7833 1.01843 9.93567 1.64355 9.31055C2.26868 8.68543 3.11627 8.33398 4.00033 8.33398H6.66699C7.03518 8.33398 7.33366 8.63246 7.33366 9.00065C7.33366 9.36884 7.03518 9.66732 6.66699 9.66732H4.00033C3.46989 9.66732 2.96134 9.87818 2.58626 10.2533C2.21119 10.6283 2.00033 11.1369 2.00033 11.6673V13.0007C2.00033 13.3688 1.70185 13.6673 1.33366 13.6673C0.965469 13.6673 0.666992 13.3688 0.666992 13.0007ZM13.3337 9.00065C13.3337 8.86491 13.3128 8.73408 13.2751 8.61068C13.2374 8.56234 13.2052 8.50832 13.1813 8.44857C13.1641 8.40557 13.1514 8.36158 13.1436 8.31771C12.9107 7.92869 12.4867 7.66732 12.0003 7.66732C11.8646 7.66732 11.7337 7.68759 11.6104 7.72526C11.5619 7.76306 11.5081 7.79568 11.4482 7.81966C11.4053 7.83685 11.3612 7.84891 11.3174 7.85677C10.9282 8.08962 10.667 8.51416 10.667 9.00065C10.667 9.13611 10.6874 9.2668 10.7249 9.38997C10.7629 9.43849 10.7953 9.49269 10.8193 9.55273C10.8364 9.59549 10.8486 9.63933 10.8564 9.68294C11.0892 10.0724 11.5136 10.334 12.0003 10.334C12.1359 10.334 12.2664 10.313 12.3896 10.2754C12.4381 10.2376 12.4925 10.2056 12.5524 10.1816C12.5952 10.1645 12.639 10.1518 12.6826 10.1439C13.0719 9.91105 13.3337 9.48723 13.3337 9.00065ZM8.00033 3.66732C8.00033 2.56275 7.1049 1.66732 6.00033 1.66732C4.89576 1.66732 4.00033 2.56275 4.00033 3.66732C4.00033 4.77189 4.89576 5.66732 6.00033 5.66732C7.10489 5.66732 8.00033 4.77189 8.00033 3.66732ZM14.667 9.00065C14.667 9.09923 14.6611 9.19651 14.6507 9.29232L14.6781 9.30143C15.0272 9.41792 15.2156 9.79535 15.0993 10.1445C14.9829 10.4938 14.6055 10.6828 14.2562 10.5664L14.1768 10.5397C14.0258 10.7528 13.8446 10.9424 13.639 11.1029L13.6859 11.2194C13.8226 11.5612 13.6566 11.9498 13.3148 12.0866C12.9729 12.2233 12.585 12.0567 12.4482 11.7148L12.4157 11.6348C12.2803 11.6559 12.1416 11.6673 12.0003 11.6673C11.9015 11.6673 11.804 11.6615 11.708 11.651L11.6995 11.6784C11.5831 12.0275 11.2056 12.2159 10.8564 12.0996C10.5071 11.9832 10.3181 11.6058 10.4346 11.2565L10.4606 11.1771C10.2476 11.0261 10.0579 10.8449 9.89746 10.6393L9.78158 10.6862C9.43974 10.8229 9.05115 10.6569 8.91439 10.3151C8.77765 9.97326 8.94429 9.58532 9.28613 9.44857L9.36556 9.41602C9.34439 9.28068 9.33366 9.14193 9.33366 9.00065C9.33366 8.90187 9.33882 8.80433 9.34928 8.70833L9.32259 8.69987C8.97348 8.58338 8.78509 8.20595 8.90137 7.85677C9.0178 7.50747 9.39517 7.31846 9.74447 7.4349L9.82324 7.46094C9.97415 7.24795 10.1555 7.05821 10.361 6.89779L10.3148 6.7819C10.178 6.44007 10.3441 6.05148 10.6859 5.91471C11.0277 5.77797 11.4157 5.94462 11.5524 6.28646L11.5843 6.36589C11.7198 6.34466 11.8588 6.33398 12.0003 6.33398C12.0989 6.33398 12.1962 6.33919 12.292 6.34961L12.3011 6.32292C12.4176 5.97381 12.795 5.78542 13.1442 5.90169C13.4935 6.01812 13.6825 6.3955 13.5661 6.74479L13.5394 6.82357C13.7524 6.97446 13.9421 7.15583 14.1025 7.36133L14.2191 7.3151C14.5609 7.17837 14.9495 7.34439 15.0863 7.6862C15.223 8.02805 15.0564 8.41599 14.7145 8.55273L14.6344 8.58464C14.6557 8.72021 14.667 8.85912 14.667 9.00065ZM9.33366 3.66732C9.33366 5.50827 7.84127 7.00065 6.00033 7.00065C4.15938 7.00065 2.66699 5.50827 2.66699 3.66732C2.66699 1.82637 4.15938 0.333984 6.00033 0.333984C7.84127 0.333984 9.33366 1.82637 9.33366 3.66732Z" fill="var(--zencom-font-color)" />
</svg>)

export const outlineArrowRightIcon = () => (<svg xmlns="http://www.w3.org/2000/svg" width="14" height="15" viewBox="0 0 14 15" fill="none">
	<path d="M0.333496 12.1264V2.79309C0.333496 2.26266 0.544361 1.7541 0.919434 1.37903C1.29451 1.00396 1.80306 0.793091 2.3335 0.793091H5.00016C5.36835 0.793091 5.66683 1.09157 5.66683 1.45976C5.66683 1.82795 5.36835 2.12642 5.00016 2.12642H2.3335C2.15668 2.12642 1.98717 2.19671 1.86214 2.32174C1.73712 2.44676 1.66683 2.61628 1.66683 2.79309V12.1264C1.66683 12.3032 1.73712 12.4728 1.86214 12.5978C1.98717 12.7228 2.15669 12.7931 2.3335 12.7931H5.00016C5.36835 12.7931 5.66683 13.0916 5.66683 13.4598C5.66683 13.8279 5.36835 14.1264 5.00016 14.1264H2.3335C1.80306 14.1264 1.29451 13.9156 0.919434 13.5405C0.544361 13.1654 0.333496 12.6569 0.333496 12.1264ZM9.19548 3.65507C9.45582 3.39472 9.87783 3.39472 10.1382 3.65507L13.4715 6.9884C13.7319 7.24875 13.7319 7.67076 13.4715 7.93111L10.1382 11.2644C9.87783 11.5248 9.45582 11.5248 9.19548 11.2644C8.93513 11.0041 8.93513 10.5821 9.19548 10.3217L11.3908 8.12642H5.00016C4.63197 8.12642 4.3335 7.82795 4.3335 7.45976C4.3335 7.09157 4.63197 6.79309 5.00016 6.79309H11.3908L9.19548 4.59778C8.93513 4.33743 8.93513 3.91542 9.19548 3.65507Z" fill="#E2483D" />
</svg>)

export const notifyBellIcon = () => (<svg xmlns="http://www.w3.org/2000/svg" width="16" height="17" viewBox="0 0 16 17" fill="none">
	<path d="M8.54899 14.1387C8.72638 13.8161 9.13195 13.6983 9.45459 13.8757C9.77717 14.0531 9.89489 14.458 9.71761 14.7806C9.54851 15.0882 9.29969 15.3448 8.99756 15.5235C8.69547 15.7021 8.35111 15.7963 8.00017 15.7963C7.64922 15.7963 7.30486 15.7021 7.00277 15.5235C6.70064 15.3448 6.45183 15.0882 6.28272 14.7806C6.10544 14.458 6.22316 14.0531 6.54574 13.8757C6.86838 13.6983 7.27395 13.8161 7.45134 14.1387C7.50538 14.2369 7.58472 14.3186 7.68116 14.3757C7.77775 14.4328 7.88794 14.4629 8.00017 14.4629C8.11239 14.4629 8.22258 14.4328 8.31918 14.3757C8.41561 14.3186 8.49495 14.2369 8.54899 14.1387ZM14.3706 11.2383H14.37C14.6144 11.4013 14.7233 11.7052 14.6382 11.9864C14.553 12.2675 14.2939 12.4597 14.0002 12.4597H2.00017C1.70645 12.4597 1.44733 12.2675 1.36214 11.9864C1.2771 11.7055 1.38581 11.4021 1.62972 11.239L1.62712 11.2403L1.62451 11.2422C1.62964 11.2384 1.64131 11.229 1.65902 11.2142C1.6945 11.1847 1.75396 11.1326 1.82894 11.0534C1.97854 10.8955 2.19373 10.6294 2.41488 10.224C2.85543 9.41632 3.3335 8.02812 3.3335 5.79301C3.3335 3.22482 5.43198 1.12634 8.00017 1.12634C8.76596 1.12634 9.47964 1.28236 10.1903 1.67712C10.5121 1.85593 10.6282 2.26152 10.4494 2.58337C10.2706 2.90517 9.86497 3.02124 9.54313 2.84249C9.05382 2.57065 8.56765 2.45968 8.00017 2.45968C6.16836 2.45968 4.66683 3.9612 4.66683 5.79301C4.66683 8.22443 4.14486 9.83636 3.58545 10.862C3.53461 10.9552 3.48264 11.0431 3.43181 11.1263H12.5516C12.4577 10.975 12.3623 10.8083 12.2703 10.6244C12.1058 10.2951 12.2393 9.89451 12.5685 9.72986C12.8978 9.56523 13.2983 9.69883 13.4631 10.028C13.6995 10.5008 13.9455 10.8158 14.1219 11.0059C14.2103 11.1011 14.2817 11.1657 14.3263 11.2032L14.3706 11.2383ZM14.3778 11.2435C14.3776 11.2434 14.3764 11.2431 14.3752 11.2422C14.3747 11.2419 14.3744 11.2413 14.3739 11.2409C14.3762 11.2427 14.3778 11.2435 14.3778 11.2435ZM11.3335 7.79301V6.45968H10.0002C9.63198 6.45968 9.3335 6.1612 9.3335 5.79301C9.3335 5.42482 9.63198 5.12634 10.0002 5.12634H11.3335V3.79301C11.3335 3.42482 11.632 3.12634 12.0002 3.12634C12.3684 3.12634 12.6668 3.42482 12.6668 3.79301V5.12634H14.0002C14.3684 5.12634 14.6668 5.42482 14.6668 5.79301C14.6668 6.1612 14.3684 6.45968 14.0002 6.45968H12.6668V7.79301C12.6668 8.1612 12.3684 8.45968 12.0002 8.45968C11.632 8.45968 11.3335 8.1612 11.3335 7.79301Z" fill="var(--zencom-font-color)" />
</svg>)

export const errorPic = () => (
	<svg version="1.1" xmlns="http://www.w3.org/2000/svg" x="0px" y="0px"
		viewBox="0 0 500 500" style="enable-background:new 0 0 500 500;">
		<g id="BACKGROUND">
			<rect style="fill:#230B24;" width="500" height="500" />
			<g>
				<path style="opacity:0.3;fill:#6B80BF;" d="M78.427,69.487L78.427,69.487c0,8.26,6.696,14.955,14.956,14.955h39.791
			c6.716,0,12.161,5.445,12.161,12.161l0,0c0,6.716-5.444,12.16-12.161,12.16H24.577c-9.109,0-16.493,7.384-16.493,16.493v0
			c0,9.109,7.384,16.493,16.493,16.493h278.04c9.109,0,16.493-7.384,16.493-16.493v0c0-9.109-7.384-16.493-16.493-16.493h-78.504
			c-7.75,0-14.032-6.282-14.032-14.032l0,0c0-7.75,6.282-14.032,14.032-14.032h4.344c7.226,0,13.084-5.858,13.084-13.084l0,0
			c0-7.226-5.858-13.084-13.084-13.084H93.383C85.123,54.532,78.427,61.227,78.427,69.487z"/>
				<path style="opacity:0.3;fill:#6B80BF;" d="M500,32.934H369.553c-5.172,0-9.364,4.193-9.364,9.364l0,0
			c0,5.172,4.192,9.364,9.364,9.364h44.572c4.4,0,7.967,3.567,7.967,7.967l0,0c0,4.4-3.567,7.967-7.967,7.967h-2.466
			c-4.103,0-7.428,3.326-7.428,7.428l0,0c0,4.103,3.326,7.428,7.428,7.428h76.69c4.689,0,8.491-3.802,8.491-8.491l0,0
			c0-4.69-3.802-8.491-8.491-8.491h-22.592c-3.813,0-6.904-3.091-6.904-6.904l0,0c0-3.813,3.091-6.904,6.904-6.904H500V32.934z"/>
				<path style="opacity:0.2;fill:#6B80BF;" d="M500,204.243H276.861c-6.405,0-11.598,5.193-11.598,11.598l0,0
			c0,6.405,5.193,11.598,11.598,11.598h55.203c5.449,0,9.867,4.418,9.867,9.867l0,0c0,5.449-4.418,9.867-9.867,9.867h-3.055
			c-5.081,0-9.2,4.119-9.2,9.2l0,0c0,5.081,4.119,9.2,9.2,9.2h94.982c5.808,0,10.517-4.708,10.517-10.517l0,0
			c0-5.808-4.708-10.517-10.517-10.517h-27.98c-4.723,0-8.551-3.828-8.551-8.551l0,0c0-4.723,3.828-8.551,8.551-8.551H500V204.243z"
				/>
				<rect y="295.423" style="opacity:0.3;fill:#6B80BF;" width="500" height="81.39" />
			</g>
			<g>
				<g style="opacity:0.2;">
					<path style="fill:#5EC9F2;" d="M65.571,283.112c-1.28,0-2.559-0.488-3.535-1.464c-1.953-1.953-1.953-5.119,0-7.071l10.649-10.649
				c1.952-1.953,5.119-1.952,7.071-0.001c1.953,1.953,1.953,5.119,0.001,7.071l-10.648,10.65
				C68.131,282.624,66.851,283.112,65.571,283.112z"/>
				</g>
				<g style="opacity:0.2;">
					<path style="fill:#5EC9F2;" d="M323.751,83.388c-1.279,0-2.56-0.488-3.535-1.464c-1.953-1.953-1.953-5.119,0-7.071l10.648-10.648
				c1.951-1.952,5.119-1.952,7.07,0c1.953,1.953,1.953,5.119,0,7.071l-10.648,10.648C326.31,82.899,325.03,83.388,323.751,83.388z"
					/>
				</g>
				<g style="opacity:0.2;">
					<path style="fill:#5EC9F2;" d="M447.332,147.503c-1.279,0-2.56-0.488-3.535-1.464c-1.953-1.953-1.953-5.119,0-7.071
				l10.648-10.648c1.951-1.952,5.119-1.952,7.07,0c1.953,1.953,1.953,5.119,0,7.071l-10.648,10.648
				C449.892,147.015,448.611,147.503,447.332,147.503z"/>
				</g>
				<circle style="fill:#5EC9F2;" cx="65.571" cy="278.069" r="3.819" />
				<circle style="fill:#F18B53;" cx="130.379" cy="44.39" r="3.819" />
				<circle style="fill:#6B80BF;" cx="221.701" cy="95.814" r="2.097" />
				<circle style="fill:#F18B53;" cx="294.064" cy="123.141" r="3.819" />
				<path style="fill:#F18B53;" d="M195.277,162.624c0,1.054-0.855,1.909-1.909,1.909c-1.054,0-1.909-0.855-1.909-1.909
			c0-1.054,0.855-1.909,1.909-1.909C194.423,160.715,195.277,161.57,195.277,162.624z"/>
				<path style="fill:#F18B53;" d="M384.541,43.155c0,1.055-0.855,1.909-1.909,1.909c-1.054,0-1.909-0.855-1.909-1.909
			c0-1.054,0.855-1.909,1.909-1.909C383.686,41.245,384.541,42.1,384.541,43.155z"/>
				<circle style="fill:#5EC9F2;" cx="323.751" cy="78.388" r="3.819" />
				<circle style="fill:#5EC9F2;" cx="447.623" cy="142.504" r="3.819" />
				<circle style="fill:#5EC9F2;" cx="332.064" cy="247.173" r="2.891" />
				<circle style="fill:#230B24;" cx="414.789" cy="217.678" r="19.124" />
				<circle style="fill:#230B24;" cx="86.924" cy="81.479" r="13.013" />
				<path style="fill:#FFFFFF;" d="M406.883,115.68c0,1.054-0.855,1.909-1.909,1.909c-1.054,0-1.909-0.855-1.909-1.909
			c0-1.054,0.855-1.909,1.909-1.909C406.028,113.771,406.883,114.626,406.883,115.68z"/>
				<path style="fill:#FFFFFF;" d="M78.375,183.488c0,1.055-0.855,1.909-1.909,1.909c-1.055,0-1.909-0.855-1.909-1.909
			c0-1.054,0.855-1.909,1.909-1.909C77.52,181.578,78.375,182.433,78.375,183.488z"/>
				<path style="fill:#FFFFFF;" d="M181.515,69.648c0,1.055-0.855,1.909-1.909,1.909c-1.055,0-1.909-0.855-1.909-1.909
			c0-1.054,0.855-1.909,1.909-1.909C180.66,67.739,181.515,68.594,181.515,69.648z"/>
				<path style="fill:#FFFFFF;" d="M430.694,295.423c0,1.054-0.855,1.909-1.909,1.909c-1.054,0-1.909-0.855-1.909-1.909
			c0-1.054,0.855-1.909,1.909-1.909C429.839,293.514,430.694,294.369,430.694,295.423z"/>
				<path style="fill:#FFFFFF;" d="M416.698,228.288c0,1.054-0.855,1.909-1.909,1.909c-1.054,0-1.909-0.855-1.909-1.909
			c0-1.055,0.855-1.909,1.909-1.909C415.843,226.379,416.698,227.234,416.698,228.288z"/>
				<circle style="fill:#5EC9F2;" cx="86.924" cy="81.479" r="3.819" />
			</g>
			<g>

				<ellipse transform="matrix(0.2276 -0.9737 0.9737 0.2276 -23.5397 247.6933)" style="fill:#5EC9F2;" cx="144.366" cy="138.685" rx="21.838" ry="21.838" />

				<ellipse transform="matrix(0.2287 -0.9735 0.9735 0.2287 -30.7184 241.5662)" style="fill:#6B80BF;" cx="137.091" cy="140.169" rx="10.53" ry="10.53" />
				<path style="fill:#6B80BF;" d="M150.039,117.596c-0.044,0.341-0.074,0.686-0.074,1.038c0,4.484,3.635,8.119,8.119,8.119
			c1.407,0,2.73-0.359,3.884-0.989C159.074,121.827,154.891,118.898,150.039,117.596z"/>
				<path style="fill:#6B80BF;" d="M161.969,146.649c0,1.331-1.079,2.411-2.411,2.411c-1.331,0-2.411-1.079-2.411-2.411
			c0-1.331,1.079-2.411,2.411-2.411C160.89,144.238,161.969,145.318,161.969,146.649z"/>
			</g>
			<g>
				<path style="fill:#F18B53;" d="M420.96,128.055c-0.77-2.358-5.192-3.19-11.117-2.471c0.356,0.281,0.698,0.579,1.018,0.899
			c2.96-0.034,5.019,0.602,5.446,1.911c0.367,1.122-0.524,2.553-2.303,4.022c-2.281,1.883-6.023,3.831-10.45,5.277
			c-4.162,1.36-8.096,2.004-11.006,1.932c-2.6-0.064-4.382-0.7-4.777-1.908c-0.456-1.396,1.036-3.268,3.762-5.1
			c0.073-0.428,0.171-0.848,0.29-1.258c-5.506,2.983-8.803,6.398-8.008,8.83c0.763,2.335,5.104,3.174,10.941,2.492
			c2.945-0.344,6.27-1.074,9.71-2.198c3.658-1.195,6.947-2.672,9.618-4.237C418.902,133.425,421.699,130.316,420.96,128.055z"/>
				<path style="fill:#6B80BF;" d="M404.466,140.484c-3.44,1.124-6.765,1.854-9.71,2.198c2.063,2.041,4.899,3.302,8.031,3.302
			c5.735,0,10.482-4.228,11.297-9.737C411.413,137.812,408.124,139.289,404.466,140.484z M414.004,132.417
			c-0.436-2.294-1.556-4.347-3.143-5.933c-0.32-0.32-0.662-0.619-1.018-0.899c-1.943-1.529-4.392-2.444-7.057-2.444
			c-5.196,0-9.578,3.471-10.963,8.22c-0.12,0.41-0.217,0.83-0.29,1.258c-0.108,0.632-0.168,1.281-0.168,1.944
			c0,1.819,0.427,3.538,1.184,5.064c2.91,0.072,6.844-0.572,11.006-1.932C407.982,136.249,411.723,134.301,414.004,132.417z"/>
			</g>
		</g>
		<g id="OBJECTS">
			<g>
				<g>
					<path style="fill:#F16167;" d="M152.738,170.768h0.731c-0.215,2.689-0.391,5.663-0.53,8.891c0.25,0.008,0.501,0.015,0.764,0.015
				c10.126,0,10.685-5.901,19.766-6.546v-26.469h-20.913l-18.318,26.49c6.985,0.595,8.84,4.355,14.316,5.881
				C150.304,175.964,151.703,173.206,152.738,170.768z"/>
					<path style="fill:#F18B53;" d="M152.939,179.659c-0.054,1.243-0.103,2.519-0.145,3.842c0.297-0.011,0.601-0.018,0.916-0.018
				c10.123,0,10.682,5.899,19.758,6.545v-16.9c-9.081,0.645-9.639,6.546-19.766,6.546
				C153.44,179.674,153.189,179.667,152.939,179.659z"/>
					<path style="fill:#F16167;" d="M152.555,268.162v19.268h20.913v-12.753c-9.075-0.646-9.635-6.545-19.758-6.545
				C153.309,268.132,152.927,268.144,152.555,268.162z"/>
					<path style="fill:#F16167;" d="M152.555,225.837v7.76h-41.004l4.838-7.038c-1.502-0.46-3.274-0.753-5.521-0.753
				c-9.144,0-10.487,4.811-17.347,6.22l-1.97,2.849v16.529h61.004v12.888c0.37,0.017,0.749,0.029,1.147,0.029
				c10.126,0,10.685-5.901,19.766-6.546v-6.372h17.991v-17.808h-17.991v-1.245c-9.075-0.646-9.635-6.545-19.758-6.545
				C153.309,225.808,152.927,225.82,152.555,225.837z"/>
					<path style="fill:#F18B53;" d="M152.555,221.969v3.869c0.372-0.018,0.754-0.03,1.155-0.03c10.123,0,10.682,5.899,19.758,6.545
				v-16.9c-9.081,0.645-9.639,6.546-19.766,6.546C153.304,221.998,152.925,221.986,152.555,221.969z"/>
					<path style="fill:#F16167;" d="M153.71,183.483c-0.315,0-0.619,0.007-0.916,0.018c-0.159,4.966-0.239,10.488-0.239,16.581v21.886
				c0.37,0.018,0.749,0.029,1.147,0.029c10.126,0,10.685-5.901,19.766-6.546v-25.424
				C164.393,189.382,163.833,183.483,153.71,183.483z"/>
					<path style="fill:#F18B53;" d="M116.39,226.56l5.571-8.103c-2.812,1.727-5.484,3.541-11.096,3.541
				c-4.155,0-6.696-0.995-8.878-2.212l-8.465,12.242c6.86-1.409,8.203-6.22,17.347-6.22
				C113.116,225.808,114.888,226.101,116.39,226.56z"/>
					<path style="fill:#F16167;" d="M121.96,218.458l22.298-32.433c-3.167,1.862-5.782,4.065-11.967,4.065
				c-3.864,0-6.331-0.861-8.413-1.96l-21.891,31.657c2.182,1.217,4.723,2.212,8.878,2.212
				C116.477,221.998,119.148,220.184,121.96,218.458z"/>
					<path style="fill:#F18B53;" d="M152.555,264.293v3.869c0.372-0.018,0.754-0.03,1.155-0.03c10.123,0,10.682,5.899,19.758,6.545
				v-16.9c-9.081,0.645-9.639,6.546-19.766,6.546C153.304,264.323,152.925,264.311,152.555,264.293z"/>
					<path style="fill:#F18B53;" d="M144.258,186.024l0.443-0.645c1.436-2.249,2.716-4.362,3.851-6.349
				c-5.476-1.526-7.33-5.286-14.316-5.881l-10.359,14.98c2.082,1.099,4.55,1.96,8.413,1.96
				C138.477,190.089,141.091,187.886,144.258,186.024z"/>
				</g>
				<g>
					<path style="fill:#F18B53;" d="M331.796,183.572l21.762-31.654c-0.937,0.087-1.936,0.138-3.027,0.138
				c-6.646,0-10.194-1.739-13.532-3.596l-24.385,35.262c2.413,0.936,5.323,1.593,9.402,1.593
				C326.312,185.316,329.309,184.587,331.796,183.572z"/>
					<path style="fill:#F18B53;" d="M386.981,130.087v-23.662h-20.913l-11.735,16.97c10.577,1.278,11.843,7.781,24.696,7.781
				C382.326,131.176,384.856,130.745,386.981,130.087z"/>
					<path style="fill:#F16167;" d="M353.558,151.918l4.656-6.773c3.653-5.722,6.331-10.593,8.036-14.612h0.731
				c-0.38,4.741-0.64,10.322-0.783,16.739c3.148-1.707,6.649-3.216,12.839-3.216c3.294,0,5.821,0.43,7.944,1.087v-15.057
				c-2.125,0.658-4.654,1.089-7.952,1.089c-12.853,0-14.119-6.504-24.696-7.781l-17.334,25.066
				c3.338,1.857,6.885,3.596,13.532,3.596C351.622,152.057,352.621,152.005,353.558,151.918z"/>
					<path style="fill:#F18B53;" d="M350.531,206.197c-14.255,0-14.255-8-28.509-8c-8.893,0-12.238,3.113-16.958,5.456v7.519h61.004
				v25.003c3.18,1.734,6.691,3.282,12.961,3.282c3.297,0,5.827-0.431,7.952-1.089v-27.196h17.991v-5.07
				c-11.739-0.898-12.596-7.905-25.935-7.905C364.784,198.197,364.784,206.197,350.531,206.197z"/>
					<path style="fill:#F16167;" d="M366.068,182.034v11.33h-41.004l6.731-9.791c-2.486,1.015-5.483,1.744-9.779,1.744
				c-4.08,0-6.99-0.657-9.402-1.593l-7.551,10.919v9.01c4.719-2.342,8.065-5.456,16.958-5.456c14.255,0,14.255,8,28.509,8
				c14.253,0,14.253-8,28.505-8c13.339,0,14.196,7.006,25.935,7.905v-12.738h-17.991v-9.137c-2.125,0.658-4.654,1.089-7.952,1.089
				C372.76,185.316,369.248,183.768,366.068,182.034z"/>
					<path style="fill:#F18B53;" d="M379.036,144.057c-6.189,0-9.69,1.509-12.839,3.216c-0.087,3.885-0.13,8.076-0.13,12.576v22.186
				c3.18,1.734,6.691,3.282,12.961,3.282c3.297,0,5.827-0.431,7.952-1.089v-39.083C384.857,144.487,382.33,144.057,379.036,144.057z
				"/>
					<path style="fill:#F18B53;" d="M366.068,255.623v34.691c3.18,1.734,6.691,3.282,12.961,3.282c3.297,0,5.827-0.431,7.952-1.089
				v-39.083c-2.123-0.657-4.65-1.087-7.944-1.087C372.762,252.337,369.25,253.888,366.068,255.623z"/>
					<path style="fill:#F16167;" d="M366.068,290.314v15.805h20.913v-13.612c-2.125,0.658-4.654,1.089-7.952,1.089
				C372.76,293.596,369.248,292.048,366.068,290.314z"/>
					<path style="fill:#F16167;" d="M366.068,236.174v19.449c3.182-1.736,6.694-3.286,12.968-3.286c3.294,0,5.821,0.43,7.944,1.087
				v-15.057c-2.125,0.658-4.654,1.089-7.952,1.089C372.76,239.456,369.248,237.908,366.068,236.174z"/>
				</g>
			</g>
			<path style="fill:#F16167;" d="M443.412,328.866c-8.558,0-16.968,0.633-25.192,1.838c-36.963-40.863-98.336-67.602-167.816-67.602
		c-76.432,0-143.063,32.352-178.169,80.276c-26.913,1.809-51.637,11.6-71.831,27.024v130.778h500V338.528
		C482.563,332.277,463.387,328.866,443.412,328.866z"/>
			<g>
				<g>
					<path style="fill:#F18B53;" d="M93.804,363.099c1.455,3.643-4.931,9.617-14.262,13.343c-9.331,3.726-18.075,3.793-19.529,0.149
				c-1.455-3.643,4.931-9.617,14.261-13.343C83.606,359.523,92.349,359.456,93.804,363.099z"/>
					<path style="fill:#230B24;" d="M62.776,378.171c-1.618-4.053,5.485-10.698,15.865-14.842c3.57-1.426,7.063-2.369,10.175-2.829
				c-3.721-0.367-9.022,0.546-14.541,2.749c-9.331,3.726-15.716,9.699-14.262,13.343c0.441,1.105,1.561,1.864,3.157,2.287
				C63.009,378.658,62.876,378.422,62.776,378.171z"/>
				</g>
				<g>
					<path style="fill:#F18B53;" d="M163.491,429.534c0.368,2.942-5.443,6.091-12.978,7.034c-7.536,0.942-13.943-0.679-14.311-3.621
				c-0.368-2.942,5.443-6.091,12.978-7.034S163.123,426.592,163.491,429.534z"/>
					<path style="fill:#230B24;" d="M137.921,434.63c-0.409-3.273,6.054-6.776,14.437-7.824c2.883-0.361,5.618-0.384,7.982-0.126
				c-2.651-0.979-6.702-1.324-11.159-0.767c-7.536,0.942-13.346,4.091-12.978,7.034c0.112,0.893,0.786,1.661,1.872,2.276
				C137.998,435.031,137.946,434.833,137.921,434.63z"/>
				</g>
				<g>
					<path style="fill:#F18B53;" d="M184.824,286.724c1.052,2.772-3.85,7.204-10.95,9.9s-13.709,2.633-14.761-0.139
				c-1.053-2.772,3.85-7.204,10.95-9.9C177.163,283.89,183.772,283.952,184.824,286.724z"/>
					<path style="fill:#230B24;" d="M161.181,297.715c-1.171-3.084,4.283-8.014,12.181-11.013c2.717-1.031,5.368-1.7,7.726-2.007
				c-2.808-0.325-6.825,0.296-11.025,1.891c-7.1,2.696-12.002,7.128-10.95,9.9c0.319,0.841,1.156,1.428,2.356,1.769
				C161.35,298.086,161.254,297.906,161.181,297.715z"/>
				</g>
				<g>
					<path style="fill:#F18B53;" d="M436.261,362.194c-1.342,3.353-9.392,3.284-17.98-0.154c-8.588-3.438-14.461-8.943-13.119-12.296
				c1.342-3.353,9.392-3.284,17.98,0.154C431.73,353.336,437.604,358.841,436.261,362.194z"/>
					<path style="fill:#230B24;" d="M406.003,352.552c1.493-3.73,10.448-3.653,20.001,0.171c3.286,1.315,6.214,2.903,8.582,4.571
				c-2.249-2.607-6.363-5.362-11.443-7.396c-8.588-3.438-16.637-3.507-17.98-0.154c-0.407,1.017-0.142,2.234,0.654,3.529
				C405.848,353.025,405.91,352.784,406.003,352.552z"/>
				</g>
				<g>
					<path style="fill:#F18B53;" d="M365.781,428.096c-0.48,2.928-6.948,4.306-14.447,3.077c-7.5-1.228-13.19-4.598-12.711-7.526
				c0.48-2.928,6.948-4.306,14.447-3.078C360.57,421.798,366.261,425.168,365.781,428.096z"/>
					<path style="fill:#230B24;" d="M339.797,425.75c0.534-3.257,7.729-4.79,16.071-3.424c2.869,0.47,5.501,1.222,7.697,2.138
				c-2.268-1.69-6.058-3.168-10.494-3.894c-7.499-1.228-13.968,0.15-14.447,3.078c-0.146,0.888,0.284,1.817,1.153,2.714
				C339.757,426.156,339.764,425.952,339.797,425.75z"/>
				</g>
				<g>
					<path style="fill:#F18B53;" d="M439.028,408.363c-0.153,1.926-4.278,3.17-9.212,2.777c-4.934-0.393-8.81-2.273-8.656-4.2
				c0.153-1.927,4.278-3.17,9.212-2.777C435.306,404.556,439.182,406.436,439.028,408.363z"/>
					<path style="fill:#230B24;" d="M422.035,408.241c0.171-2.143,4.758-3.526,10.247-3.089c1.888,0.15,3.636,0.496,5.111,0.973
				c-1.563-0.975-4.103-1.73-7.021-1.962c-4.934-0.393-9.058,0.85-9.212,2.777c-0.047,0.584,0.282,1.164,0.894,1.7
				C422.032,408.507,422.025,408.374,422.035,408.241z"/>
				</g>
				<g>
					<ellipse style="fill:#F18B53;" cx="255.954" cy="412.684" rx="8.745" ry="3.414" />
					<path style="fill:#230B24;" d="M248.161,413.882c0-2.098,4.355-3.798,9.728-3.798c1.848,0,3.575,0.201,5.047,0.55
				c-1.596-0.827-4.125-1.364-6.982-1.364c-4.83,0-8.745,1.529-8.745,3.414c0,0.572,0.365,1.11,1.002,1.584
				C248.178,414.141,248.161,414.012,248.161,413.882z"/>
				</g>
				<g>
					<path style="fill:#F18B53;" d="M188.072,366.962c0,1.886-3.915,3.414-8.745,3.414c-4.83,0-8.745-1.529-8.745-3.414
				c0-1.886,3.915-3.414,8.745-3.414C184.157,363.548,188.072,365.076,188.072,366.962z"/>
					<path style="fill:#230B24;" d="M171.534,368.16c0-2.098,4.355-3.798,9.728-3.798c1.848,0,3.575,0.201,5.047,0.551
				c-1.596-0.827-4.125-1.365-6.982-1.365c-4.83,0-8.745,1.529-8.745,3.414c0,0.572,0.365,1.11,1.002,1.584
				C171.551,368.419,171.534,368.29,171.534,368.16z"/>
				</g>
				<g>
					<path style="fill:#F18B53;" d="M349.341,326.69c0.258,2.35-4.413,4.791-10.432,5.452c-6.019,0.661-11.108-0.709-11.366-3.059
				c-0.258-2.35,4.413-4.791,10.432-5.452C343.995,322.97,349.083,324.339,349.341,326.69z"/>
					<path style="fill:#230B24;" d="M328.893,330.445c-0.287-2.615,4.908-5.33,11.604-6.065c2.303-0.253,4.484-0.238,6.365-0.004
				c-2.102-0.813-5.328-1.136-8.888-0.745c-6.019,0.661-10.69,3.102-10.432,5.452c0.078,0.713,0.607,1.334,1.465,1.837
				C328.95,330.766,328.911,330.608,328.893,330.445z"/>
				</g>
				<g>
					<path style="fill:#F18B53;" d="M310.203,281.707c-0.246,1.648-3.867,2.474-8.089,1.845c-4.222-0.629-7.445-2.476-7.199-4.124
				c0.246-1.648,3.867-2.474,8.089-1.845C307.225,278.212,310.448,280.059,310.203,281.707z"/>
					<path style="fill:#230B24;" d="M295.59,280.599c0.273-1.834,4.302-2.753,8.998-2.052c1.615,0.241,3.099,0.642,4.34,1.139
				c-1.287-0.931-3.428-1.73-5.925-2.103c-4.222-0.63-7.843,0.197-8.089,1.845c-0.075,0.5,0.174,1.018,0.669,1.515
				C295.571,280.828,295.573,280.713,295.59,280.599z"/>
				</g>
			</g>
			<text transform="matrix(1 0 0 1 174.9214 367.1563)" style="fill:#FFFFFF; font-family:'Molot'; font-size:46.602px;">ERROR</text>
			<g>
				<g>
					<path style="fill:#230B24;" d="M196.07,379.374c1.29,0,2.232,0.252,2.827,0.756c0.595,0.503,0.892,1.225,0.892,2.163
				c0,0.424-0.069,0.826-0.208,1.206c-0.139,0.381-0.363,0.716-0.673,1.006c-0.31,0.289-0.717,0.517-1.22,0.684
				c-0.503,0.166-1.12,0.249-1.849,0.249h-1.217v3.931h-1.162v-9.994H196.07z M195.96,380.365h-1.34v4.074h1.087
				c0.638,0,1.17-0.068,1.596-0.205s0.746-0.358,0.96-0.667c0.214-0.307,0.321-0.716,0.321-1.227c0-0.665-0.212-1.161-0.636-1.486
				C197.526,380.528,196.863,380.365,195.96,380.365z"/>
					<path style="fill:#230B24;" d="M205.212,381.753c0.893,0,1.556,0.2,1.989,0.602s0.649,1.041,0.649,1.921v5.093h-0.827
				l-0.219-1.107h-0.055c-0.209,0.273-0.428,0.502-0.656,0.688c-0.228,0.184-0.491,0.323-0.79,0.416
				c-0.298,0.094-0.664,0.141-1.097,0.141c-0.456,0-0.86-0.08-1.213-0.239s-0.631-0.401-0.834-0.725s-0.304-0.733-0.304-1.23
				c0-0.747,0.296-1.321,0.889-1.723s1.495-0.62,2.707-0.656l1.292-0.055v-0.458c0-0.647-0.139-1.101-0.417-1.36
				s-0.67-0.39-1.176-0.39c-0.392,0-0.766,0.057-1.121,0.171s-0.693,0.248-1.012,0.403l-0.349-0.861
				c0.337-0.173,0.725-0.321,1.162-0.444S204.729,381.753,205.212,381.753z M206.73,385.677l-1.142,0.048
				c-0.934,0.036-1.593,0.189-1.976,0.458s-0.574,0.649-0.574,1.142c0,0.429,0.13,0.745,0.39,0.95s0.604,0.308,1.032,0.308
				c0.666,0,1.21-0.185,1.634-0.554s0.636-0.923,0.636-1.661V385.677z"/>
					<path style="fill:#230B24;" d="M212.98,392.731c-0.984,0-1.743-0.184-2.276-0.551c-0.533-0.366-0.8-0.88-0.8-1.541
				c0-0.47,0.149-0.87,0.448-1.203s0.712-0.554,1.241-0.663c-0.196-0.091-0.363-0.228-0.502-0.41s-0.208-0.392-0.208-0.629
				c0-0.273,0.076-0.514,0.229-0.722c0.153-0.207,0.386-0.406,0.701-0.598c-0.392-0.159-0.71-0.43-0.954-0.811
				c-0.244-0.38-0.366-0.823-0.366-1.329c0-0.538,0.112-0.997,0.335-1.378c0.223-0.38,0.547-0.671,0.971-0.871
				s0.937-0.301,1.538-0.301c0.132,0,0.266,0.006,0.4,0.018c0.134,0.011,0.263,0.027,0.386,0.047
				c0.123,0.021,0.23,0.045,0.321,0.072h2.57v0.731l-1.381,0.171c0.137,0.178,0.25,0.392,0.342,0.643s0.137,0.528,0.137,0.834
				c0,0.747-0.253,1.341-0.759,1.781c-0.506,0.439-1.201,0.659-2.085,0.659c-0.209,0-0.424-0.019-0.643-0.055
				c-0.223,0.123-0.393,0.26-0.509,0.41s-0.174,0.323-0.174,0.52c0,0.146,0.044,0.262,0.133,0.349s0.218,0.149,0.386,0.188
				c0.168,0.039,0.372,0.059,0.608,0.059h1.319c0.816,0,1.441,0.171,1.876,0.513s0.653,0.841,0.653,1.497
				c0,0.829-0.337,1.465-1.012,1.907S214.256,392.731,212.98,392.731z M213.015,391.843c0.62,0,1.134-0.063,1.542-0.188
				c0.408-0.126,0.713-0.306,0.916-0.541c0.203-0.234,0.304-0.514,0.304-0.837c0-0.301-0.068-0.527-0.205-0.681
				c-0.137-0.152-0.337-0.255-0.602-0.307c-0.264-0.053-0.588-0.079-0.971-0.079H212.7c-0.337,0-0.631,0.053-0.882,0.157
				s-0.443,0.26-0.578,0.465s-0.202,0.46-0.202,0.766c0,0.405,0.171,0.715,0.513,0.926
				C211.894,391.737,212.381,391.843,213.015,391.843z M213.309,385.854c0.542,0,0.95-0.137,1.224-0.41s0.41-0.672,0.41-1.196
				c0-0.561-0.139-0.981-0.417-1.261c-0.278-0.281-0.688-0.421-1.23-0.421c-0.52,0-0.919,0.145-1.2,0.435
				c-0.28,0.289-0.42,0.712-0.42,1.268c0,0.511,0.141,0.902,0.424,1.176S212.785,385.854,213.309,385.854z"/>
					<path style="fill:#230B24;" d="M222.075,381.739c0.638,0,1.185,0.142,1.641,0.424s0.804,0.678,1.046,1.186
				c0.242,0.509,0.362,1.103,0.362,1.781v0.704h-5.175c0.014,0.88,0.232,1.55,0.656,2.01s1.021,0.69,1.791,0.69
				c0.474,0,0.893-0.043,1.258-0.13s0.743-0.214,1.135-0.383v0.998c-0.378,0.169-0.753,0.292-1.125,0.369s-0.81,0.116-1.316,0.116
				c-0.72,0-1.348-0.146-1.883-0.441c-0.536-0.293-0.951-0.726-1.248-1.295s-0.444-1.267-0.444-2.092
				c0-0.807,0.136-1.505,0.407-2.096c0.271-0.59,0.654-1.044,1.148-1.363S221.405,381.739,222.075,381.739z M222.062,382.669
				c-0.606,0-1.089,0.198-1.449,0.595s-0.574,0.95-0.643,1.661h3.965c-0.004-0.446-0.074-0.84-0.208-1.18
				c-0.134-0.339-0.338-0.604-0.612-0.793C222.841,382.764,222.49,382.669,222.062,382.669z"/>
					<path style="fill:#230B24;" d="M235.636,381.739c0.889,0,1.561,0.218,2.017,0.652c0.456,0.436,0.684,1.134,0.684,2.096v4.881
				h-1.121v-4.806c0-0.624-0.143-1.092-0.427-1.401s-0.721-0.465-1.309-0.465c-0.83,0-1.413,0.234-1.75,0.704
				s-0.506,1.15-0.506,2.044v3.924h-1.135v-7.492h0.916l0.171,1.08h0.062c0.16-0.265,0.362-0.486,0.608-0.666
				c0.246-0.181,0.522-0.317,0.827-0.41C234.978,381.786,235.299,381.739,235.636,381.739z"/>
					<path style="fill:#230B24;" d="M247.834,385.608c0,0.615-0.08,1.164-0.239,1.647s-0.39,0.891-0.69,1.224s-0.664,0.587-1.09,0.762
				c-0.426,0.176-0.908,0.264-1.446,0.264c-0.501,0-0.96-0.088-1.377-0.264c-0.417-0.175-0.777-0.429-1.08-0.762
				s-0.538-0.74-0.704-1.224s-0.25-1.032-0.25-1.647c0-0.82,0.139-1.519,0.417-2.096c0.278-0.576,0.676-1.016,1.193-1.318
				c0.517-0.304,1.134-0.455,1.849-0.455c0.684,0,1.282,0.152,1.794,0.458c0.512,0.306,0.912,0.746,1.196,1.323
				C247.692,384.097,247.834,384.793,247.834,385.608z M242.133,385.608c0,0.602,0.08,1.123,0.239,1.565s0.406,0.784,0.738,1.025
				s0.761,0.362,1.285,0.362c0.52,0,0.947-0.121,1.282-0.362s0.582-0.583,0.742-1.025c0.159-0.442,0.239-0.964,0.239-1.565
				c0-0.597-0.08-1.113-0.239-1.549c-0.16-0.435-0.406-0.771-0.738-1.008s-0.763-0.355-1.292-0.355c-0.779,0-1.35,0.258-1.712,0.772
				S242.133,384.697,242.133,385.608z"/>
					<path style="fill:#230B24;" d="M252.916,388.575c0.187,0,0.378-0.016,0.574-0.048s0.355-0.07,0.479-0.116v0.882
				c-0.132,0.06-0.315,0.109-0.55,0.15c-0.235,0.041-0.464,0.062-0.688,0.062c-0.396,0-0.757-0.069-1.08-0.209
				c-0.323-0.139-0.582-0.374-0.775-0.707c-0.194-0.333-0.291-0.793-0.291-1.381v-4.443h-1.066v-0.554l1.073-0.444l0.451-1.627
				h0.684v1.736h2.194v0.889h-2.194v4.409c0,0.47,0.108,0.82,0.325,1.053C252.268,388.459,252.556,388.575,252.916,388.575z"/>
					<path style="fill:#230B24;" d="M263.858,382.765h-1.866v6.604h-1.135v-6.604h-1.326v-0.547l1.326-0.376v-0.499
				c0-0.629,0.094-1.141,0.28-1.535c0.187-0.394,0.458-0.685,0.813-0.871s0.788-0.28,1.299-0.28c0.287,0,0.551,0.025,0.789,0.075
				c0.24,0.05,0.45,0.107,0.633,0.171l-0.294,0.896c-0.155-0.05-0.329-0.097-0.522-0.141c-0.194-0.043-0.392-0.064-0.592-0.064
				c-0.433,0-0.753,0.141-0.961,0.42c-0.207,0.281-0.311,0.72-0.311,1.316v0.547h1.866V382.765z"/>
					<path style="fill:#230B24;" d="M272.393,385.608c0,0.615-0.08,1.164-0.239,1.647s-0.39,0.891-0.69,1.224s-0.664,0.587-1.09,0.762
				c-0.427,0.176-0.908,0.264-1.446,0.264c-0.501,0-0.96-0.088-1.378-0.264c-0.416-0.175-0.776-0.429-1.08-0.762
				c-0.303-0.333-0.537-0.74-0.703-1.224c-0.167-0.483-0.25-1.032-0.25-1.647c0-0.82,0.139-1.519,0.417-2.096
				c0.278-0.576,0.676-1.016,1.192-1.318c0.518-0.304,1.134-0.455,1.85-0.455c0.684,0,1.281,0.152,1.795,0.458
				c0.512,0.306,0.911,0.746,1.195,1.323C272.25,384.097,272.393,384.793,272.393,385.608z M266.691,385.608
				c0,0.602,0.08,1.123,0.239,1.565s0.405,0.784,0.738,1.025s0.761,0.362,1.285,0.362c0.52,0,0.946-0.121,1.282-0.362
				c0.334-0.241,0.582-0.583,0.741-1.025s0.239-0.964,0.239-1.565c0-0.597-0.08-1.113-0.239-1.549
				c-0.159-0.435-0.405-0.771-0.738-1.008s-0.764-0.355-1.292-0.355c-0.779,0-1.35,0.258-1.713,0.772
				C266.873,383.983,266.691,384.697,266.691,385.608z"/>
					<path style="fill:#230B24;" d="M281.241,381.876v7.492h-0.93l-0.164-1.053h-0.062c-0.155,0.26-0.355,0.479-0.602,0.656
				s-0.522,0.311-0.831,0.4c-0.307,0.088-0.634,0.133-0.98,0.133c-0.593,0-1.089-0.096-1.49-0.287s-0.703-0.487-0.906-0.889
				c-0.202-0.401-0.304-0.916-0.304-1.545v-4.908h1.148v4.826c0,0.624,0.142,1.09,0.424,1.398c0.282,0.307,0.713,0.461,1.292,0.461
				c0.556,0,0.999-0.104,1.33-0.314c0.33-0.21,0.568-0.519,0.714-0.926c0.146-0.408,0.219-0.908,0.219-1.501v-3.944H281.241z"/>
					<path style="fill:#230B24;" d="M287.889,381.739c0.889,0,1.561,0.218,2.017,0.652c0.456,0.436,0.684,1.134,0.684,2.096v4.881
				h-1.121v-4.806c0-0.624-0.143-1.092-0.427-1.401c-0.285-0.31-0.722-0.465-1.31-0.465c-0.829,0-1.413,0.234-1.75,0.704
				s-0.506,1.15-0.506,2.044v3.924h-1.135v-7.492h0.916l0.171,1.08h0.062c0.159-0.265,0.362-0.486,0.608-0.666
				c0.246-0.181,0.521-0.317,0.827-0.41C287.23,381.786,287.552,381.739,287.889,381.739z"/>
					<path style="fill:#230B24;" d="M296.292,389.505c-0.948,0-1.698-0.323-2.253-0.971c-0.553-0.647-0.83-1.608-0.83-2.885
				c0-1.29,0.282-2.264,0.848-2.922c0.565-0.659,1.317-0.988,2.256-0.988c0.396,0,0.743,0.053,1.039,0.157s0.552,0.245,0.766,0.421
				c0.214,0.175,0.395,0.374,0.54,0.598h0.082c-0.019-0.142-0.036-0.335-0.055-0.581s-0.027-0.446-0.027-0.602v-3.001h1.135v10.637
				h-0.916l-0.171-1.066h-0.048c-0.142,0.224-0.32,0.426-0.536,0.608c-0.217,0.183-0.475,0.327-0.773,0.435
				C297.05,389.451,296.697,389.505,296.292,389.505z M296.47,388.562c0.802,0,1.369-0.228,1.702-0.684s0.499-1.133,0.499-2.03
				v-0.205c0-0.952-0.158-1.684-0.476-2.194c-0.316-0.511-0.892-0.766-1.726-0.766c-0.697,0-1.219,0.268-1.565,0.803
				c-0.347,0.536-0.52,1.267-0.52,2.191c0,0.921,0.172,1.632,0.516,2.133C295.245,388.311,295.768,388.562,296.47,388.562z"/>
				</g>
			</g>
			<g>
				<path style="fill:#230B24;" d="M218.06,298.255c0,1.996-4.919,3.615-10.988,3.615c-6.068,0-10.988-1.618-10.988-3.615
			c0-1.996,4.919-3.615,10.988-3.615C213.141,294.64,218.06,296.258,218.06,298.255z"/>
				<path style="fill:#230B24;" d="M307.427,298.655c0,1.996-4.919,3.615-10.988,3.615s-10.988-1.618-10.988-3.615
			c0-1.996,4.919-3.615,10.988-3.615S307.427,296.659,307.427,298.655z"/>
				<g>
					<path style="fill:#1694BA;" d="M296.44,296.741c-1.392,0-2.52-1.128-2.52-2.52v-37.986l-17.126-19.277
				c-0.924-1.041-0.83-2.634,0.211-3.558c1.04-0.925,2.633-0.831,3.558,0.21l17.762,19.994c0.409,0.461,0.636,1.057,0.636,1.674
				v38.944C298.96,295.613,297.832,296.741,296.44,296.741z"/>
				</g>
				<path style="fill:#1694BA;" d="M303.655,298.655c0-3.985-3.23-7.215-7.215-7.215c-3.985,0-7.215,3.23-7.215,7.215H303.655z" />
				<g>
					<path style="fill:#1694BA;" d="M207.073,296.741c-1.392,0-2.52-1.128-2.52-2.52v-38.944c0-0.617,0.227-1.212,0.636-1.674
				l17.761-19.994c0.925-1.042,2.517-1.135,3.558-0.21c1.041,0.924,1.135,2.517,0.21,3.558l-17.125,19.277v37.986
				C209.593,295.613,208.465,296.741,207.073,296.741z"/>
				</g>
				<path style="fill:#1694BA;" d="M199.858,298.655c0-3.985,3.23-7.215,7.215-7.215c3.985,0,7.215,3.23,7.215,7.215H199.858z" />
				<path style="fill:#230B24;" d="M251.802,317.849c0,1.996-5.689,3.615-12.706,3.615s-12.706-1.618-12.706-3.615
			c0-1.996,5.689-3.615,12.706-3.615S251.802,315.853,251.802,317.849z"/>
				<ellipse style="fill:#230B24;" cx="257.083" cy="278.069" rx="8.027" ry="2.641" />
				<g>
					<path style="fill:#1694BA;" d="M257.083,277.343c-1.392,0-2.52-1.128-2.52-2.52v-26.771c0-1.392,1.128-2.52,2.52-2.52
				c1.392,0,2.52,1.128,2.52,2.52v26.771C259.603,276.215,258.475,277.343,257.083,277.343z"/>
				</g>
				<path style="fill:#1694BA;" d="M251.802,278.069c0-2.917,2.365-5.282,5.282-5.282c2.917,0,5.282,2.365,5.282,5.282H251.802z" />
				<g>
					<path style="fill:#5EC9F2;" d="M287.559,195.867c0,18.298-2.942,31.889-8.824,40.774c-5.883,8.885-14.876,13.327-26.978,13.327
				c-11.719,0-20.603-4.585-26.654-13.759c-6.051-9.173-9.077-22.62-9.077-40.342c0-18.586,2.941-32.285,8.825-41.098
				c5.882-8.812,14.851-13.219,26.906-13.219c11.766,0,20.675,4.61,26.726,13.831C284.534,164.602,287.559,178.098,287.559,195.867z
				"/>
				</g>
				<path style="fill:#5EC9F2;" d="M252.918,136.004v-14.946c-0.352,0.158-0.74,0.251-1.151,0.251c-0.411,0-0.799-0.093-1.151-0.251
			v14.943c0.374-0.048,0.752-0.08,1.139-0.08C252.151,135.922,252.537,135.955,252.918,136.004z"/>
				<path style="fill:#1694BA;" d="M252.918,136.004c-0.381-0.05-0.767-0.083-1.162-0.083c-0.387,0-0.765,0.032-1.139,0.08
			c-3.582,0.455-6.502,3.019-7.477,6.412c2.672-0.573,5.542-0.863,8.615-0.863c3.077,0,5.953,0.323,8.639,0.954
			C259.448,139.074,256.521,136.472,252.918,136.004z"/>
				<path style="fill:#1694BA;" d="M251.768,115.68c-1.554,0-2.815,1.26-2.815,2.815c0,1.143,0.685,2.123,1.664,2.563
			c0.352,0.158,0.74,0.251,1.151,0.251c0.411,0,0.799-0.093,1.151-0.251c0.979-0.44,1.664-1.42,1.664-2.563
			C254.582,116.94,253.322,115.68,251.768,115.68z"/>
				<path style="fill:#1694BA;" d="M227.588,232.44c5.488,8.319,13.544,12.477,24.171,12.477c10.975,0,19.13-4.028,24.465-12.085
			c4.448-6.718,7.035-16.415,7.774-29.068h-64.394C220.383,215.982,223.041,225.547,227.588,232.44z"/>
				<path style="fill:#FFFFFF;" d="M284.227,195.857c0-16.113-2.743-28.352-8.231-36.714c-5.488-8.362-13.567-12.543-24.237-12.543
			c-10.932,0-19.065,3.996-24.4,11.987c-5.336,7.992-8.003,20.415-8.003,37.269c0,0.97,0.011,1.925,0.031,2.866h64.809
			C284.216,197.781,284.227,196.828,284.227,195.857z"/>
				<g>
					<path style="fill:#1694BA;" d="M239.328,316.236c-1.392,0-2.52-1.128-2.52-2.52v-36.571c0-0.257,0.039-0.512,0.117-0.757
				l10.613-32.908c0.419-1.328,1.835-2.064,3.161-1.647c1.328,0.419,2.065,1.834,1.647,3.161l-10.496,32.538v36.184
				C241.849,315.108,240.72,316.236,239.328,316.236z"/>
				</g>
				<path style="fill:#1694BA;" d="M232.113,318.15c0-3.985,3.23-7.215,7.215-7.215c3.985,0,7.215,3.23,7.215,7.215H232.113z" />
				<path style="fill:#F18B53;" d="M240.957,219.9h-7.558c-2.277,0-4.123-1.846-4.123-4.123l0,0c0-2.277,1.846-4.123,4.123-4.123
			h7.558c2.277,0,4.123,1.846,4.123,4.123l0,0C245.08,218.055,243.234,219.9,240.957,219.9z"/>
				<path style="fill:#F18B53;" d="M270.678,219.9h-7.558c-2.277,0-4.123-1.846-4.123-4.123v0c0-2.277,1.846-4.123,4.123-4.123h7.558
			c2.277,0,4.123,1.846,4.123,4.123l0,0C274.8,218.055,272.954,219.9,270.678,219.9z"/>
				<g>
					<g>
						<path style="fill:#5EC9F2;" d="M271.819,226.442h-40.18c-0.232,0-0.42-0.188-0.42-0.42c0-0.232,0.188-0.42,0.42-0.42h40.18
					c0.232,0,0.42,0.188,0.42,0.42C272.239,226.254,272.051,226.442,271.819,226.442z"/>
					</g>
					<g>
						<path style="fill:#5EC9F2;" d="M271.819,229.295h-40.18c-0.232,0-0.42-0.188-0.42-0.42c0-0.232,0.188-0.42,0.42-0.42h40.18
					c0.232,0,0.42,0.188,0.42,0.42C272.239,229.107,272.051,229.295,271.819,229.295z"/>
					</g>
					<g>
						<path style="fill:#5EC9F2;" d="M271.819,232.148h-40.18c-0.232,0-0.42-0.188-0.42-0.42c0-0.232,0.188-0.42,0.42-0.42h40.18
					c0.232,0,0.42,0.188,0.42,0.42C272.239,231.96,272.051,232.148,271.819,232.148z"/>
					</g>
					<g>
						<path style="fill:#5EC9F2;" d="M271.819,235.001h-40.18c-0.232,0-0.42-0.188-0.42-0.42c0-0.232,0.188-0.42,0.42-0.42h40.18
					c0.232,0,0.42,0.188,0.42,0.42C272.239,234.813,272.051,235.001,271.819,235.001z"/>
					</g>
				</g>
				<g>
					<path style="fill:#F18B53;" d="M251.768,112.704c-0.276,0-0.5-0.224-0.5-0.5v-8.084c0-0.276,0.224-0.5,0.5-0.5
				c0.276,0,0.5,0.224,0.5,0.5v8.084C252.268,112.48,252.044,112.704,251.768,112.704z"/>
				</g>
				<g>
					<path style="fill:#F18B53;" d="M265.87,118.995h-8.084c-0.276,0-0.5-0.224-0.5-0.5c0-0.276,0.224-0.5,0.5-0.5h8.084
				c0.276,0,0.5,0.224,0.5,0.5C266.37,118.771,266.146,118.995,265.87,118.995z"/>
				</g>
				<g>
					<path style="fill:#F18B53;" d="M256.371,115.138c-0.256,0-0.512-0.098-0.707-0.293c-0.391-0.391-0.391-1.023,0-1.414l3.868-3.869
				c0.391-0.391,1.023-0.391,1.414,0s0.391,1.023,0,1.414l-3.868,3.869C256.883,115.04,256.627,115.138,256.371,115.138z"/>
				</g>
				<g>
					<path style="fill:#F18B53;" d="M245.749,118.995h-8.085c-0.276,0-0.5-0.224-0.5-0.5c0-0.276,0.224-0.5,0.5-0.5h8.085
				c0.276,0,0.5,0.224,0.5,0.5C246.249,118.771,246.026,118.995,245.749,118.995z"/>
				</g>
				<g>
					<path style="fill:#F18B53;" d="M247.165,115.138c-0.256,0-0.512-0.098-0.707-0.293l-3.869-3.869
				c-0.391-0.391-0.391-1.023,0-1.414c0.391-0.391,1.023-0.391,1.414,0l3.869,3.869c0.391,0.391,0.391,1.023,0,1.414
				C247.677,115.04,247.421,115.138,247.165,115.138z"/>
				</g>
				<g>
					<path style="fill:#F18B53;" d="M260.239,128.518c-0.256,0-0.512-0.098-0.707-0.293l-3.868-3.869
				c-0.391-0.391-0.391-1.024,0-1.414c0.391-0.391,1.023-0.391,1.414,0l3.868,3.869c0.391,0.391,0.391,1.024,0,1.414
				C260.751,128.42,260.495,128.518,260.239,128.518z"/>
				</g>
				<g>
					<path style="fill:#F18B53;" d="M243.296,128.518c-0.256,0-0.512-0.098-0.707-0.293c-0.391-0.391-0.391-1.023,0-1.414l3.869-3.869
				c0.391-0.391,1.023-0.391,1.414,0c0.391,0.391,0.391,1.023,0,1.414l-3.869,3.869C243.808,128.42,243.552,128.518,243.296,128.518
				z"/>
				</g>
				<g style="opacity:0.4;">
					<path style="fill:#5EC9F2;" d="M232.813,163.73c-0.381,0-0.767-0.109-1.108-0.336c-0.919-0.613-1.167-1.855-0.553-2.774
				c4.518-6.768,11.454-10.2,20.615-10.2c1.105,0,2,0.895,2,2c0,1.104-0.895,2-2,2c-7.851,0-13.505,2.754-17.288,8.421
				C234.093,163.418,233.459,163.73,232.813,163.73z"/>
				</g>
				<path style="opacity:0.4;fill:#5EC9F2;" d="M231.66,167.01c0,1.035-0.839,1.874-1.874,1.874c-1.035,0-1.874-0.839-1.874-1.874
			c0-1.035,0.839-1.874,1.874-1.874C230.821,165.137,231.66,165.976,231.66,167.01z"/>
				<path style="opacity:0.4;fill:#FFFFFF;" d="M239.598,215.778c0,1.337-1.084,2.42-2.42,2.42c-1.337,0-2.42-1.083-2.42-2.42
			c0-1.337,1.083-2.42,2.42-2.42C238.515,213.358,239.598,214.441,239.598,215.778z"/>
				<path style="opacity:0.4;fill:#FFFFFF;" d="M269.319,215.778c0,1.337-1.084,2.42-2.42,2.42c-1.337,0-2.42-1.083-2.42-2.42
			c0-1.337,1.084-2.42,2.42-2.42C268.235,213.358,269.319,214.441,269.319,215.778z"/>
			</g>
			<g>
				<g>
					<path style="fill:#230B24;" d="M136.863,330.747c0.431,1.434-2.717,3.648-7.032,4.945c-4.315,1.297-8.162,1.187-8.593-0.247
				c-0.431-1.434,2.717-3.648,7.032-4.946C132.584,329.203,136.432,329.314,136.863,330.747z"/>
					<path style="fill:#6B80BF;" d="M129.489,334.865c2.733-0.847,4.864-2.624,6.044-4.751c-1.266-3.646-5.199-5.661-8.913-4.51
				c-3.715,1.151-5.819,5.037-4.802,8.76C123.993,335.451,126.756,335.712,129.489,334.865z"/>
				</g>
				<g>
					<path style="fill:#230B24;" d="M377.072,388.569c-0.406,1.271-3.834,1.311-7.658,0.09c-3.823-1.221-6.594-3.241-6.188-4.511
				c0.406-1.271,3.834-1.311,7.658-0.09C374.707,385.279,377.478,387.298,377.072,388.569z"/>
					<path style="fill:#6B80BF;" d="M369.58,387.878c2.434,0.755,4.895,0.523,6.834-0.445c0.907-3.316-0.967-6.778-4.275-7.804
				c-3.309-1.026-6.812,0.768-7.941,4.015C365.248,385.54,367.146,387.123,369.58,387.878z"/>
				</g>
				<g>
					<path style="fill:#230B24;" d="M371.378,296.399c-0.446,1.052-3.375,0.817-6.543-0.526c-3.167-1.343-5.373-3.285-4.927-4.337
				c0.446-1.052,3.376-0.817,6.543,0.526C369.619,293.405,371.825,295.347,371.378,296.399z"/>
					<path style="fill:#6B80BF;" d="M365.039,295.22c2.018,0.836,4.137,0.831,5.867,0.158c1.035-2.759-0.292-5.861-3.035-6.997
				c-2.743-1.136-5.874,0.12-7.093,2.802C361.525,292.884,363.02,294.384,365.039,295.22z"/>
				</g>
				<g>
					<path style="fill:#230B24;" d="M89.544,409.529c0.259,1.245-2.57,2.886-6.318,3.664c-3.748,0.778-6.995,0.4-7.254-0.846
				c-0.259-1.245,2.57-2.886,6.318-3.664C86.038,407.905,89.285,408.283,89.544,409.529z"/>
					<path style="fill:#6B80BF;" d="M82.998,412.467c2.376-0.514,4.31-1.86,5.467-3.573c-0.802-3.179-3.98-5.176-7.209-4.477
				c-3.229,0.699-5.297,3.831-4.713,7.057C78.304,412.556,80.622,412.981,82.998,412.467z"/>
				</g>
			</g>
		</g>
	</svg>
)

export const message = () => {
	return (
		<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 16 16" fill="none">
			<path d="M13.333 3.33594C13.333 3.15913 13.2627 2.98961 13.1377 2.86458C13.0127 2.73956 12.8432 2.66927 12.6663 2.66927H3.33301C3.1562 2.66927 2.98668 2.73956 2.86165 2.86458C2.73663 2.98961 2.66634 3.15913 2.66634 3.33594V12.3932L4.19499 10.8646L4.24382 10.8203C4.36245 10.7231 4.51161 10.6693 4.66634 10.6693H12.6663C12.8432 10.6693 13.0127 10.599 13.1377 10.474C13.2627 10.3489 13.333 10.1794 13.333 10.0026V3.33594ZM5.33952 6.0026C5.70771 6.0026 6.00619 6.30108 6.00619 6.66927C6.00619 7.03746 5.70771 7.33594 5.33952 7.33594H5.33301C4.96482 7.33594 4.66634 7.03746 4.66634 6.66927C4.66634 6.30108 4.96482 6.0026 5.33301 6.0026H5.33952ZM8.00619 6.0026C8.37438 6.0026 8.67285 6.30108 8.67285 6.66927C8.67285 7.03746 8.37438 7.33594 8.00619 7.33594H7.99967C7.63148 7.33594 7.33301 7.03746 7.33301 6.66927C7.33301 6.30108 7.63148 6.0026 7.99967 6.0026H8.00619ZM10.6729 6.0026C11.041 6.0026 11.3395 6.30108 11.3395 6.66927C11.3395 7.03746 11.041 7.33594 10.6729 7.33594H10.6663C10.2982 7.33594 9.99967 7.03746 9.99967 6.66927C9.99967 6.30108 10.2982 6.0026 10.6663 6.0026H10.6729ZM14.6663 10.0026C14.6663 10.533 14.4555 11.0416 14.0804 11.4167C13.7053 11.7917 13.1968 12.0026 12.6663 12.0026H4.94238L2.47103 14.474C2.28036 14.6646 1.99358 14.7217 1.74447 14.6185C1.4954 14.5153 1.33301 14.2722 1.33301 14.0026V3.33594C1.33301 2.8055 1.54387 2.29695 1.91895 1.92188C2.29402 1.5468 2.80257 1.33594 3.33301 1.33594H12.6663C13.1968 1.33594 13.7053 1.5468 14.0804 1.92188C14.4555 2.29695 14.6663 2.8055 14.6663 3.33594V10.0026Z" fill="currentColor"></path>
		</svg>
	)
}

export const lockedContent = () => {
	return (
		<svg width="52" height="52" viewBox="0 0 52 52" fill="none" xmlns="http://www.w3.org/2000/svg">
			<path d="M0 6C0 2.68629 2.68629 0 6 0H46C49.3137 0 52 2.68629 52 6V46C52 49.3137 49.3137 52 46 52H6C2.68629 52 0 49.3137 0 46V6Z" fill="#EBEDFF" />
			<path d="M14.0007 28.6673V32.6673H22.0007V28.6673H14.0007ZM14.0007 16.6673V15.334C14.0007 14.2731 14.4224 13.256 15.1725 12.5059C15.9227 11.7557 16.9398 11.334 18.0007 11.334H30.0007C30.3543 11.334 30.6933 11.4746 30.9434 11.7246L37.61 18.3913C37.8601 18.6413 38.0006 18.9804 38.0006 19.334V36.6673C38.0006 37.7282 37.5789 38.7453 36.8288 39.4954C36.0786 40.2456 35.0615 40.6673 34.0007 40.6673H15.334C14.5976 40.6673 14.0007 40.0704 14.0007 39.334C14.0007 38.5976 14.5976 38.0006 15.334 38.0006H34.0007C34.3543 38.0006 34.6933 37.8601 34.9434 37.61C35.1934 37.36 35.334 37.0209 35.334 36.6673V22.0007H31.334C30.2731 22.0007 29.256 21.5789 28.5059 20.8288C27.7557 20.0786 27.334 19.0615 27.334 18.0007V14.0007H18.0007C17.647 14.0007 17.308 14.1412 17.0579 14.3913C16.8079 14.6413 16.6673 14.9804 16.6673 15.334V16.6673C16.6673 17.4037 16.0704 18.0007 15.334 18.0007C14.5976 18.0007 14.0007 17.4037 14.0007 16.6673ZM19.334 24.6673C19.334 24.3137 19.1934 23.9747 18.9434 23.7246C18.6933 23.4746 18.3543 23.334 18.0007 23.334C17.647 23.334 17.308 23.4746 17.0579 23.7246C16.8079 23.9747 16.6673 24.3137 16.6673 24.6673V26.0007H19.334V24.6673ZM22.0007 26.0007C23.4734 26.0007 24.6673 27.1946 24.6673 28.6673V32.6673C24.6673 34.1401 23.4734 35.334 22.0007 35.334H14.0007C12.5279 35.334 11.334 34.1401 11.334 32.6673V28.6673C11.334 27.1946 12.5279 26.0007 14.0007 26.0007V24.6673C14.0007 23.6065 14.4224 22.5893 15.1725 21.8392C15.9227 21.089 16.9398 20.6673 18.0007 20.6673C19.0615 20.6673 20.0786 21.089 20.8288 21.8392C21.5789 22.5893 22.0007 23.6065 22.0007 24.6673V26.0007ZM30.0007 18.0007C30.0007 18.3543 30.1412 18.6933 30.3913 18.9434C30.6413 19.1934 30.9804 19.334 31.334 19.334H34.7819L30.0007 14.5527V18.0007Z" fill="#2A3BEE" />
		</svg>
	)
}

export const linkTo = () => {
	return (
		<svg xmlns="http://www.w3.org/2000/svg" width="21" height="20" viewBox="0 0 21 20" fill="none">
			<path d="M17.167 4.1665C17.167 3.70627 16.7939 3.33317 16.3337 3.33317H4.66699C4.20675 3.33317 3.83366 3.70627 3.83366 4.1665V15.8332C3.83366 16.2934 4.20675 16.6665 4.66699 16.6665H16.3337C16.7939 16.6665 17.167 16.2934 17.167 15.8332V4.1665ZM14.667 13.3332C14.667 13.7934 14.2939 14.1665 13.8337 14.1665C13.3734 14.1665 13.0003 13.7934 13.0003 13.3332V8.67822L7.75619 13.9224C7.43075 14.2478 6.90324 14.2478 6.5778 13.9224C6.25236 13.5969 6.25236 13.0694 6.5778 12.744L11.8219 7.49984H7.16699C6.70676 7.49984 6.33366 7.12674 6.33366 6.6665C6.33366 6.20627 6.70676 5.83317 7.16699 5.83317H13.8337C14.2939 5.83317 14.667 6.20627 14.667 6.6665V13.3332ZM18.8337 15.8332C18.8337 17.2139 17.7144 18.3332 16.3337 18.3332H4.66699C3.28628 18.3332 2.16699 17.2139 2.16699 15.8332V4.1665C2.16699 2.78579 3.28628 1.6665 4.66699 1.6665H16.3337C17.7144 1.6665 18.8337 2.78579 18.8337 4.1665V15.8332Z" fill="#586774" />
		</svg>
	)
}
export const liveChat = () => {
	return (
		<svg width="20" height="20" viewBox="0 0 20 20" fill="none" xmlns="http://www.w3.org/2000/svg">
			<g clip-path="url(#clip0_4731_92232)">
				<path d="M10.0625 10.4375C10.6148 10.4375 11.0625 9.98978 11.0625 9.4375C11.0625 8.88522 10.6148 8.4375 10.0625 8.4375C9.51022 8.4375 9.0625 8.88522 9.0625 9.4375C9.0625 9.98978 9.51022 10.4375 10.0625 10.4375Z" fill="#586774" />
				<path d="M6.625 10.4375C7.17728 10.4375 7.625 9.98978 7.625 9.4375C7.625 8.88522 7.17728 8.4375 6.625 8.4375C6.07272 8.4375 5.625 8.88522 5.625 9.4375C5.625 9.98978 6.07272 10.4375 6.625 10.4375Z" fill="#586774" />
				<path d="M13.5 10.4375C14.0523 10.4375 14.5 9.98978 14.5 9.4375C14.5 8.88522 14.0523 8.4375 13.5 8.4375C12.9477 8.4375 12.5 8.88522 12.5 9.4375C12.5 9.98978 12.9477 10.4375 13.5 10.4375Z" fill="#586774" />
				<path d="M3.25 14.25H8.20898L8.30859 14.2568C8.53814 14.2877 8.74256 14.4236 8.85938 14.6279L10.001 16.626L11.1436 14.6279L11.1982 14.5449C11.3389 14.3605 11.5592 14.25 11.7949 14.25H16.75V4.5H3.25V14.25ZM18.25 14.375C18.25 14.7397 18.1055 15.0898 17.8477 15.3477C17.5898 15.6055 17.2397 15.75 16.875 15.75H12.2295L11.1953 17.5576L11.1963 17.5586C11.0762 17.7693 10.9021 17.9445 10.6924 18.0664C10.4827 18.1882 10.2445 18.2529 10.002 18.2529C9.75931 18.2529 9.52034 18.1883 9.31055 18.0664C9.10092 17.9445 8.92673 17.7693 8.80664 17.5586L7.77344 15.75H3.125C2.76033 15.75 2.41021 15.6055 2.15234 15.3477C1.89448 15.0898 1.75 14.7397 1.75 14.375V4.375C1.75 4.01033 1.89448 3.66021 2.15234 3.40234L2.25391 3.31152C2.49856 3.11111 2.80597 3 3.125 3H16.875C17.194 3 17.5014 3.11111 17.7461 3.31152L17.8477 3.40234L17.9385 3.50391C18.1389 3.74856 18.25 4.05597 18.25 4.375V14.375Z" fill="#586774" />
			</g>
			<defs>
				<clipPath id="clip0_4731_92232">
					<rect width="20" height="20" fill="white" />
				</clipPath>
			</defs>
		</svg>

	)
}

export const academyLogo = () => {
	return (
		<svg width="49" height="45" fill="none" xmlns="http://www.w3.org/2000/svg"><path d="M21.726 27.543 1 15.628c-1.496-.887-1.33-2.383.444-3.381L21.172.831C22.89-.167 25.55-.278 27.046.609l20.727 11.97c1.496.887 1.33 2.383-.444 3.381L27.6 27.32c-1.718.998-4.378 1.11-5.874.223z" fill="#7B68EE" /><path d="M28.601 12.026 23.891 9.7c-1.109-.554-2.383.277-2.383 1.496v4.71c0 1.22 1.274 2.051 2.383 1.497l4.71-2.328c1.22-.665 1.22-2.438 0-3.048z" fill="#F7F7F7" /><path d="M.776 27.985A.758.758 0 0 1 0 27.21V14.463c0-.443.333-.775.776-.775s.776.332.776.775V27.21c.055.443-.333.775-.776.775z" fill="#7B68EE" /><path opacity=".5" d="m41.456 36.963-13.633 7.87c-.776.443-1.386 0-1.386-1.054v-9.476c0-1.053.61-2.272 1.386-2.716l13.578-7.87c.775-.443 1.385 0 1.385 1.054v9.476c.055 1.109-.554 2.273-1.33 2.716z" fill="#7B68EE" /><path d="m34.69 31.81-3.99 2.272c-.221.111-.387 0-.387-.332 0-.277.166-.665.387-.776l3.99-2.272c.222-.111.389 0 .389.332.055.277-.167.61-.388.776zM36.139 33.971l-5.376 3.16c-.222.11-.388 0-.388-.333 0-.277.166-.665.388-.776l5.431-3.103c.222-.111.388 0 .388.332 0 .277-.222.61-.444.72zM32.315 39.236l-1.552.887c-.222.11-.388 0-.388-.333 0-.277.166-.665.388-.776l1.552-.887c.221-.11.388 0 .388.333 0 .277-.167.665-.388.776z" fill="#F7F7F7" /><path opacity=".5" d="m20.948 44.834-13.633-7.87c-.776-.443-1.385-1.663-1.385-2.715v-9.422c0-1.053.61-1.496 1.385-1.053l13.578 7.87c.776.443 1.385 1.662 1.385 2.715v9.422c.056 1.053-.554 1.496-1.33 1.053z" fill="#7B68EE" /><path d="m14.19 31.864-3.99-2.272c-.221-.11-.387-.498-.387-.776 0-.277.166-.443.387-.332l3.99 2.272c.222.11.389.499.389.776.055.332-.167.443-.388.332zM15.632 35.745 10.2 32.64c-.221-.11-.387-.499-.387-.776s.166-.443.387-.332l5.432 3.103c.221.111.387.499.387.776.056.333-.166.443-.387.333zM11.807 36.52l-1.552-.887c-.222-.11-.388-.498-.388-.776 0-.277.166-.443.388-.332l1.552.887c.221.11.388.498.388.776 0 .332-.167.498-.388.332z" fill="#F7F7F7" /></svg>
	)
}

export const liveChatIcon = () => {
	return (
		<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 16 16" fill="none" style="width:100%; height:100%;"><path d="M13.333 3.33594C13.333 3.15913 13.2627 2.98961 13.1377 2.86458C13.0127 2.73956 12.8432 2.66927 12.6663 2.66927H3.33301C3.1562 2.66927 2.98668 2.73956 2.86165 2.86458C2.73663 2.98961 2.66634 3.15913 2.66634 3.33594V12.3932L4.19499 10.8646L4.24382 10.8203C4.36245 10.7231 4.51161 10.6693 4.66634 10.6693H12.6663C12.8432 10.6693 13.0127 10.599 13.1377 10.474C13.2627 10.3489 13.333 10.1794 13.333 10.0026V3.33594ZM5.33952 6.0026C5.70771 6.0026 6.00619 6.30108 6.00619 6.66927C6.00619 7.03746 5.70771 7.33594 5.33952 7.33594H5.33301C4.96482 7.33594 4.66634 7.03746 4.66634 6.66927C4.66634 6.30108 4.96482 6.0026 5.33301 6.0026H5.33952ZM8.00619 6.0026C8.37438 6.0026 8.67285 6.30108 8.67285 6.66927C8.67285 7.03746 8.37438 7.33594 8.00619 7.33594H7.99967C7.63148 7.33594 7.33301 7.03746 7.33301 6.66927C7.33301 6.30108 7.63148 6.0026 7.99967 6.0026H8.00619ZM10.6729 6.0026C11.041 6.0026 11.3395 6.30108 11.3395 6.66927C11.3395 7.03746 11.041 7.33594 10.6729 7.33594H10.6663C10.2982 7.33594 9.99967 7.03746 9.99967 6.66927C9.99967 6.30108 10.2982 6.0026 10.6663 6.0026H10.6729ZM14.6663 10.0026C14.6663 10.533 14.4555 11.0416 14.0804 11.4167C13.7053 11.7917 13.1968 12.0026 12.6663 12.0026H4.94238L2.47103 14.474C2.28036 14.6646 1.99358 14.7217 1.74447 14.6185C1.4954 14.5153 1.33301 14.2722 1.33301 14.0026V3.33594C1.33301 2.8055 1.54387 2.29695 1.91895 1.92188C2.29402 1.5468 2.80257 1.33594 3.33301 1.33594H12.6663C13.1968 1.33594 13.7053 1.5468 14.0804 1.92188C14.4555 2.29695 14.6663 2.8055 14.6663 3.33594V10.0026Z" fill="#F6F7F8"></path></svg>
	)
}
