<?php
/**
 * Plugin Name: ZD Embed for Zoom Meeting SDK
 * Plugin URI:  https://zdapps.com.mx/plugins/zd-embed-for-zoom-meeting-sdk/
 * Description: Embeds Zoom meetings inside WordPress using the Zoom Meeting SDK (Web) with secure server-side signature generation. Not affiliated with Zoom.
 * Version:     1.1.2
 * Requires at least: 5.8
 * Requires PHP: 7.4
 * Tested up to: 6.9
 * Author:      ZDApps
 * Author URI:  https://zdapps.com.mx/
 * License:     GPLv2 or later
 * License URI: https://www.gnu.org/licenses/gpl-2.0.html
 * Text Domain: zd-embed-for-zoom-meeting-sdk
 * Domain Path: /languages
 */

if (!defined('ABSPATH')) {
    exit;
}

define('ZDZE_VERSION', '1.1.2');
define('ZDZE_SLUG', 'zd-embed-for-zoom-meeting-sdk');
define('ZDZE_OPTION_KEY', 'zdze_settings');

define('ZDZE_PATH', plugin_dir_path(__FILE__));
define('ZDZE_URL', plugin_dir_url(__FILE__));

require_once ZDZE_PATH . 'includes/helpers.php';
require_once ZDZE_PATH . 'includes/class-zdze-settings.php';
require_once ZDZE_PATH . 'includes/class-zdze-room-cpt.php';
require_once ZDZE_PATH . 'includes/class-zdze-rest.php';
require_once ZDZE_PATH . 'public/class-zdze-public.php';

final class ZDZE_Plugin {

    /** @var ZDZE_Plugin|null */
    private static $instance = null;

    /** @var ZDZE_Settings */
    public $settings;

    /** @var ZDZE_Room_CPT */
    public $rooms;

    /** @var ZDZE_REST */
    public $rest;

    /** @var ZDZE_Public */
    public $public;

    /**
     * Singleton.
     *
     * @return ZDZE_Plugin
     */
    public static function instance() {
        if (self::$instance === null) {
            self::$instance = new self();
        }
        return self::$instance;
    }

    private function __construct() {
        // Components
        $this->settings = new ZDZE_Settings();
        $this->rooms    = new ZDZE_Room_CPT();
        $this->rest     = new ZDZE_REST();
        $this->public   = new ZDZE_Public();

        // Activation / deactivation
        register_activation_hook(__FILE__, array(__CLASS__, 'activate'));
        register_deactivation_hook(__FILE__, array(__CLASS__, 'deactivate'));
    }
    public static function activate() {
        // Ensure CPT is registered before flushing rewrite rules.
        ZDZE_Room_CPT::register_post_type();
        flush_rewrite_rules();
    }

    public static function deactivate() {
        flush_rewrite_rules();
    }
}

ZDZE_Plugin::instance();