<?php
/**
 * Uninstall handler for ZD Zoom Embed (Meeting SDK)
 *
 * By default, we only remove plugin options.
 * If you want to ALSO delete "Zoom Rooms" posts, set:
 * define('ZDZE_DELETE_DATA_ON_UNINSTALL', true);
 */

if (!defined('WP_UNINSTALL_PLUGIN')) {
    exit;
}

delete_option('zdze_settings');

if (defined('ZDZE_DELETE_DATA_ON_UNINSTALL') && ZDZE_DELETE_DATA_ON_UNINSTALL) {
    // Delete custom posts (Zoom Rooms)
    $posts = get_posts(array(
        'post_type'      => 'zdze_room',
        'post_status'    => 'any',
        'numberposts'    => -1,
        'fields'         => 'ids',
        'no_found_rows'  => true,
        'cache_results'  => false,
    ));
    foreach ($posts as $pid) {
        wp_delete_post($pid, true);
    }
}
