<?php
if (!defined('ABSPATH')) {
    exit;
}

class ZDZE_Room_CPT {

    const POST_TYPE = 'zdze_room';

    public function __construct() {
        add_action('init', array(__CLASS__, 'register_post_type'));
        add_action('add_meta_boxes', array($this, 'add_metaboxes'));
        add_action('save_post', array($this, 'save_metaboxes'));
    }

    public static function register_post_type() {
        $labels = array(
            'name'               => __('Salas Zoom', 'zd-embed-for-zoom-meeting-sdk'),
            'singular_name'      => __('Sala Zoom', 'zd-embed-for-zoom-meeting-sdk'),
            'add_new'            => __('Agregar nueva', 'zd-embed-for-zoom-meeting-sdk'),
            'add_new_item'       => __('Agregar nueva Sala Zoom', 'zd-embed-for-zoom-meeting-sdk'),
            'edit_item'          => __('Editar Sala Zoom', 'zd-embed-for-zoom-meeting-sdk'),
            'new_item'           => __('Nueva Sala Zoom', 'zd-embed-for-zoom-meeting-sdk'),
            'view_item'          => __('Ver Sala Zoom', 'zd-embed-for-zoom-meeting-sdk'),
            'search_items'       => __('Buscar Salas Zoom', 'zd-embed-for-zoom-meeting-sdk'),
            'not_found'          => __('No se encontraron salas.', 'zd-embed-for-zoom-meeting-sdk'),
            'not_found_in_trash' => __('No se encontraron salas en la papelera.', 'zd-embed-for-zoom-meeting-sdk'),
            'menu_name'          => __('Salas Zoom', 'zd-embed-for-zoom-meeting-sdk'),
        );

        $args = array(
            'labels'             => $labels,
            'public'             => true,
            'publicly_queryable' => true,
            'show_ui'            => true,
            'show_in_menu'       => true,
            'menu_icon'          => 'dashicons-video-alt3',
            'query_var'          => true,
            'rewrite'            => array('slug' => 'zoom'),
            'capability_type'    => 'post',
            'has_archive'        => false,
            'hierarchical'       => false,
            'supports'           => array('title', 'editor'),
            'show_in_rest'       => true,
        );

        register_post_type(self::POST_TYPE, $args);
    }

    public function add_metaboxes() {
        add_meta_box(
            'zdze_room_details',
            __('Datos de la reunión', 'zd-embed-for-zoom-meeting-sdk'),
            array($this, 'render_metabox'),
            self::POST_TYPE,
            'normal',
            'high'
        );
    }

    public function render_metabox($post) {
        wp_nonce_field('zdze_room_save', 'zdze_room_nonce');

        $meeting_number = get_post_meta($post->ID, '_zdze_meeting_number', true);
        $passcode       = get_post_meta($post->ID, '_zdze_passcode', true);
        $auto_join      = get_post_meta($post->ID, '_zdze_auto_join', true);
        $height         = get_post_meta($post->ID, '_zdze_height', true);

        if ($auto_join === '') {
            $auto_join = '1';
        }
        if ($height === '') {
            $height = '700';
        }

        echo '<table class="form-table" role="presentation">';
        echo '<tr>';
        echo '<th scope="row"><label for="zdze_meeting_number">' . esc_html__('Meeting Number', 'zd-embed-for-zoom-meeting-sdk') . '</label></th>';
        echo '<td><input type="text" id="zdze_meeting_number" name="zdze_meeting_number" value="' . esc_attr($meeting_number) . '" class="regular-text" placeholder="123456789" />';
        echo '<p class="description">' . esc_html__('Número de reunión (sin espacios).', 'zd-embed-for-zoom-meeting-sdk') . '</p></td>';
        echo '</tr>';

        echo '<tr>';
        echo '<th scope="row"><label for="zdze_passcode">' . esc_html__('Passcode', 'zd-embed-for-zoom-meeting-sdk') . '</label></th>';
        echo '<td><input type="text" id="zdze_passcode" name="zdze_passcode" value="' . esc_attr($passcode) . '" class="regular-text" placeholder="ABC123" />';
        echo '<p class="description">' . esc_html__('Código de acceso de la reunión.', 'zd-embed-for-zoom-meeting-sdk') . '</p></td>';
        echo '</tr>';

        echo '<tr>';
        echo '<th scope="row"><label for="zdze_height">' . esc_html__('Altura (px)', 'zd-embed-for-zoom-meeting-sdk') . '</label></th>';
        echo '<td><input type="number" min="400" max="2000" id="zdze_height" name="zdze_height" value="' . esc_attr($height) . '" class="small-text" /> ';
        echo '<p class="description">' . esc_html__('Altura del contenedor embebido.', 'zd-embed-for-zoom-meeting-sdk') . '</p></td>';
        echo '</tr>';

        echo '<tr>';
        echo '<th scope="row">' . esc_html__('Auto-Join', 'zd-embed-for-zoom-meeting-sdk') . '</th>';
        echo '<td>';
        echo '<label><input type="checkbox" name="zdze_auto_join" value="1" ' . checked('1', $auto_join, false) . ' /> ' . esc_html__('Intentar unirse automáticamente (recomendado).', 'zd-embed-for-zoom-meeting-sdk') . '</label>';
        echo '<p class="description">' . esc_html__('Si está desactivado, se muestra un botón para que el usuario haga click y cumpla con políticas de audio del navegador.', 'zd-embed-for-zoom-meeting-sdk') . '</p>';
        echo '</td>';
        echo '</tr>';

        echo '</table>';

        echo '<hr />';
        echo '<p><strong>' . esc_html__('URL de esta Sala:', 'zd-embed-for-zoom-meeting-sdk') . '</strong> ';
        echo '<a href="' . esc_url(get_permalink($post)) . '" target="_blank" rel="noopener noreferrer">' . esc_html(get_permalink($post)) . '</a></p>';
    }

    public function save_metaboxes($post_id) {
        if (!isset($_POST['zdze_room_nonce']) || !wp_verify_nonce(sanitize_text_field(wp_unslash($_POST['zdze_room_nonce'])), 'zdze_room_save')) {
            return;
        }

        if (defined('DOING_AUTOSAVE') && DOING_AUTOSAVE) {
            return;
        }

        if (!current_user_can('edit_post', $post_id)) {
            return;
        }

        if (get_post_type($post_id) !== self::POST_TYPE) {
            return;
        }

        $meeting_number = isset($_POST['zdze_meeting_number']) ? sanitize_text_field(wp_unslash($_POST['zdze_meeting_number'])) : '';
        $passcode       = isset($_POST['zdze_passcode']) ? sanitize_text_field(wp_unslash($_POST['zdze_passcode'])) : '';
        $height         = isset($_POST['zdze_height']) ? absint($_POST['zdze_height']) : 700;
        $auto_join      = isset($_POST['zdze_auto_join']) ? '1' : '0';

        // Normalize meeting number: keep only digits.
        $meeting_number = preg_replace('/[^0-9]/', '', $meeting_number);

        update_post_meta($post_id, '_zdze_meeting_number', $meeting_number);
        update_post_meta($post_id, '_zdze_passcode', $passcode);
        update_post_meta($post_id, '_zdze_height', (string) $height);
        update_post_meta($post_id, '_zdze_auto_join', $auto_join);
    }
}
