# Zoom App Setup (Meeting SDK)

This plugin embeds meetings using the **Zoom Meeting SDK (Web)** and requires an **SDK Key/Secret** (sometimes shown as **Client ID/Client Secret**).

## Steps

1. Open the Zoom App Marketplace.
2. Go to **Develop → Build App**.
3. Create a **General App**.
4. Open **Embed** and enable **Meeting SDK**.
5. Copy **Client ID** and **Client Secret** from **App Credentials**.
6. Paste them into WordPress in **Settings → ZD Embed for Zoom Meeting SDK**, or define them in `wp-config.php`:

```php
define('ZDZE_SDK_KEY', 'YOUR_SDK_KEY_OR_CLIENT_ID');
define('ZDZE_SDK_SECRET', 'YOUR_SDK_SECRET_OR_CLIENT_SECRET');
```

## Official links

- Create Meeting SDK app: https://developers.zoom.us/docs/meeting-sdk/create/
- Meeting SDK authentication (signature): https://developers.zoom.us/docs/meeting-sdk/auth/
- Zoom App Marketplace: https://marketplace.zoom.us/
