<?php
if ( ! defined( 'ABSPATH' ) ) {
    exit; // Exit if accessed directly
}

class Zap_Reviews_Widget extends \Elementor\Widget_Base {

    public function get_name() {
        return 'zap_reviews_widget';
    }

    public function get_title() {
        return __( 'Zap Reviews', 'zap-reviews' );
    }

    public function get_icon() {
        return 'eicon-review';
    }

    public function get_categories() {
        return [ 'general' ];
    }

    protected function _register_controls() {
        $this->start_controls_section(
            'content_section',
            [
                'label' => __( 'Settings', 'zap-reviews' ),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'customer_id',
            [
                'label' => __( 'Customer Zap ID', 'zap-reviews' ),
                'type' => \Elementor\Controls_Manager::TEXT,
                'input_type' => 'text',
                'placeholder' => __( 'Enter Customer ID', 'zap-reviews' ),
                'dynamic' => [
                    'active' => true,
                ],
            ]
        );

        $this->add_control(
            'site_id',
            [
                'label' => __( 'Site ID (Vertical)', 'zap-reviews' ),
                'type' => \Elementor\Controls_Manager::SELECT,
                'default' => '2',
                'options' => [
                    '2' => 'מתחתנים',
                    '3' => 'רסט',
                    '5' => 'דפי זהב',
                ],
            ]
        );

        $this->add_control(
            'show_reviews',
            [
                'label' => __('Show Reviews', 'zap-reviews'),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => __('Show', 'zap-reviews'),
                'label_off' => __('Hide', 'zap-reviews'),
                'return_value' => 'yes',
                'default' => 'yes',
            ]
        );

        $this->add_control(
            'show_score',
            [
                'label' => __('Show Score', 'zap-reviews'),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => __('Show', 'zap-reviews'),
                'label_off' => __('Hide', 'zap-reviews'),
                'return_value' => 'yes',
                'default' => 'yes',
            ]
        );

        $this->end_controls_section();
    }

    protected function render() {
        $settings = $this->get_settings_for_display();
        
        if ('yes' === $settings['show_reviews']) {
            echo '<zap-reviews customer-id="' . esc_attr($settings['customer_id']) . '" site-id="' . esc_attr($settings['site_id']) . '"></zap-reviews>';
        }
        
        if ('yes' === $settings['show_score']) {
            echo '<zap-score customer-id="' . esc_attr($settings['customer_id']) . '" site-id="' . esc_attr($settings['site_id']) . '"></zap-score>';
        }
    }
}

\Elementor\Plugin::instance()->widgets_manager->register_widget_type( new \Zap_Reviews_Widget() );
