<?php
if (!defined('ABSPATH'))
    exit; // Exit if accessed directly

// Debug test file for YoApy Social Poster
// This file will be used to debug task and log display issues

function yoapsopo_debug_info()
{
    if (!current_user_can('manage_options')) {
        return;
    }

    // Get tasks from database
    $tasks = get_option('yoapsopo_tasks', array());

    // Get logs from database
    $logs = get_option('yoapsopo_log', array());

    // Display information
    echo '<div class="wrap">';
    echo '<h1>YoApy Social Poster Debug Info</h1>';

    echo '<h2>Current Tasks</h2>';
    echo '<pre>';
    print_r($tasks);
    echo '</pre>';

    echo '<h2>Recent Logs (Last 20)</h2>';
    $recent_logs = array_slice($logs, -20);
    echo '<pre>';
    print_r($recent_logs);
    echo '</pre>';

    echo '</div>';
}

// Add debug page to admin menu
add_action('admin_menu', function () {
    add_submenu_page(
        'yoapsopo_planner',
        'Debug Info',
        'Debug Info',
        'manage_options',
        'yoapsopo_debug_info',
        'yoapsopo_debug_info'
    );
});