<?php if (!defined('ABSPATH')) {
    exit;
}
$opt = get_option('yoapsopo_settings', array());
$hasKeys = !empty($opt['key_id']) && !empty($opt['secret']);
$imported_accounts = get_option('yoapsopo_accounts', array());
?>

<div class="wrap yoapsopo-wrap !max-w-[1000px] mx-auto font-sans">

    <!-- Header Section -->
    <div class="mb-8 flex flex-col md:flex-row md:items-center justify-between gap-6">
        <div>
            <h1 class="!m-0 text-3xl font-bold text-slate-800 tracking-tight">
                <?php esc_html_e('YoApy Settings', 'yoapy-social-poster'); ?>
            </h1>
            <p class="text-slate-500 mt-2 text-lg">
                <?php esc_html_e('Manage your API keys and connected social accounts.', 'yoapy-social-poster'); ?>
            </p>
        </div>
        <div class="flex items-center gap-3">
            <span class="inline-flex items-center gap-2 rounded-full px-4 py-2 text-sm font-semibold border
                <?php echo esc_attr($hasKeys
                    ? 'bg-emerald-50 text-emerald-700 border-emerald-200'
                    : 'bg-amber-50 text-amber-700 border-amber-200'); ?>">
                <span
                    class="dashicons <?php echo esc_attr($hasKeys ? 'dashicons-yes' : 'dashicons-warning'); ?>"></span>
                <?php echo $hasKeys ? esc_html__('System Ready', 'yoapy-social-poster') : esc_html__('Setup Required', 'yoapy-social-poster'); ?>
            </span>
            <a href="https://yoapy.com" target="_blank" class="yoapsopo-settings-btn yoapsopo-settings-btn-secondary">
                <span class="dashicons dashicons-external"></span>
                <?php esc_html_e('YoApy Dashboard', 'yoapy-social-poster'); ?>
            </a>
        </div>
    </div>

    <!-- Main Grid -->
    <div class="grid grid-cols-1 lg:grid-cols-3 gap-8">

        <!-- Left Column (Credentials & Accounts) -->
        <div class="lg:col-span-2 space-y-8">

            <!-- Credentials Card -->
            <div class="bg-white rounded-xl shadow-sm border border-slate-200 overflow-hidden">
                <div class="px-6 py-4 border-b border-slate-100 bg-slate-50 flex items-center gap-3">
                    <div class="w-8 h-8 rounded-full bg-blue-100 text-blue-600 flex items-center justify-center">
                        <span class="dashicons dashicons-lock"></span>
                    </div>
                    <h2 class="m-0 text-lg font-semibold text-slate-800">
                        <?php esc_html_e('API Credentials', 'yoapy-social-poster'); ?>
                    </h2>
                </div>

                <div class="p-6">
                    <div id="yoapsopo-settings-messages"></div>
                    <form id="yoapsopo-credentials-form" class="space-y-5">
                        <input type="hidden" name="form_type" value="credentials" />

                        <!-- Base URL -->
                        <div>
                            <label
                                class="block text-sm font-medium text-slate-700 mb-1"><?php esc_html_e('Base URL', 'yoapy-social-poster'); ?></label>
                            <input type="url" name="base_url"
                                class="w-full rounded-lg border-slate-300 focus:border-blue-500 focus:ring-blue-500"
                                value="<?php echo esc_attr($opt['base_url'] ?? 'https://api.yoapy.com'); ?>">
                        </div>

                        <!-- Key ID -->
                        <div>
                            <label
                                class="block text-sm font-medium text-slate-700 mb-1"><?php esc_html_e('Key ID', 'yoapy-social-poster'); ?></label>
                            <div class="flex gap-2">
                                <input type="text" id="yoapsopo_key_id" name="key_id"
                                    class="flex-grow rounded-lg border-slate-300 focus:border-blue-500 focus:ring-blue-500 font-mono text-sm"
                                    value="<?php echo esc_attr($opt['key_id'] ?? ''); ?>">
                                <button type="button"
                                    class="px-3 py-2 border border-slate-300 rounded-lg text-slate-600 hover:bg-slate-50"
                                    data-clip="#yoapsopo_key_id"
                                    title="<?php esc_attr_e('Copy', 'yoapy-social-poster'); ?>">
                                    <span class="dashicons dashicons-admin-page"></span>
                                </button>
                            </div>
                        </div>

                        <!-- Secret -->
                        <div>
                            <label
                                class="block text-sm font-medium text-slate-700 mb-1"><?php esc_html_e('Secret Key', 'yoapy-social-poster'); ?></label>
                            <div class="flex gap-2">
                                <div class="relative flex-grow">
                                    <input type="password" id="yoapsopo_secret" name="secret"
                                        class="w-full rounded-lg border-slate-300 focus:border-blue-500 focus:ring-blue-500 font-mono text-sm pr-10"
                                        value="<?php echo esc_attr($opt['secret'] ?? ''); ?>">
                                </div>
                                <button type="button"
                                    class="px-3 py-2 border border-slate-300 rounded-lg text-slate-600 hover:bg-slate-50"
                                    id="yoapsopo_secret_toggle"
                                    title="<?php esc_attr_e('Show/Hide', 'yoapy-social-poster'); ?>">
                                    <span class="dashicons dashicons-visibility"></span>
                                </button>
                            </div>
                            <p class="mt-1 text-xs text-slate-500">
                                <?php esc_html_e('Keep this secret safe. Never share it publicly.', 'yoapy-social-poster'); ?>
                            </p>
                        </div>

                        <div class="pt-2">
                            <button type="submit"
                                class="yoapsopo-settings-btn yoapsopo-settings-btn-primary w-full justify-center">
                                <?php esc_html_e('Save Credentials', 'yoapy-social-poster'); ?>
                            </button>
                        </div>
                    </form>
                </div>
            </div>

            <!-- Connected Accounts Card -->
            <div class="bg-white rounded-xl shadow-sm border border-slate-200 overflow-hidden">
                <div class="px-6 py-4 border-b border-slate-100 bg-slate-50 flex items-center justify-between">
                    <div class="flex items-center gap-3">
                        <div
                            class="w-8 h-8 rounded-full bg-purple-100 text-purple-600 flex items-center justify-center">
                            <span class="dashicons dashicons-networking"></span>
                        </div>
                        <h2 class="m-0 text-lg font-semibold text-slate-800">
                            <?php esc_html_e('Connected Accounts', 'yoapy-social-poster'); ?>
                        </h2>
                    </div>
                    <?php if ($hasKeys): ?>
                        <div class="flex gap-2">
                            <?php if (!empty($imported_accounts)): ?>
                                <button type="button" id="yoapsopo-delete-all-accounts-btn"
                                    class="yoapsopo-settings-btn yoapsopo-settings-btn-danger yoapsopo-settings-btn-sm"
                                    onclick="if(confirm('<?php esc_attr_e('Are you sure you want to delete ALL connected accounts?', 'yoapy-social-poster'); ?>')) { YoApySettings.deleteAllAccounts(); }">
                                    <span class="dashicons dashicons-trash"></span>
                                    <?php esc_html_e('Delete All', 'yoapy-social-poster'); ?>
                                </button>
                            <?php endif; ?>
                            <button type="button" id="yoapsopo-import-accounts-btn"
                                class="yoapsopo-settings-btn yoapsopo-settings-btn-primary yoapsopo-settings-btn-sm">
                                <span class="dashicons dashicons-download"></span>
                                <?php esc_html_e('Import Accounts', 'yoapy-social-poster'); ?>
                            </button>
                        </div>
                    <?php endif; ?>
                </div>

                <div class="p-6" id="yoapsopo-connected-accounts-container">
                    <?php if (empty($imported_accounts)): ?>
                        <!-- Empty State -->
                        <div id="yoapsopo-accounts-empty" class="text-center py-10">
                            <div
                                class="inline-flex items-center justify-center w-16 h-16 rounded-full bg-slate-100 text-slate-400 mb-4">
                                <span class="dashicons dashicons-admin-users text-3xl"></span>
                            </div>
                            <h3 class="text-lg font-medium text-slate-800 mb-2">
                                <?php esc_html_e('No accounts connected', 'yoapy-social-poster'); ?>
                            </h3>
                            <p class="text-slate-500 max-w-sm mx-auto mb-6">
                                <?php esc_html_e('Connect your social media accounts to start posting automatically.', 'yoapy-social-poster'); ?>
                            </p>
                            <?php if ($hasKeys): ?>
                                <button type="button" class="yoapsopo-settings-btn yoapsopo-settings-btn-primary"
                                    onclick="document.getElementById('yoapsopo-import-accounts-btn').click()">
                                    <?php esc_html_e('Import Accounts Now', 'yoapy-social-poster'); ?>
                                </button>
                            <?php else: ?>
                                <div class="text-amber-600 bg-amber-50 px-4 py-2 rounded-lg inline-block text-sm">
                                    <?php esc_html_e('Please configure your API keys first.', 'yoapy-social-poster'); ?>
                                </div>
                            <?php endif; ?>
                        </div>

                        <!-- Accounts Grid (Hidden initially if empty) -->
                        <div id="yoapsopo-accounts-grid" class="grid grid-cols-1 sm:grid-cols-2 gap-4 hidden"></div>
                    <?php else: ?>
                        <!-- Empty State (Hidden initially) -->
                        <div id="yoapsopo-accounts-empty" class="text-center py-10 hidden">
                            <div
                                class="inline-flex items-center justify-center w-16 h-16 rounded-full bg-slate-100 text-slate-400 mb-4">
                                <span class="dashicons dashicons-admin-users text-3xl"></span>
                            </div>
                            <h3 class="text-lg font-medium text-slate-800 mb-2">
                                <?php esc_html_e('No accounts connected', 'yoapy-social-poster'); ?>
                            </h3>
                            <p class="text-slate-500 max-w-sm mx-auto mb-6">
                                <?php esc_html_e('Connect your social media accounts to start posting automatically.', 'yoapy-social-poster'); ?>
                            </p>
                            <button type="button" class="yoapsopo-settings-btn yoapsopo-settings-btn-primary"
                                onclick="document.getElementById('yoapsopo-import-accounts-btn').click()">
                                <?php esc_html_e('Import Accounts Now', 'yoapy-social-poster'); ?>
                            </button>
                        </div>

                        <!-- Accounts Grid -->
                        <div id="yoapsopo-accounts-grid" class="grid grid-cols-1 sm:grid-cols-2 gap-4">
                            <?php foreach ($imported_accounts as $acc):
                                $platform_colors = [
                                    'facebook' => 'bg-blue-50 text-blue-600 border-blue-100',
                                    'instagram' => 'bg-pink-50 text-pink-600 border-pink-100',
                                    'youtube' => 'bg-red-50 text-red-600 border-red-100',
                                    'tiktok' => 'bg-cyan-50 text-cyan-600 border-cyan-100',
                                ];
                                $p_color = $platform_colors[$acc['platform']] ?? 'bg-slate-50 text-slate-600 border-slate-100';
                                ?>
                                <div
                                    class="relative group p-4 rounded-xl border border-slate-200 hover:border-blue-300 hover:shadow-md transition-all bg-white">
                                    <div class="flex items-start gap-3">
                                        <!-- Avatar -->
                                        <div class="shrink-0 relative">
                                            <?php
                                            $first_letter = mb_strtoupper(mb_substr($acc['user_identifier'], 0, 1));
                                            ?>
                                            <!-- Fallback Avatar (Hidden by default if image exists) -->
                                            <div class="yoapsopo-avatar-fallback w-12 h-12 rounded-full bg-slate-100 flex items-center justify-center text-xl font-bold text-slate-500 border border-slate-200"
                                                style="<?php echo esc_attr(!empty($acc['picture_url']) ? 'display: none;' : ''); ?>">
                                                <?php echo esc_html($first_letter); ?>
                                            </div>

                                            <?php if (!empty($acc['picture_url'])): ?>
                                                <img src="<?php echo esc_url($acc['picture_url']); ?>"
                                                    class="w-12 h-12 rounded-full object-cover border border-slate-100 shadow-sm"
                                                    onerror="this.style.display='none'; this.previousElementSibling.style.display='flex';">
                                            <?php endif; ?>
                                        </div>

                                        <!-- Delete Button (Absolute) -->
                                        <button type="button"
                                            class="absolute top-2 right-2 p-1.5 rounded-full bg-white text-slate-400 hover:text-red-500 hover:bg-red-50 border border-slate-200 shadow-sm opacity-0 group-hover:opacity-100 transition-all z-10"
                                            onclick="if(confirm('<?php esc_attr_e('Delete this account?', 'yoapy-social-poster'); ?>')) { YoApySettings.deleteAccount('<?php echo esc_attr($acc['account_id'] ?: $acc['user_identifier']); ?>'); }"
                                            title="<?php esc_attr_e('Delete Account', 'yoapy-social-poster'); ?>">
                                            <span class="dashicons dashicons-trash"
                                                style="font-size: 16px; width: 16px; height: 16px;"></span>
                                        </button>

                                        <!-- Info -->
                                        <div class="min-w-0 flex-grow">
                                            <div class="flex items-center gap-2 mb-1">
                                                <span
                                                    class="text-xs font-bold uppercase tracking-wider px-2 py-0.5 rounded-full border <?php echo esc_attr($p_color); ?>">
                                                    <?php echo esc_html($acc['platform']); ?>
                                                </span>
                                            </div>
                                            <h3 class="font-semibold text-slate-800 truncate"
                                                title="<?php echo esc_attr($acc['account_name']); ?>">
                                                <?php echo esc_html($acc['account_name'] ?: __('Unnamed Account', 'yoapy-social-poster')); ?>
                                            </h3>
                                            <p class="text-sm text-slate-500 truncate">
                                                @<?php echo esc_html($acc['user_identifier']); ?></p>
                                        </div>
                                    </div>
                                </div>
                            <?php endforeach; ?>
                        </div>
                    <?php endif; ?>
                </div>
            </div>

        </div>

        <!-- Right Column (Sidebar) -->
        <div class="space-y-6">

            <!-- Connection Test -->
            <div class="bg-white rounded-xl shadow-sm border border-slate-200 p-6">
                <h3 class="m-0 text-base font-semibold text-slate-800 mb-4 flex items-center gap-2">
                    <span class="dashicons dashicons-rss text-green-600"></span>
                    <?php esc_html_e('Connection Status', 'yoapy-social-poster'); ?>
                </h3>

                <div id="yoapsopo-connection-status-message"></div>
                <form id="yoapsopo-test-connection-form">
                    <button type="submit"
                        class="w-full yoapsopo-settings-btn yoapsopo-settings-btn-secondary justify-center"
                        name="yoapsopo_ping" value="1" <?php disabled(!$hasKeys); ?>>
                        <span class="dashicons dashicons-controls-repeat"></span>
                        <?php esc_html_e('Test Connection', 'yoapy-social-poster'); ?>
                    </button>
                </form>

                <p class="mt-3 text-xs text-slate-500 text-center">
                    <?php esc_html_e('Verifies your API keys and server connectivity.', 'yoapy-social-poster'); ?>
                </p>
            </div>

            <!-- Quick Help -->
            <div class="bg-blue-50 rounded-xl border border-blue-100 p-6">
                <h3 class="m-0 text-base font-semibold text-blue-900 mb-4 flex items-center gap-2">
                    <span class="dashicons dashicons-editor-help"></span>
                    <?php esc_html_e('Quick Guide', 'yoapy-social-poster'); ?>
                </h3>

                <ul class="space-y-3">
                    <li class="flex gap-3 text-sm text-blue-800">
                        <span
                            class="flex-shrink-0 w-6 h-6 rounded-full bg-blue-200 text-blue-700 flex items-center justify-center font-bold text-xs">1</span>
                        <span><?php esc_html_e('Get your API keys from YoApy.com', 'yoapy-social-poster'); ?></span>
                    </li>
                    <li class="flex gap-3 text-sm text-blue-800">
                        <span
                            class="flex-shrink-0 w-6 h-6 rounded-full bg-blue-200 text-blue-700 flex items-center justify-center font-bold text-xs">2</span>
                        <span><?php esc_html_e('Enter credentials and save', 'yoapy-social-poster'); ?></span>
                    </li>
                    <li class="flex gap-3 text-sm text-blue-800">
                        <span
                            class="flex-shrink-0 w-6 h-6 rounded-full bg-blue-200 text-blue-700 flex items-center justify-center font-bold text-xs">3</span>
                        <span><?php esc_html_e('Click "Import Accounts" to sync', 'yoapy-social-poster'); ?></span>
                    </li>
                    <li class="flex gap-3 text-sm text-blue-800">
                        <span
                            class="flex-shrink-0 w-6 h-6 rounded-full bg-blue-200 text-blue-700 flex items-center justify-center font-bold text-xs">4</span>
                        <span><?php esc_html_e('Start creating tasks in the Planner', 'yoapy-social-poster'); ?></span>
                    </li>
                </ul>
            </div>

        </div>
    </div>

    <!-- Settings Errors -->
    <div class="mt-6">
        <?php settings_errors(); ?>
    </div>
</div>

<!-- Import Accounts Modal -->
<div id="yoapsopo-import-modal" class="yoapsopo-modal"
    style="display: none; position: fixed; top: 0; left: 0; width: 100%; height: 100%; z-index: 9999;">
    <div class="yoapsopo-modal-overlay"
        style="position: absolute; top: 0; left: 0; width: 100%; height: 100%; background: rgba(0,0,0,0.5); backdrop-filter: blur(2px);">
    </div>
    <div class="yoapsopo-modal-content"
        style="position: relative; width: 90%; max-width: 600px; margin: 50px auto; background: #fff; border-radius: 12px; box-shadow: 0 20px 25px -5px rgba(0, 0, 0, 0.1), 0 10px 10px -5px rgba(0, 0, 0, 0.04); display: flex; flex-direction: column; max-height: 85vh; overflow: hidden;">

        <!-- Header -->
        <div class="flex items-center justify-between p-5 border-b border-slate-100 bg-slate-50">
            <div>
                <h3 class="m-0 text-xl font-bold text-slate-800">
                    <?php esc_html_e('Import Accounts', 'yoapy-social-poster'); ?>
                </h3>
                <p class="text-sm text-slate-500 mt-1">
                    <?php esc_html_e('Select the accounts you want to connect.', 'yoapy-social-poster'); ?>
                </p>
            </div>
            <button type="button"
                class="yoapsopo-modal-close text-slate-400 hover:text-slate-600 p-2 rounded-full hover:bg-slate-200 transition-colors">
                <span class="dashicons dashicons-no-alt text-xl"></span>
            </button>
        </div>

        <!-- Body -->
        <div class="p-5 overflow-y-auto flex-grow bg-white">

            <!-- Loading State -->
            <div id="yoapsopo-import-loading" class="text-center py-12">
                <div class="inline-block animate-spin rounded-full h-10 w-10 border-b-2 border-blue-600 mb-4"></div>
                <p class="text-slate-600 font-medium">
                    <?php esc_html_e('Fetching accounts from YoApy...', 'yoapy-social-poster'); ?>
                </p>
            </div>

            <!-- Empty State -->
            <div id="yoapsopo-import-empty" class="text-center py-12 hidden">
                <div
                    class="inline-flex items-center justify-center w-16 h-16 rounded-full bg-amber-50 text-amber-500 mb-4">
                    <span class="dashicons dashicons-warning text-3xl"></span>
                </div>
                <h4 class="text-lg font-medium text-slate-800 mb-2">
                    <?php esc_html_e('No accounts found', 'yoapy-social-poster'); ?>
                </h4>
                <p class="text-slate-500 max-w-xs mx-auto">
                    <?php esc_html_e('Make sure you have connected your social accounts on the YoApy dashboard.', 'yoapy-social-poster'); ?>
                </p>
                <a href="https://yoapy.com" target="_blank"
                    class="mt-4 inline-block text-blue-600 hover:underline font-medium">
                    <?php esc_html_e('Go to YoApy Dashboard &rarr;', 'yoapy-social-poster'); ?>
                </a>
            </div>

            <!-- Error State -->
            <div id="yoapsopo-import-error" class="text-center py-12 hidden">
                <div class="inline-flex items-center justify-center w-16 h-16 rounded-full bg-red-50 text-red-500 mb-4">
                    <span class="dashicons dashicons-dismiss text-3xl"></span>
                </div>
                <h4 class="text-lg font-medium text-slate-800 mb-2">
                    <?php esc_html_e('Connection Failed', 'yoapy-social-poster'); ?>
                </h4>
                <p class="text-red-500 max-w-xs mx-auto"></p>
            </div>

            <!-- Accounts List -->
            <div id="yoapsopo-import-list" class="space-y-6"></div>

        </div>

        <!-- Footer -->
        <div class="p-5 border-t border-slate-100 bg-slate-50 flex justify-end gap-3">
            <button type="button"
                class="yoapsopo-modal-close px-4 py-2 rounded-lg border border-slate-300 text-slate-700 hover:bg-white transition-colors font-medium">
                <?php esc_html_e('Cancel', 'yoapy-social-poster'); ?>
            </button>
            <button type="button" id="yoapsopo-save-import-btn"
                class="px-6 py-2 rounded-lg bg-blue-600 text-white hover:bg-blue-700 transition-colors font-medium shadow-sm disabled:opacity-50 disabled:cursor-not-allowed"
                disabled>
                <?php esc_html_e('Import Selected', 'yoapy-social-poster'); ?>
            </button>
        </div>

    </div>
</div>