<?php if (!defined('ABSPATH')) {
    exit;
}

// Inclui funções de ajuda (helpers)
require_once 'helpers.php';

// Get all tasks directly from the planner
$planner = YOAPSOPO_Planner::get_instance();
$all_tasks = $planner->get_tasks();

// Pagination variables
$tasks_per_page_options = array(10, 50, 100);
$tasks_per_page = absint($_GET['per_page'] ?? 50);
if (!in_array($tasks_per_page, $tasks_per_page_options)) {
    $tasks_per_page = 50;
}
$current_page = max(1, absint($_GET['paged'] ?? 1));
$offset = ($current_page - 1) * $tasks_per_page;

// Get all tasks for pagination calculation
$all_tasks = is_array($all_tasks) ? $all_tasks : array();
$total_tasks = count($all_tasks);
$total_pages = ceil($total_tasks / $tasks_per_page);

// Slice tasks for current page
$paginated_tasks = array_slice($all_tasks, $offset, $tasks_per_page);

// Obtém tarefas, KPIs e configurações
$tasks = $paginated_tasks;
$kpis = array('pending' => 0, 'scheduled' => 0, 'processing' => 0, 'complete' => 0, 'error' => 0);
foreach ($all_tasks as $t) {
    $k = strtolower($t['status'] ?? 'pending');
    if (isset($kpis[$k]))
        $kpis[$k]++;
}

$opt = get_option('yoapsopo_settings', array());
$hasKeys = YOAPSOPO_Client::has_keys();

// Prepara os nomes de usuário (@handles) para o preview
$yoapsopo_handle_default = !empty($opt['account']) ? ltrim($opt['account'], '@') : 'yourusername';
$yoapsopo_handles = array(
    'facebook' => !empty($opt['account_facebook']) ? ltrim($opt['account_facebook'], '@') : $yoapsopo_handle_default,
    'instagram' => !empty($opt['account_instagram']) ? ltrim($opt['account_instagram'], '@') : $yoapsopo_handle_default,
    'youtube' => !empty($opt['account_youtube']) ? ltrim($opt['account_youtube'], '@') : $yoapsopo_handle_default,
    'tiktok' => !empty($opt['account_tiktok']) ? ltrim($opt['account_tiktok'], '@') : $yoapsopo_handle_default,
);
$imported_accounts = get_option('yoapsopo_accounts', array());
?>

<div class="wrap yoapsopo-wrap">
    <!-- Cabeçalho Principal com KPIs -->
    <div class="mb-8 rounded-2xl p-8 text-white shadow-lg" style="background:linear-gradient(135deg,#0ea5e9,#7c3aed)">
        <div class="flex flex-col gap-6 md:flex-row md:items-center md:justify-between">
            <div>
                <h1 class="!m-0 text-3xl font-bold"><?php esc_html_e('YoApy Planner', 'yoapy-social-poster'); ?></h1>
                <p class="opacity-90 mt-2 text-lg">
                    <?php esc_html_e('Schedule independent publications and track their status.', 'yoapy-social-poster'); ?>
                </p>
            </div>
            <div class="flex flex-wrap gap-3">
                <a href="<?php echo esc_url(admin_url('admin.php?page=yoapsopo_settings')); ?>"
                    class="yoapsopo-btn yoapsopo-btn-secondary">
                    <span class="dashicons dashicons-admin-generic"></span>
                    <?php esc_html_e('Settings', 'yoapy-social-poster'); ?>
                </a>
            </div>
        </div>
        <div class="mt-6 grid grid-cols-2 gap-4 md:grid-cols-5">
            <div class="rounded-xl bg-white/15 p-4 backdrop-blur-sm transition-all hover:bg-white/20">
                <div class="text-sm opacity-90 font-medium"><?php esc_html_e('Pending', 'yoapy-social-poster'); ?>
                </div>
                <div class="text-2xl font-bold mt-1"><?php echo intval($kpis['pending']); ?></div>
            </div>
            <div class="rounded-xl bg-white/15 p-4 backdrop-blur-sm transition-all hover:bg-white/20">
                <div class="text-sm opacity-90 font-medium"><?php esc_html_e('Scheduled', 'yoapy-social-poster'); ?>
                </div>
                <div class="text-2xl font-bold mt-1"><?php echo intval($kpis['scheduled']); ?></div>
            </div>
            <div class="rounded-xl bg-white/15 p-4 backdrop-blur-sm transition-all hover:bg-white/20">
                <div class="text-sm opacity-90 font-medium"><?php esc_html_e('Processing', 'yoapy-social-poster'); ?>
                </div>
                <div class="text-2xl font-bold mt-1"><?php echo intval($kpis['processing']); ?></div>
            </div>
            <div class="rounded-xl bg-white/15 p-4 backdrop-blur-sm transition-all hover:bg-white/20">
                <div class="text-sm opacity-90 font-medium"><?php esc_html_e('Completed', 'yoapy-social-poster'); ?>
                </div>
                <div class="text-2xl font-bold mt-1"><?php echo intval($kpis['complete']); ?></div>
            </div>
            <div class="rounded-xl bg-white/15 p-4 backdrop-blur-sm transition-all hover:bg-white/20">
                <div class="text-sm opacity-90 font-medium"><?php esc_html_e('Errors', 'yoapy-social-poster'); ?>
                </div>
                <div class="text-2xl font-bold mt-1"><?php echo intval($kpis['error']); ?></div>
            </div>
        </div>
    </div>

    <?php if (!$hasKeys): ?>
        <div class="rounded-2xl bg-amber-50 p-5 mb-8 border border-amber-100">
            <div class="flex items-start gap-3">
                <span class="dashicons dashicons-warning text-amber-500 text-xl mt-0.5"></span>
                <p class="m-0 text-amber-800">
                    <?php
                    /* translators: 1: opening <a> tag linking to the Settings page; 2: closing </a> tag. */
                    printf(esc_html__('Configure your YoApy API keys in %1$sSettings%2$s to send tasks.', 'yoapy-social-poster'), '<a href="' . esc_url(admin_url('admin.php?page=yoapsopo_settings')) . '" class="font-semibold text-amber-700 hover:underline">', '</a>'); ?>
                </p>
            </div>
        </div>
    <?php endif; ?>

    <!-- ====== Linha 1: Composer (esquerda) + Preview (direita) ====== -->
    <div class="grid gap-8 lg:grid-cols-[1.1fr_0.9fr]">
        <!-- COMPOSER -->
        <div class="rounded-2xl border border-slate-200 bg-white p-6 shadow-lg transition-all hover:shadow-xl">
            <div class="yoapsopo-section-header">
                <span class="dashicons dashicons-edit text-blue-500"></span>
                <h2><?php esc_html_e('New Task', 'yoapy-social-poster'); ?></h2>
            </div>
            <form method="post" action="<?php echo esc_url(admin_url('admin-post.php')); ?>" id="yoapsopo_form_task"
                class="space-y-6">
                <?php wp_nonce_field('yoapsopo_save_task'); ?>
                <input type="hidden" name="action" value="yoapsopo_save_task" />
                <!-- Redes (com Toggles) -->
                <div>
                    <label
                        class="mb-3 block text-base font-medium text-slate-700"><?php esc_html_e('Networks', 'yoapy-social-poster'); ?></label>
                    <div class="flex flex-wrap gap-5">
                        <?php foreach (['facebook' => 'Facebook', 'instagram' => 'Instagram', 'youtube' => 'YouTube', 'tiktok' => 'TikTok'] as $k => $label):
                            $colors = [
                                'facebook' => 'peer-checked:bg-[#1877F2]',
                                'instagram' => 'peer-checked:bg-gradient-to-r peer-checked:from-[#f58529] peer-checked:via-[#dd2a7b] peer-checked:to-[#515bd4]',
                                'youtube' => 'peer-checked:bg-[#FF0000]',
                                'tiktok' => 'peer-checked:bg-gradient-to-r peer-checked:from-[#69C9D0] peer-checked:to-[#EE1D52]'
                            ];
                            ?>
                            <label class="inline-flex items-center gap-3 cursor-pointer">
                                <input type="checkbox" name="networks[]" value="<?php echo esc_attr($k); ?>"
                                    class="sr-only peer">
                                <div class="yoapsopo-track <?php echo esc_attr($colors[$k]); ?>">
                                    <div class="yoapsopo-thumb"></div>
                                </div>
                                <span class="text-base font-medium text-slate-700"><?php echo esc_html($label); ?></span>
                            </label>
                        <?php endforeach; ?>
                    </div>
                </div>

                <!-- Network Account Info Sections -->
                <?php foreach (['facebook' => 'Facebook', 'instagram' => 'Instagram', 'youtube' => 'YouTube', 'tiktok' => 'TikTok'] as $network_key => $network_label): ?>
                    <div class="yoapsopo-section yoapsopo-account-section"
                        id="yoapsopo_<?php echo esc_attr($network_key); ?>_account_section"
                        style="display: none; background: #f0f9ff; border: 1px solid #bae6fd; padding: 10px; border-radius: 6px; margin: 10px 0; position: relative;">
                        <h4
                            style="margin-top: 0; color: #0ea5e9; font-size: 14px; display: flex; align-items: center; gap: 8px;">
                            <?php
                            // Different icons for each network
                            switch ($network_key) {
                                case 'facebook':
                                    echo '<svg width="16" height="16" viewBox="0 0 24 24" fill="currentColor"><path d="M24 12.073c0-6.627-5.373-12-12-12s-12 5.373-12 12c0 5.99 4.388 10.954 10.125 11.854v-8.385H7.078v-3.47h3.047V9.43c0-3.007 1.792-4.669 4.533-4.669 1.312 0 2.686.235 2.686.235v2.953H15.83c-1.491 0-1.956.925-1.956 1.874v2.25h3.328l-.532 3.47h-2.796v8.385C19.612 23.027 24 18.062 24 12.073z"/></svg>';
                                    break;
                                case 'instagram':
                                    echo '<svg width="16" height="16" viewBox="0 0 24 24" fill="currentColor">
<path d="M12 2.163c3.204 0 3.584.012 4.85.07 3.252.148 4.771 1.691 4.919 4.919.058 1.265.069 1.645.069 4.849 0 3.205-.012 3.584-.069 4.849-.149 3.225-1.664 4.771-4.919 4.919-1.266.057-1.644.069-4.849.069-3.26-.149-4.771-1.699-4.919-4.92-.058-1.265-.07-1.689-.07-4.948 0-3.259-.014-3.668-.072-4.947-.196-4.358-2.618-6.78-6.98-6.98C8.333 23.986 8.741 24 12 24c3.259 0 3.668-.014 4.948-.072 4.354-.2 6.782-2.618 6.979-6.98.059-1.28.073-1.689.073-4.948 0-3.259-.014-3.667-.072-4.947-.196-4.354-2.617-6.78-6.979-6.98C15.668.014 15.259 0 12 0zm0 5.838a6.162 6.162 0 100 12.324 6.162 6.162 0 000-12.324zM12 16a4 4 0 110-8 4 4 0 010 8zm6.406-11.845a1.44 1.44 0 100 2.881 1.44 1.44 0 000-2.881z"/></svg>';
                                    break;
                                case 'youtube':
                                    echo '<svg width="16" height="16" viewBox="0 0 24 24" fill="currentColor"><path d="M19.615 3.184c-3.604-.246-11.631-.245-15.23 0-3.897.266-4.356 2.62-4.385 8.816.029 6.185.484 8.549 4.385 8.816 3.6.245 11.626.246 15.23 0 3.897-.266 4.356-2.62 4.385-8.816-.029-6.185-.484-8.549-4.385-8.816zm-10.615 12.816v-8l8 3.993-8 4.007z"/></svg>';
                                    break;
                                case 'tiktok':
                                    echo '<svg width="16" height="16" viewBox="0 0 24 24" fill="currentColor"><path d="M12.53.02C13.84 0 15.14.01 16.44 0c.08 1.53.63 3.09 1.75 4.17 1.12 1.11 2.7 1.62 4.24 1.79v4.03c-1.44-.05-2.89-.35-4.2-.97-.57-.26-1.1-.59-1.62-.93-.01 2.92.01 5.84-.02 8.75-.08 1.4-.54 2.79-1.35 3.94-1.31 1.92-3.58 3.17-5.91 3.21-1.43.08-2.86-.31-4.08-1.03-2.02-1.19-3.44-3.37-3.65-5.71-.02-.5-.03-1-.01-1.49.18-1.9 1.12-3.72 2.58-4.96 1.66-1.44 3.98-2.13 6.15-1.72.02 1.48-.04 2.96-.04 4.44-.99-.32-2.15-.23-3.02.37-.63.41-1.11 1.04-1.36 1.75-.21.51-.15 1.07-.14 1.61.24 1.64 1.82 3.02 3.5 2.87 1.12-.01 2.19-.66 2.77-1.61.19-.33.4-.67.41-1.06.1-1.79.06-3.57.07-5.36.01-4.03-.01-8.05.02-12.07z"/></svg>';
                                    break;
                            }
                            ?>

                            <?php printf(esc_html__('%s Accounts', 'yoapy-social-poster'), esc_html($network_label)); ?>
                        </h4>

                        <div class="yoapsopo-accounts-list space-y-2">
                            <?php
                            // Filter accounts for this network
                            $net_accounts = array_filter($imported_accounts, function ($acc) use ($network_key) {
                                return $acc['platform'] === $network_key;
                            });

                            if (!empty($net_accounts)):
                                foreach ($net_accounts as $acc):
                                    $acc_handle = $acc['user_identifier'];
                                    $acc_name = $acc['account_name'] ?: $acc_handle;
                                    $acc_avatar = $acc['picture_url'];
                                    ?>
                                    <label
                                        class="flex items-center gap-3 p-2 rounded hover:bg-white border border-transparent hover:border-slate-200 cursor-pointer transition-all">
                                        <input type="checkbox" name="accounts[<?php echo esc_attr($network_key); ?>][]"
                                            value="<?php echo esc_attr($acc_handle); ?>"
                                            data-handle="<?php echo esc_attr($acc_handle); ?>"
                                            data-name="<?php echo esc_attr($acc_name); ?>"
                                            data-avatar="<?php echo esc_attr($acc_avatar); ?>"
                                            class="rounded border-slate-300 text-blue-600 focus:ring-blue-500" checked>

                                        <div class="flex items-center gap-3 flex-grow">
                                            <div
                                                class="w-8 h-8 rounded-full bg-slate-100 flex items-center justify-center overflow-hidden border border-slate-200">
                                                <?php if ($acc_avatar): ?>
                                                    <img src="<?php echo esc_url($acc_avatar); ?>" class="w-full h-full object-cover">
                                                <?php else: ?>
                                                    <span class="text-xs">👤</span>
                                                <?php endif; ?>
                                            </div>
                                            <div>
                                                <div class="font-medium text-sm text-slate-800 leading-tight">
                                                    <?php echo esc_html($acc_name); ?>
                                                </div>
                                                <div class="text-xs text-slate-500">@<?php echo esc_html($acc_handle); ?></div>
                                            </div>
                                        </div>
                                    </label>
                                    <?php
                                endforeach;
                            else:
                                // No imported accounts found
                                ?>

                                <div class="mt-2 text-xs text-amber-600 bg-amber-50 p-2 rounded border border-amber-100">
                                    <a href="<?php echo esc_url(admin_url('admin.php?page=yoapsopo_settings')); ?>"
                                        class="hover:underline">
                                        <?php esc_html_e('Import accounts in Settings to select multiple pages.', 'yoapy-social-poster'); ?>
                                    </a>
                                </div>
                            <?php endif; ?>
                        </div>
                    </div>
                <?php endforeach; ?>

                <!-- Tipo -->
                <div>
                    <label
                        class="mb-2 block text-base font-medium text-slate-700"><?php esc_html_e('Type', 'yoapy-social-poster'); ?></label>
                    <select name="type" class="yoapsopo-select">
                        <option value="image">🖼️ <?php esc_html_e('Image Post (FB/IG)', 'yoapy-social-poster'); ?>
                        </option>
                        <option value="video">🎬
                            <?php esc_html_e('Video/Reels (IG/FB/YouTube/TikTok)', 'yoapy-social-poster'); ?>
                        </option>
                        <option value="story">📒 <?php esc_html_e('Story (FB/IG)', 'yoapy-social-poster'); ?></option>
                        <option value="live_schedule">🔴
                            <?php esc_html_e('YouTube Live Schedule', 'yoapy-social-poster'); ?>
                        </option>
                    </select>
                </div>
                <!-- Texto -->
                <div>
                    <div class="flex items-center justify-between mb-2">
                        <label
                            class="block text-base font-medium text-slate-700"><?php esc_html_e('Caption / Title', 'yoapy-social-poster'); ?></label>
                        <span id="yoapsopo_char"
                            class="px-3 py-1 rounded-full bg-blue-50 text-blue-600 font-medium">0</span>
                    </div>
                    <textarea name="text" rows="5" id="yoapsopo_text" class="yoapsopo-textarea"
                        placeholder="<?php esc_attr_e('Write your text... (#hashtags, @mentions)', 'yoapy-social-poster'); ?>"></textarea>
                </div>
                <!-- Mídias com Drag & Drop -->
                <div class="grid gap-6 md:grid-cols-2">
                    <div>
                        <label
                            class="mb-2 block text-base font-medium text-slate-700"><?php esc_html_e('Image URL', 'yoapy-social-poster'); ?></label>
                        <div class="flex gap-3">
                            <input type="url" id="yoapsopo_image_url" name="image_url" class="yoapsopo-input"
                                placeholder="<?php esc_attr_e('https://...', 'yoapy-social-poster'); ?>">
                            <button type="button" class="yoapsopo-btn yoapsopo-btn-secondary yoapsopo-planner-pick"
                                data-target="#yoapsopo_image_url">
                                <span class="dashicons dashicons-format-image"></span>
                            </button>
                        </div>
                        <div id="yoapsopo_dz_img" class="yoapsopo-dz mt-3" data-target="#yoapsopo_image_url"
                            data-accept="image/*">
                            <input class="yoapsopo-dz-file" type="file" accept="image/*" hidden>
                            <div class="yoapsopo-dz-inner">
                                <div class="yoapsopo-dz-ic text-2xl">🖼️</div>
                                <div class="yoapsopo-dz-title font-semibold">
                                    <?php esc_html_e('Drag image here', 'yoapy-social-poster'); ?>
                                </div>
                                <div class="yoapsopo-dz-sub"><?php esc_html_e('or', 'yoapy-social-poster'); ?> <button
                                        type="button"
                                        class="yoapsopo-dz-browse font-medium"><?php esc_html_e('click to choose', 'yoapy-social-poster'); ?></button>
                                </div>
                            </div>
                            <div class="yoapsopo-dz-progress" hidden><span></span></div>
                        </div>
                    </div>
                    <div>
                        <label
                            class="mb-2 block text-base font-medium text-slate-700"><?php esc_html_e('Video URL', 'yoapy-social-poster'); ?></label>
                        <div class="flex gap-3">
                            <input type="url" id="yoapsopo_video_url" name="video_url" class="yoapsopo-input"
                                placeholder="<?php esc_attr_e('https://...', 'yoapy-social-poster'); ?>">
                            <button type="button" class="yoapsopo-btn yoapsopo-btn-secondary yoapsopo-planner-pick"
                                data-target="#yoapsopo_video_url">
                                <span class="dashicons dashicons-video-alt3"></span>
                            </button>
                        </div>
                        <div id="yoapsopo_dz_vid" class="yoapsopo-dz mt-3" data-target="#yoapsopo_video_url"
                            data-accept="video/*">
                            <input class="yoapsopo-dz-file" type="file" accept="video/*" hidden>
                            <div class="yoapsopo-dz-inner">
                                <div class="yoapsopo-dz-ic text-2xl">🎬</div>
                                <div class="yoapsopo-dz-title font-semibold">
                                    <?php esc_html_e('Drag video here', 'yoapy-social-poster'); ?>
                                </div>
                                <div class="yoapsopo-dz-sub"><?php esc_html_e('or', 'yoapy-social-poster'); ?> <button
                                        type="button"
                                        class="yoapsopo-dz-browse font-medium"><?php esc_html_e('click to choose', 'yoapy-social-poster'); ?></button>
                                </div>
                            </div>
                            <div class="yoapsopo-dz-progress" hidden><span></span></div>
                        </div>
                    </div>
                </div>
                <!-- Article URL -->
                <div>
                    <label
                        class="mb-2 block text-base font-medium text-slate-700"><?php esc_html_e('Article URL (FB optional)', 'yoapy-social-poster'); ?></label>
                    <input type="url" name="article_url" class="yoapsopo-input"
                        placeholder="<?php esc_attr_e('https://...', 'yoapy-social-poster'); ?>">
                </div>
                <!-- Agendamento -->
                <div>
                    <label
                        class="mb-2 block text-base font-medium text-slate-700"><?php esc_html_e('Schedule', 'yoapy-social-poster'); ?></label>
                    <input type="datetime-local" name="when" class="yoapsopo-input">
                    <small
                        class="text-slate-500 mt-1 block"><?php esc_html_e('Leave empty to send now.', 'yoapy-social-poster'); ?></small>
                </div>

                <!-- TikTok Specific Fields (Hidden by default, shown when TikTok is selected) -->
                <div class="yoapsopo-section yoapsopo-tiktok-fields" id="yoapsopo_tiktok_fields"
                    style="display: none; background: #fffbe6; border-color: #ffd591; padding: 1rem; border-radius: 0.5rem;">
                    <h4 style="margin-top: 0; color: #fa8c16;">🎵
                        <?php esc_html_e('TikTok Post Settings', 'yoapy-social-poster'); ?>
                    </h4>

                    <!-- Creator Info Display -->
                    <div class="yoapsopo-tiktok-creator-info" id="yoapsopo_tiktok_creator_info"
                        style="margin-bottom: 15px; display: none;">
                        <!-- Accounts will be injected here via JS -->
                    </div>
                    <div class="yoapsopo-tiktok-creator-loading" id="yoapsopo_tiktok_creator_loading"
                        style="margin-bottom: 15px; padding: 10px; display: none;">
                        <span class="dashicons dashicons-update spin"></span>
                        <span
                            class="yoapsopo-tiktok-loading-text"><?php esc_html_e('Fetching creator info...', 'yoapy-social-poster'); ?></span>
                    </div>
                    <div class="yoapsopo-tiktok-creator-error" id="yoapsopo_tiktok_creator_error"
                        style="margin-bottom: 15px; padding: 10px; background: #fee; border: 1px solid #fcc; border-radius: 6px; color: #c33; display: none;">
                        <span class="dashicons dashicons-warning"></span>
                        <span
                            class="yoapsopo-tiktok-error-text"><?php esc_html_e('Failed to fetch creator info', 'yoapy-social-poster'); ?></span>
                    </div>

                    <!-- Privacy Status -->
                    <div class="yoapsopo-field">
                        <label
                            class="mb-2 block text-base font-medium text-slate-700"><?php esc_html_e('Privacy Status', 'yoapy-social-poster'); ?>
                            <span style="color: #ff4d4f;">*</span></label>
                        <select name="tiktok_privacy" class="yoapsopo-select" id="yoapsopo_tiktok_privacy">
                            <option value=""><?php esc_html_e('Select Privacy Status', 'yoapy-social-poster'); ?>
                            </option>
                            <option value="SELF_ONLY"><?php esc_html_e('Only Me', 'yoapy-social-poster'); ?></option>
                            <option value="FOLLOWER_OF_CREATOR"><?php esc_html_e('Friends', 'yoapy-social-poster'); ?>
                            </option>
                            <option value="MUTUAL_FOLLOW_FRIENDS">
                                <?php esc_html_e('Mutual Friends', 'yoapy-social-poster'); ?>
                            </option>
                            <option value="PUBLIC_TO_EVERYONE"><?php esc_html_e('Everyone', 'yoapy-social-poster'); ?>
                            </option>
                        </select>
                        <p class="text-slate-500 mt-1 text-sm">
                            <?php esc_html_e('Select who can view your TikTok post. For branded content, visibility must be set to Everyone.', 'yoapy-social-poster'); ?>
                        </p>
                    </div>

                    <!-- Interaction Abilities -->
                    <div class="yoapsopo-field">
                        <label
                            class="mb-2 block text-base font-medium text-slate-700"><?php esc_html_e('Interaction Settings', 'yoapy-social-poster'); ?></label>
                        <div class="flex flex-col gap-2">
                            <label class="inline-flex items-center">
                                <input type="checkbox" name="tiktok_allow_comment" value="1"
                                    id="yoapsopo_tiktok_allow_comment"
                                    class="rounded border-slate-300 text-blue-600 focus:ring-blue-500">
                                <span class="ml-2"><?php esc_html_e('Allow Comments', 'yoapy-social-poster'); ?></span>
                            </label>
                            <label class="inline-flex items-center">
                                <input type="checkbox" name="tiktok_allow_duet" value="1"
                                    id="yoapsopo_tiktok_allow_duet"
                                    class="rounded border-slate-300 text-blue-600 focus:ring-blue-500">
                                <span class="ml-2"><?php esc_html_e('Allow Duet', 'yoapy-social-poster'); ?></span>
                            </label>
                            <label class="inline-flex items-center">
                                <input type="checkbox" name="tiktok_allow_stitch" value="1"
                                    id="yoapsopo_tiktok_allow_stitch"
                                    class="rounded border-slate-300 text-blue-600 focus:ring-blue-500">
                                <span class="ml-2"><?php esc_html_e('Allow Stitch', 'yoapy-social-poster'); ?></span>
                            </label>
                        </div>
                    </div>

                    <!-- Commercial Content Disclosure -->
                    <div class="yoapsopo-field">
                        <label
                            class="mb-2 block text-base font-medium text-slate-700"><?php esc_html_e('Commercial Content', 'yoapy-social-poster'); ?></label>
                        <div class="mb-3">
                            <label class="inline-flex items-center cursor-pointer">
                                <input type="checkbox" name="tiktok_commercial_toggle" value="1"
                                    id="yoapsopo_tiktok_commercial_toggle" class="sr-only peer">
                                <div class="yoapsopo-track peer-checked:bg-blue-500">
                                    <div class="yoapsopo-thumb"></div>
                                </div>
                                <span
                                    class="ml-3 text-base font-medium text-slate-700"><?php esc_html_e('This content promotes a brand or product', 'yoapy-social-poster'); ?></span>
                            </label>
                        </div>

                        <div id="yoapsopo_tiktok_commercial_options"
                            style="display: none; padding: 12px; background: #fff; border-radius: 6px; border: 1px solid #e5e7eb;">
                            <div class="mb-3">
                                <label class="inline-flex items-center mb-2">
                                    <input type="checkbox" name="tiktok_commercial_your_brand" value="1"
                                        id="yoapsopo_tiktok_commercial_your_brand"
                                        class="rounded border-slate-300 text-blue-600 focus:ring-blue-500">
                                    <span
                                        class="ml-2"><?php esc_html_e('Your Brand (Promoting yourself or your own business)', 'yoapy-social-poster'); ?></span>
                                </label>
                                <p class="ml-6 text-slate-500 text-xs">
                                    <?php esc_html_e('Your photo/video will be labeled as "Promotional content"', 'yoapy-social-poster'); ?>
                                </p>
                            </div>

                            <div>
                                <label class="inline-flex items-center mb-2">
                                    <input type="checkbox" name="tiktok_commercial_branded" value="1"
                                        id="yoapsopo_tiktok_commercial_branded"
                                        class="rounded border-slate-300 text-blue-600 focus:ring-blue-500">
                                    <span
                                        class="ml-2"><?php esc_html_e('Branded Content (Promoting another brand or third party)', 'yoapy-social-poster'); ?></span>
                                </label>
                                <p class="ml-6 text-slate-500 text-xs">
                                    <?php esc_html_e('Your photo/video will be labeled as "Paid partnership"', 'yoapy-social-poster'); ?>
                                </p>
                            </div>

                            <p class="mt-3 text-slate-500 text-xs">
                                <?php esc_html_e('You need to indicate if your content promotes yourself, a third party, or both.', 'yoapy-social-poster'); ?>
                            </p>
                        </div>
                    </div>

                    <!-- User Consent Declaration -->
                    <div class="yoapsopo-field">
                        <label class="inline-flex items-start">
                            <input type="checkbox" name="tiktok_consent" value="1" id="yoapsopo_tiktok_consent"
                                class="mt-1 rounded border-slate-300 text-blue-600 focus:ring-blue-500" required>
                            <span class="ml-2">
                                <span id="yoapsopo_tiktok_consent_text">
                                    <?php esc_html_e('By posting, you agree to TikTok\'s Music Usage Confirmation', 'yoapy-social-poster'); ?>
                                </span>
                            </span>
                        </label>
                    </div>
                </div>

                <!-- Ações do Formulário -->
                <div class="flex flex-col items-stretch gap-4 sm:flex-row sm:items-center pt-4">
                    <input type="text" class="w-full max-w-xs yoapsopo-input" name="title"
                        placeholder="<?php esc_attr_e('Title (internal)', 'yoapy-social-poster'); ?>">
                    <button type="submit" class="yoapsopo-btn yoapsopo-btn-primary" id="yoapsopo_btn_save" <?php if (!$hasKeys)
                        echo 'disabled'; ?>>
                        <span class="dashicons dashicons-yes"></span>
                        <?php esc_html_e('Save Task', 'yoapy-social-poster'); ?>
                    </button>
                </div>
            </form>
        </div>

        <!-- PREVIEW -->
        <div
            class="rounded-2xl border border-slate-200 bg-white p-6 shadow-lg lg:sticky lg:top-8 transition-all hover:shadow-xl">
            <div id="yoapsopo_prev_meta" data-default="<?php echo esc_attr($yoapsopo_handle_default); ?>"
                data-facebook="<?php echo esc_attr($yoapsopo_handles['facebook']); ?>"
                data-instagram="<?php echo esc_attr($yoapsopo_handles['instagram']); ?>"
                data-youtube="<?php echo esc_attr($yoapsopo_handles['youtube']); ?>"
                data-tiktok="<?php echo esc_attr($yoapsopo_handles['tiktok']); ?>" class="hidden"></div>
            <div class="yoapsopo-section-header">
                <span class="dashicons dashicons-visibility text-blue-500"></span>
                <h2><?php esc_html_e('Preview', 'yoapy-social-poster'); ?></h2>
            </div>
            <div id="yoapsopo_prev_modes" class="mb-5 flex flex-wrap gap-2">
                <button type="button" data-mode="feed" class="yoapsopo-pill yoapsopo-pill--active">📰
                    <?php esc_html_e('Feed', 'yoapy-social-poster'); ?></button>
                <button type="button" data-mode="story" class="yoapsopo-pill">📒
                    <?php esc_html_e('Stories', 'yoapy-social-poster'); ?></button>
                <button type="button" data-mode="reels" class="yoapsopo-pill">🎞️
                    <?php esc_html_e('Reels', 'yoapy-social-poster'); ?></button>
                <button type="button" data-mode="tiktok" class="yoapsopo-pill">🎵
                    <?php esc_html_e('TikTok', 'yoapy-social-poster'); ?></button>
                <button type="button" data-mode="youtube" class="yoapsopo-pill">▶️
                    <?php esc_html_e('YouTube', 'yoapy-social-poster'); ?></button>
                <button type="button" data-mode="shorts" class="yoapsopo-pill">🎬
                    <?php esc_html_e('Shorts', 'yoapy-social-poster'); ?></button>
            </div>
            <div class="h-[560px] md:h-[640px] flex items-center justify-center w-full">
                <div id="yoapsopo_device" class="yoapsopo-device" data-mode="feed">
                    <div id="yoapsopo_prev_frame" class="yoapsopo-ar" style="--yoapsopo-ar:125%;">
                        <div class="yoapsopo-ar-obj">
                            <?php include 'preview-facebook.php'; ?>
                            <?php include 'preview-instagram.php'; ?>
                            <?php include 'preview-stories.php'; ?>
                            <?php include 'preview-reels.php'; ?>
                            <?php include 'preview-tiktok.php'; ?>
                            <?php include 'preview-youtube.php'; ?>
                            <?php include 'preview-shorts.php'; ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- ====== Linha 2: Lista de Tarefas com Novo Design ====== -->
    <div class="mt-10 rounded-2xl bg-white border border-slate-200 shadow-lg">
        <div class="px-6 py-5 border-b border-slate-100">
            <div class="yoapsopo-section-header">
                <span class="dashicons dashicons-list-view text-blue-500"></span>
                <h2><?php esc_html_e('Tasks', 'yoapy-social-poster'); ?></h2>
            </div>
        </div>

        <!-- Per Page Selector -->
        <div class="px-6 py-4 bg-slate-50">
            <div class="yoapsopo-per-page">
                <label for="yoapsopo_tasks_per_page"
                    class="font-medium text-slate-700"><?php esc_html_e('Tasks per page:', 'yoapy-social-poster'); ?></label>
                <form method="get" id="yoapsopo-tasks-per-page-form" class="inline-block">
                    <input type="hidden" name="page" value="yoapsopo_planner" />
                    <select name="per_page" id="yoapsopo_tasks_per_page" onchange="this.form.submit()"
                        class="yoapsopo-select ml-2">
                        <?php foreach ($tasks_per_page_options as $option): ?>
                            <option value="<?php echo esc_attr($option); ?>" <?php selected($tasks_per_page, $option); ?>>
                                <?php echo esc_html($option); ?>
                            </option>
                        <?php endforeach; ?>
                    </select>
                </form>
            </div>
        </div>

        <div class="p-4 md:p-6">
            <!-- Tabela para Desktop -->
            <div class="hidden md:block yoapsopo-table-wrap">
                <table class="yoapsopo-tasks-table">
                    <thead>
                        <tr>
                            <th class="w-1/4"><?php esc_html_e('Title', 'yoapy-social-poster'); ?></th>
                            <th class="w-1/6"><?php esc_html_e('Networks', 'yoapy-social-poster'); ?></th>
                            <th class="w-1/3"><?php esc_html_e('Status & Results', 'yoapy-social-poster'); ?></th>
                            <th class="w-1/6"><?php esc_html_e('Actions', 'yoapy-social-poster'); ?></th>
                        </tr>
                    </thead>
                    <tbody id="yoapsopo_tasks_tbody">
                        <!-- RENDERIZAÇÃO INICIAL DAS TAREFAS VIA PHP -->
                        <?php foreach ($tasks as $t): ?>
                            <tr data-id="<?php echo intval($t['id']); ?>" class="transition-colors hover:bg-slate-50">
                                <td class="align-top">
                                    <div class="font-semibold text-slate-800 text-base">
                                        <?php echo esc_html($t['title'] ?: '—'); ?>
                                    </div>
                                    <div class="text-sm text-slate-500 mt-1"><?php echo esc_html(ucfirst($t['type'])); ?>
                                    </div>
                                    <?php if (!empty($t['when'])): ?>
                                        <?php if ($t['status'] === 'complete'): ?>
                                            <div class="text-xs text-slate-500 mt-2">
                                                ✅ <?php esc_html_e('Posted on', 'yoapy-social-poster'); ?>
                                                <?php echo esc_html(date_i18n('M j, Y g:i A', $t['when'])); ?>
                                            </div>
                                        <?php elseif ($t['status'] === 'scheduled'): ?>
                                            <div class="text-xs text-slate-500 mt-2">
                                                🕒 <?php esc_html_e('Scheduled for', 'yoapy-social-poster'); ?>
                                                <?php echo esc_html(date_i18n('M j, Y g:i A', $t['when'])); ?>
                                            </div>
                                        <?php else: ?>
                                            <div class="text-xs text-slate-500 mt-2">
                                                📅 <?php esc_html_e('Created on', 'yoapy-social-poster'); ?>
                                                <?php echo esc_html(date_i18n('M j, Y g:i A', $t['when'])); ?>
                                            </div>
                                        <?php endif; ?>
                                    <?php elseif ($t['status'] === 'complete'): ?>
                                        <!-- For immediate tasks that don't have a scheduled time -->
                                        <div class="text-xs text-slate-500 mt-2">
                                            ✅ <?php esc_html_e('Posted on', 'yoapy-social-poster'); ?>
                                            <?php echo esc_html(date_i18n('M j, Y g:i A', time())); ?>
                                        </div>
                                    <?php endif; ?>
                                </td>
                                <td class="align-top">
                                    <div class="flex flex-wrap gap-2">
                                        <?php foreach ((array) ($t['networks'] ?? []) as $n)
                                            echo wp_kses_post(yoapsopo_net_chip($n)); ?>
                                    </div>
                                </td>
                                <td class="align-top">
                                    <?php echo wp_kses_post(yoapsopo_status_badge($t['status'] ?? '—')); ?>
                                    <?php if (!empty($t['results']) && is_array($t['results'])): ?>
                                        <div class="mt-3 space-y-2 text-sm">
                                            <?php foreach ($t['results'] as $net => $result):
                                                $net_name = ucfirst($net);
                                                if (!empty($result['permalink'])):
                                                    $plink = $result['permalink'];
                                                    // Normalize relative permalinks
                                                    if (strpos($plink, '/') === 0 && strpos($plink, '//') !== 0) {
                                                        $base_net = strpos($net, ':') !== false ? explode(':', $net)[0] : $net;
                                                        $domain_map = array('facebook' => 'https://www.facebook.com', 'instagram' => 'https://www.instagram.com', 'youtube' => 'https://www.youtube.com', 'tiktok' => 'https://www.tiktok.com');
                                                        $plink = ($domain_map[$base_net] ?? 'https://www.facebook.com') . $plink;
                                                    }
                                                    ?>
                                                    <a href="<?php echo esc_url($plink); ?>" target="_blank"
                                                        class="yoapsopo-result-link"><?php echo esc_html($net_name); ?></a>
                                                <?php elseif (isset($result['success']) && $result['success'] === false): ?>
                                                    <div class="yoapsopo-result-error"
                                                        title="<?php echo esc_attr($result['message'] ?? __('Unknown error', 'yoapy-social-poster')); ?>">
                                                        <?php echo esc_html($net_name . ': ' . __('Error', 'yoapy-social-poster')); ?>
                                                    </div>
                                                <?php endif;
                                            endforeach; ?>
                                        </div>
                                    <?php endif; ?>
                                    <!-- View Log Link -->
                                    <div class="mt-3">
                                        <a href="<?php echo esc_url(admin_url('admin.php?page=yoapsopo_logs')); ?>"
                                            class="yoapsopo-btn yoapsopo-btn-secondary text-xs">
                                            <span class="dashicons dashicons-external"></span>
                                            <?php esc_html_e('View Logs', 'yoapy-social-poster'); ?>
                                        </a>
                                    </div>
                                </td>
                                <td class="align-top">
                                    <div class="flex flex-col gap-2">
                                        <button class="yoapsopo-btn yoapsopo-btn-primary yoapsopo-act text-sm py-2"
                                            data-act="send">
                                            <span class="dashicons dashicons-migrate"></span>
                                            <?php esc_html_e('Post', 'yoapy-social-poster'); ?>
                                        </button>
                                        <button
                                            class="yoapsopo-btn yoapsopo-btn-danger button-link-delete yoapsopo-act yoapsopo-btn-delete-custom text-sm py-2"
                                            style="color: #fff !important;" data-act="delete">
                                            <span class="dashicons dashicons-trash"></span>
                                            <?php esc_html_e('Delete', 'yoapy-social-poster'); ?>
                                        </button>
                                    </div>
                                </td>
                            </tr>
                        <?php endforeach; ?>
                    </tbody>
                </table>
            </div>

            <!-- Cards para Mobile (Ainda renderizado via JS para simplicidade) -->
            <div class="md:hidden space-y-4" id="yoapsopo_tasks_cards"></div>

            <!-- Placeholder para quando não houver tarefas -->
            <div id="yoapsopo-no-tasks-placeholder" class="py-16 text-center text-slate-500" <?php if (!empty($tasks))
                echo 'style="display: none;"'; ?>>
                <div class="mx-auto h-16 w-16 text-slate-300 mb-4">
                    <svg fill="none" viewBox="0 0 24 24" stroke="currentColor">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5"
                            d="M9 5H7a2 2 0 00-2 2v12a2 2 0 002 2h10a2 2 0 002-2V7a2 2 0 00-2-2h-2M9 5a2 2 0 012-2h2a2 2 0 012 2m-3 7h3m-3 4h3m-6-4h.01M9 16h.01" />
                    </svg>
                </div>
                <h3 class="text-lg font-semibold text-slate-700">
                    <?php esc_html_e('No tasks yet', 'yoapy-social-poster'); ?>
                </h3>
                <p class="mt-2 text-slate-500">
                    <?php esc_html_e('Create your first publication using the form above.', 'yoapy-social-poster'); ?>
                </p>
            </div>

            <!-- Pagination -->
            <?php if ($total_pages > 1): ?>
                <div class="yoapsopo-tasks-pagination mt-8">
                    <?php
                    // Add per_page parameter to pagination links
                    $page_links = paginate_links(array(
                        'base' => add_query_arg(array('paged' => '%#%', 'per_page' => $tasks_per_page)),
                        'format' => '',
                        'prev_text' => '&laquo;',
                        'next_text' => '&raquo;',
                        'total' => $total_pages,
                        'current' => $current_page,
                        'type' => 'array',
                        'end_size' => 2,
                        'mid_size' => 2
                    ));

                    if (is_array($page_links)) {
                        foreach ($page_links as $link) {
                            echo wp_kses_post($link);
                        }
                    }
                    ?>
                </div>
            <?php endif; ?>
        </div>
    </div>
</div>

<!-- Meta para Upload e Scripts -->
<div id="yoapsopo_media_meta" data-upload-url="<?php echo esc_url(admin_url('async-upload.php')); ?>"
    data-media-nonce="<?php echo esc_attr(wp_create_nonce('media-form')); ?>" class="hidden"></div>