<?php
/**
 * Metabox template for YoApy Social Poster
 *
 * @package YoApySocialPoster
 * @since 1.0.0
 */

// Prevent direct access
if (!defined('ABSPATH')) {
    exit;
}

// Extract variables passed from the admin class
$tiktok_privacy = isset($tiktok_privacy) ? $tiktok_privacy : '';
$tiktok_allow_comment = isset($tiktok_allow_comment) ? $tiktok_allow_comment : '1';
$tiktok_allow_duet = isset($tiktok_allow_duet) ? $tiktok_allow_duet : '1';
$tiktok_allow_stitch = isset($tiktok_allow_stitch) ? $tiktok_allow_stitch : '1';
$tiktok_commercial_toggle = isset($tiktok_commercial_toggle) ? $tiktok_commercial_toggle : '0';
$tiktok_commercial_your_brand = isset($tiktok_commercial_your_brand) ? $tiktok_commercial_your_brand : '0';
$tiktok_commercial_branded = isset($tiktok_commercial_branded) ? $tiktok_commercial_branded : '0';
$tiktok_consent = isset($tiktok_consent) ? $tiktok_consent : '0';

// Get accounts from settings for all networks
$client = new YOAPSOPO_Client();
$imported_accounts = get_option('yoapsopo_accounts', array());
$opt = get_option('yoapsopo_settings', array());
$account_default = ltrim($opt['account'] ?? '', '@');
$per_network = array(
    'facebook' => ltrim($opt['account_facebook'] ?? '', '@'),
    'instagram' => ltrim($opt['account_instagram'] ?? '', '@'),
    'youtube' => ltrim($opt['account_youtube'] ?? '', '@'),
    'tiktok' => ltrim($opt['account_tiktok'] ?? '', '@'),
);

// Function to get account for a specific network
function get_account_for_network($network, $per_network, $account_default)
{
    $h = trim($per_network[$network] ?? '');
    return $h !== '' ? $h : $account_default;
}

$accounts = array(
    'facebook' => get_account_for_network('facebook', $per_network, $account_default),
    'instagram' => get_account_for_network('instagram', $per_network, $account_default),
    'youtube' => get_account_for_network('youtube', $per_network, $account_default),
    'tiktok' => get_account_for_network('tiktok', $per_network, $account_default)
);
?>
<div class="yoapsopo-metabox-wrapper">
    <?php if (!$has_keys): ?>
        <div class="yoapsopo-notice-warning">
            🔑 <strong><?php esc_html_e('Need API Keys?', 'yoapy-social-poster'); ?></strong>
            <?php esc_html_e('Create them for free at', 'yoapy-social-poster'); ?>
            <a href="https://yoapy.com" target="_blank" rel="noopener">yoapy.com</a>.
        </div>
    <?php endif; ?>

    <?php if (!$has_keys): ?>
        <div class="yoapsopo-notice-warning-box">
            <p>
                <?php esc_html_e('Configure your YoApy API keys in Settings before posting.', 'yoapy-social-poster'); ?>
            </p>
        </div>
    <?php endif; ?>

    <div class="yoapsopo-section">
        <div class="yoapsopo-field">
            <label class="yoapsopo-checkbox-label">
                <input type="checkbox" name="yoapsopo_enabled" value="1" <?php checked('1', $enabled); ?>>
                <?php esc_html_e('Auto-post when published', 'yoapy-social-poster'); ?>
            </label>
        </div>
    </div>

    <div class="yoapsopo-section">
        <div class="yoapsopo-field">
            <label class="yoapsopo-label"><?php esc_html_e('Post Type', 'yoapy-social-poster'); ?></label>
            <select name="yoapsopo_type" class="yoapsopo-select" id="yoapsopo_type">
                <option value="image" <?php selected($type, 'image'); ?>>
                    🖼️ <?php esc_html_e('Image Post', 'yoapy-social-poster'); ?>
                </option>
                <option value="video" <?php selected($type, 'video'); ?>>
                    🎬 <?php esc_html_e('Video/YouTube/Reels', 'yoapy-social-poster'); ?>
                </option>
                <option value="story" <?php selected($type, 'story'); ?>>
                    📒 <?php esc_html_e('Story (FB/IG)', 'yoapy-social-poster'); ?>
                </option>
                <option value="live_schedule" <?php selected($type, 'live_schedule'); ?>>
                    🔴 <?php esc_html_e('YouTube Live Schedule', 'yoapy-social-poster'); ?>
                </option>
            </select>
        </div>
    </div>

    <div class="yoapsopo-section">
        <div class="yoapsopo-field">
            <label class="yoapsopo-label"><?php esc_html_e('Networks', 'yoapy-social-poster'); ?></label>
            <div class="yoapsopo-networks">
                <?php
                $network_options = array(
                    'facebook' => 'Facebook',
                    'instagram' => 'Instagram',
                    'youtube' => 'YouTube',
                    'tiktok' => 'TikTok',
                );

                foreach ($network_options as $key => $label):
                    ?>
                    <label class="yoapsopo-network-checkbox">
                        <input type="checkbox" name="yoapsopo_networks[]" value="<?php echo esc_attr($key); ?>" <?php checked(in_array($key, $networks, true)); ?>>
                        <?php echo esc_html($label); ?>
                    </label>
                <?php endforeach; ?>
            </div>
        </div>
    </div>

    <!-- Network Account Info Sections -->
    <?php foreach ($network_options as $network_key => $network_label): ?>
        <div class="yoapsopo-section yoapsopo-account-section"
            id="yoapsopo_<?php echo esc_attr($network_key); ?>_account_section"
            style="display: none; background: #f0f9ff; border: 1px solid #bae6fd; padding: 10px; border-radius: 6px; margin: 10px 0;">
            <h4 style="margin-top: 0; color: #0ea5e9; font-size: 14px; display: flex; align-items: center; gap: 8px;">
                <?php
                // Different icons for each network
                switch ($network_key) {
                    case 'facebook':
                        echo '<svg width="16" height="16" viewBox="0 0 24 24" fill="currentColor"><path d="M24 12.073c0-6.627-5.373-12-12-12s-12 5.373-12 12c0 5.99 4.388 10.954 10.125 11.854v-8.385H7.078v-3.47h3.047V9.43c0-3.007 1.792-4.669 4.533-4.669 1.312 0 2.686.235 2.686.235v2.953H15.83c-1.491 0-1.956.925-1.956 1.874v2.25h3.328l-.532 3.47h-2.796v8.385C19.612 23.027 24 18.062 24 12.073z"/></svg>';
                        break;
                    case 'instagram':
                        echo '<svg width="16" height="16" viewBox="0 0 24 24" fill="currentColor"><path d="M12 2.163c3.204 0 3.584.012 4.85.07 3.252.148 4.771 1.691 4.919 4.919.058 1.265.069 1.645.069 4.849 0 3.205-.012 3.584-.069 4.849-.149 3.225-1.664 4.771-4.919 4.919-1.266.058-1.644.07-4.85.07-3.204 0-3.584-.012-4.849-.07-3.26-.149-4.771-1.699-4.919-4.92-.058-1.265-.07-1.689-.07-4.948 0-3.259.013-3.583.07-4.947-.196-4.358 2.618-6.78 6.98 6.98C8.333 23.986 8.741 24 12 24c3.259 0 3.668-.014 4.948-.072 4.354-.2 6.782-2.618 6.979-6.98.059-1.28.073-1.689.073-4.948 0-3.259-.014-3.667-.072-4.947-.196-4.354-2.617-6.78-6.979-6.98C15.668.014 15.259 0 12 0zm0 5.838a6.162 6.162 0 100 12.324 6.162 6.162 0 000-12.324zM12 16a4 4 0 110-8 4 4 0 010 8zm6.406-11.845a1.44 1.44 0 100 2.881 1.44 1.44 0 000-2.881z"/></svg>';
                        break;
                    case 'youtube':
                        echo '<svg width="16" height="16" viewBox="0 0 24 24" fill="currentColor"><path d="M19.615 3.184c-3.604-.246-11.631-.245-15.23 0-3.897.266-4.356 2.62-4.385 8.816.029 6.185.484 8.549 4.385 8.816 3.6.245 11.626.246 15.23 0 3.897-.266 4.356-2.62 4.385-8.816-.029-6.185-.484-8.549-4.385-8.816zm-10.615 12.816v-8l8 3.993-8 4.007z"/></svg>';
                        break;
                    case 'tiktok':
                        echo '<svg width="16" height="16" viewBox="0 0 24 24" fill="currentColor"><path d="M12.53.02C13.84 0 15.14.01 16.44 0c.08 1.53.63 3.09 1.75 4.17 1.12 1.11 2.7 1.62 4.24 1.79v4.03c-1.44-.05-2.89-.35-4.2-.97-.57-.26-1.1-.59-1.62-.93-.01 2.92.01 5.84-.02 8.75-.08 1.4-.54 2.79-1.35 3.94-1.31 1.92-3.58 3.17-5.91 3.21-1.43.08-2.86-.31-4.08-1.03-2.02-1.19-3.44-3.37-3.65-5.71-.02-.5-.03-1-.01-1.49.18-1.9 1.12-3.72 2.58-4.96 1.66-1.44 3.98-2.13 6.15-1.72.02 1.48-.04 2.96-.04 4.44-.99-.32-2.15-.23-3.02.37-.63.41-1.11 1.04-1.36 1.75-.21.51-.15 1.07-.14 1.61.24 1.64 1.82 3.02 3.5 2.87 1.12-.01 2.19-.66 2.77-1.61.19-.33.4-.67.41-1.06.1-1.79.06-3.57.07-5.36.01-4.03-.01-8.05.02-12.07z"/></svg>';
                        break;
                }
                ?>
                <?php printf(esc_html__('%s Accounts', 'yoapy-social-poster'), esc_html($network_label)); ?>
            </h4>

            <div class="yoapsopo-accounts-list" style="display: flex; flex-direction: column; gap: 8px;">
                <?php
                // Filter accounts for this network
                $net_accounts = array_filter($imported_accounts, function ($acc) use ($network_key) {
                    return $acc['platform'] === $network_key;
                });

                if (!empty($net_accounts)):
                    foreach ($net_accounts as $acc):
                        $acc_handle = $acc['user_identifier'];
                        $acc_name = $acc['account_name'] ?: $acc_handle;
                        $acc_avatar = $acc['picture_url'];
                        ?>
                        <label style="display: flex; align-items: center; gap: 10px; cursor: pointer;">
                            <input type="checkbox" name="yoapsopo_accounts[<?php echo esc_attr($network_key); ?>][]"
                                value="<?php echo esc_attr($acc_handle); ?>" data-handle="<?php echo esc_attr($acc_handle); ?>"
                                data-name="<?php echo esc_attr($acc_name); ?>" data-avatar="<?php echo esc_attr($acc_avatar); ?>"
                                class="yoapsopo-account-checkbox">

                            <div style="display: flex; align-items: center; gap: 10px;">
                                <div class="yoapsopo-account-avatar"
                                    style="width: 32px; height: 32px; border-radius: 50%; background: #f3f4f6; display: flex; align-items: center; justify-content: center; overflow: hidden;">
                                    <?php if ($acc_avatar): ?>
                                        <img src="<?php echo esc_url($acc_avatar); ?>"
                                            style="width: 100%; height: 100%; object-fit: cover;">
                                    <?php else: ?>
                                        <span style="font-size: 16px;">
                                            <?php
                                            switch ($network_key) {
                                                case 'facebook':
                                                    echo 'f';
                                                    break;
                                                case 'instagram':
                                                    echo '📷';
                                                    break;
                                                case 'youtube':
                                                    echo '▶';
                                                    break;
                                                case 'tiktok':
                                                    echo '🎵';
                                                    break;
                                            }
                                            ?>
                                        </span>
                                    <?php endif; ?>
                                </div>
                                <div>
                                    <div style="font-weight: 600; font-size: 13px;">
                                        <?php echo esc_html($acc_name); ?>
                                    </div>
                                    <div style="font-size: 11px; color: #6b7280;">
                                        @<?php echo esc_html($acc_handle); ?>
                                    </div>
                                </div>
                            </div>
                        </label>
                        <?php
                    endforeach;
                else:
                    ?>
                    <p style="font-size: 12px; color: #6b7280; margin: 0;">
                        <?php esc_html_e('No accounts found. Please import accounts in Settings.', 'yoapy-social-poster'); ?>
                    </p>
                <?php endif; ?>
            </div>
        </div>
    <?php endforeach; ?>

    <!-- Video Field -->
    <div class="yoapsopo-section yoapsopo-media-field yoapsopo-video-field" id="yoapsopo_video_field"
        style="display: none;">
        <div class="yoapsopo-field">
            <label class="yoapsopo-label"><?php esc_html_e('Video URL', 'yoapy-social-poster'); ?></label>
            <div style="display: flex; gap: 8px; align-items: flex-start;">
                <input type="text" name="yoapsopo_video" id="yoapsopo_video" class="yoapsopo-input"
                    placeholder="<?php esc_attr_e('Video URL (required for video posts)', 'yoapy-social-poster'); ?>"
                    value="<?php echo esc_attr($video); ?>" style="flex: 1;" />
                <button type="button" class="button yoapsopo-pick" data-target="#yoapsopo_video"
                    style="height: 36px; white-space: nowrap;">
                    <?php esc_html_e('Choose Video', 'yoapy-social-poster'); ?>
                </button>
            </div>
            <?php if (!empty($video)): ?>
                <div class="yoapsopo-preview-video" style="margin-top: 8px;">
                    <video controls style="max-width: 100%; height: auto;">
                        <source src="<?php echo esc_url($video); ?>" type="video/mp4">
                        <?php esc_html_e('Your browser does not support the video tag.', 'yoapy-social-poster'); ?>
                    </video>
                </div>
            <?php endif; ?>
            <p class="yoapsopo-help-text" id="yoapsopo_video_required"
                style="display: none; color: #ef4444; font-weight: bold; margin-top: 4px;">
                <?php esc_html_e('Video URL is required for video posts.', 'yoapy-social-poster'); ?>
            </p>
        </div>
    </div>

    <div class="yoapsopo-section">
        <div class="yoapsopo-field">
            <label class="yoapsopo-label"><?php esc_html_e('Caption / Title', 'yoapy-social-poster'); ?></label>
            <textarea name="yoapsopo_text" class="yoapsopo-textarea" rows="3"
                placeholder="<?php esc_attr_e('Enter caption or title...', 'yoapy-social-poster'); ?>"><?php echo esc_textarea($text); ?></textarea>
        </div>
    </div>

    <div class="yoapsopo-section yoapsopo-tiktok-fields" id="yoapsopo_tiktok_fields"
        style="display: none; background: #fffbe6; border-color: #ffd591;">
        <h4 style="margin-top: 0; color: #fa8c16;">🎵
            <?php esc_html_e('TikTok Post Settings', 'yoapy-social-poster'); ?>
        </h4>

        <!-- Privacy Status -->
        <div class="yoapsopo-field">
            <label class="yoapsopo-label"><?php esc_html_e('Privacy Status', 'yoapy-social-poster'); ?> <span
                    style="color: #ff4d4f;">*</span></label>
            <select name="yoapsopo_tiktok_privacy" class="yoapsopo-select" id="yoapsopo_tiktok_privacy">
                <option value=""><?php esc_html_e('Select Privacy Status', 'yoapy-social-poster'); ?></option>
                <option value="SELF_ONLY" <?php selected($tiktok_privacy, 'SELF_ONLY'); ?>>
                    <?php esc_html_e('Only Me', 'yoapy-social-poster'); ?>
                </option>
                <option value="FOLLOWER_OF_CREATOR" <?php selected($tiktok_privacy, 'FOLLOWER_OF_CREATOR'); ?>>
                    <?php esc_html_e('Friends', 'yoapy-social-poster'); ?>
                </option>
                <option value="MUTUAL_FOLLOW_FRIENDS" <?php selected($tiktok_privacy, 'MUTUAL_FOLLOW_FRIENDS'); ?>>
                    <?php esc_html_e('Mutual Friends', 'yoapy-social-poster'); ?>
                </option>
                <option value="PUBLIC_TO_EVERYONE" <?php selected($tiktok_privacy, 'PUBLIC_TO_EVERYONE'); ?>>
                    <?php esc_html_e('Everyone', 'yoapy-social-poster'); ?>
                </option>
            </select>
            <p class="yoapsopo-help-text">
                <?php esc_html_e('Select who can view your TikTok post. For branded content, visibility must be set to Everyone.', 'yoapy-social-poster'); ?>
            </p>
        </div>

        <!-- Interaction Abilities -->
        <div class="yoapsopo-field">
            <label class="yoapsopo-label"><?php esc_html_e('Interaction Settings', 'yoapy-social-poster'); ?></label>
            <div style="display: flex; flex-direction: column; gap: 8px;">
                <label style="display: flex; align-items: center;">
                    <input type="checkbox" name="yoapsopo_tiktok_allow_comment" value="1"
                        id="yoapsopo_tiktok_allow_comment" <?php checked('1', $tiktok_allow_comment); ?>>
                    <span style="margin-left: 8px;"><?php esc_html_e('Allow Comments', 'yoapy-social-poster'); ?></span>
                </label>
                <label style="display: flex; align-items: center;">
                    <input type="checkbox" name="yoapsopo_tiktok_allow_duet" value="1" id="yoapsopo_tiktok_allow_duet"
                        <?php checked('1', $tiktok_allow_duet); ?>>
                    <span style="margin-left: 8px;"><?php esc_html_e('Allow Duet', 'yoapy-social-poster'); ?></span>
                </label>
                <label style="display: flex; align-items: center;">
                    <input type="checkbox" name="yoapsopo_tiktok_allow_stitch" value="1"
                        id="yoapsopo_tiktok_allow_stitch" <?php checked('1', $tiktok_allow_stitch); ?>>
                    <span style="margin-left: 8px;"><?php esc_html_e('Allow Stitch', 'yoapy-social-poster'); ?></span>
                </label>
            </div>
        </div>

        <!-- Commercial Content Disclosure -->
        <div class="yoapsopo-field">
            <label class="yoapsopo-label"><?php esc_html_e('Commercial Content', 'yoapy-social-poster'); ?></label>
            <div style="margin-bottom: 10px;">
                <label style="display: flex; align-items: center; cursor: pointer;">
                    <div class="yoapsopo-track"
                        style="background-color: <?php echo esc_attr($tiktok_commercial_toggle === '1' ? '#3b82f6' : '#e5e7eb'); ?>;">
                        <div class="yoapsopo-thumb"
                            style="transform: <?php echo esc_attr($tiktok_commercial_toggle === '1' ? 'translateX(1.25rem)' : 'translateX(0)'); ?>;">
                        </div>
                    </div>
                    <span
                        style="margin-left: 10px;"><?php esc_html_e('This content promotes a brand or product', 'yoapy-social-poster'); ?></span>
                    <input type="checkbox" name="yoapsopo_tiktok_commercial_toggle" value="1"
                        id="yoapsopo_tiktok_commercial_toggle" style="display: none;" <?php checked('1', $tiktok_commercial_toggle); ?>>
                </label>
            </div>

            <div id="yoapsopo_tiktok_commercial_options"
                style="display: <?php echo esc_attr($tiktok_commercial_toggle === '1' ? 'block' : 'none'); ?>; padding: 12px; background: #fff; border-radius: 6px; border: 1px solid #e5e7eb;">
                <div style="margin-bottom: 10px;">
                    <label style="display: flex; align-items: center; margin-bottom: 8px;">
                        <input type="checkbox" name="yoapsopo_tiktok_commercial_your_brand" value="1"
                            id="yoapsopo_tiktok_commercial_your_brand" <?php checked('1', $tiktok_commercial_your_brand); ?>>
                        <span
                            style="margin-left: 8px;"><?php esc_html_e('Your Brand (Promoting yourself or your own business)', 'yoapy-social-poster'); ?></span>
                    </label>
                    <p style="margin: 4px 0 0 24px; font-size: 12px; color: #6b7280;">
                        <?php esc_html_e('Your photo/video will be labeled as "Promotional content"', 'yoapy-social-poster'); ?>
                    </p>
                </div>

                <div>
                    <label style="display: flex; align-items: center; margin-bottom: 8px;">
                        <input type="checkbox" name="yoapsopo_tiktok_commercial_branded" value="1"
                            id="yoapsopo_tiktok_commercial_branded" <?php checked('1', $tiktok_commercial_branded); ?>>
                        <span
                            style="margin-left: 8px;"><?php esc_html_e('Branded Content (Promoting another brand or third party)', 'yoapy-social-poster'); ?></span>
                    </label>
                    <p style="margin: 4px 0 0 24px; font-size: 12px; color: #6b7280;">
                        <?php esc_html_e('Your photo/video will be labeled as "Paid partnership"', 'yoapy-social-poster'); ?>
                    </p>
                </div>

                <p style="margin-top: 10px; font-size: 12px; color: #6b7280;">
                    <?php esc_html_e('You need to indicate if your content promotes yourself, a third party, or both.', 'yoapy-social-poster'); ?>
                </p>
            </div>
        </div>

        <!-- User Consent Declaration -->
        <div class="yoapsopo-field">
            <label style="display: flex; align-items: flex-start;">
                <input type="checkbox" name="yoapsopo_tiktok_consent" value="1" id="yoapsopo_tiktok_consent" <?php checked('1', $tiktok_consent); ?> required>
                <span style="margin-left: 8px;">
                    <span id="yoapsopo_tiktok_consent_text">
                        <?php
                        if ($tiktok_commercial_branded === '1') {
                            esc_html_e('By posting, you agree to TikTok\'s Branded Content Policy and Music Usage Confirmation', 'yoapy-social-poster');
                        } else {
                            esc_html_e('By posting, you agree to TikTok\'s Music Usage Confirmation', 'yoapy-social-poster');
                        }
                        ?>
                    </span>
                </span>
            </label>
        </div>
    </div>

    <!-- Hidden element to store TikTok account info -->
    <div id="yoapsopo_prev_meta" data-tiktok="<?php echo esc_attr($accounts['tiktok']); ?>"
        data-default="<?php echo esc_attr($accounts['tiktok']); ?>" style="display: none;">
    </div>
</div>

<script>
    document.addEventListener('DOMContentLoaded', function () {
        // Handle post type change to show/hide video field
        const typeSelect = document.getElementById('yoapsopo_type');
        const videoField = document.getElementById('yoapsopo_video_field');
        const videoRequired = document.getElementById('yoapsopo_video_required');

        // Network specific elements
        const networksCheckboxes = document.querySelectorAll('input[name="yoapsopo_networks[]"]');
        const accountSections = {
            'facebook': document.getElementById('yoapsopo_facebook_account_section'),
            'instagram': document.getElementById('yoapsopo_instagram_account_section'),
            'youtube': document.getElementById('yoapsopo_youtube_account_section'),
            'tiktok': document.getElementById('yoapsopo_tiktok_account_section')
</div >