<?php if (!defined('ABSPATH')) {
    exit;
} ?>

<?php
// ---------- helpers locais ----------
function yoapsopo_try_json($raw)
{
    if (is_array($raw))
        return $raw;
    $j = json_decode(is_string($raw) ? $raw : '', true);
    return is_array($j) ? $j : null;
}
function yoapsopo_fmt_br($utcStr)
{
    // Convert "Y-m-d H:i:s" UTC to site timezone using WordPress date format
    try {
        $dt = DateTime::createFromFormat('Y-m-d H:i:s', $utcStr, new DateTimeZone('UTC'));
        if (!$dt)
            return esc_html($utcStr);
        $dt->setTimezone(wp_timezone());
        // Use WordPress date and time format settings
        $date_format = get_option('date_format');
        $time_format = get_option('time_format');
        return esc_html($dt->format($date_format . ' ' . $time_format));
    } catch (Exception $e) {
        return esc_html($utcStr);
    }
}
function yoapsopo_status_chip($status)
{
    $map = array('complete' => 'success', 'processing' => 'warn', 'scheduled' => 'info', 'pending' => 'muted', 'error' => 'error');
    $kind = $map[$status] ?? 'muted';
    $icon = array(
        'success' => '<span class="dashicons dashicons-yes-alt"></span>',
        'warn' => '<span class="dashicons dashicons-update"></span>',
        'info' => '<span class="dashicons dashicons-info"></span>',
        'muted' => '<span class="dashicons dashicons-minus"></span>',
        'error' => '<span class="dashicons dashicons-dismiss"></span>',
    )[$kind];
    return '<span class="yoapsopo-chip yoapsopo-chip--' . $kind . '">' . $icon . ' ' . esc_html($status) . '</span>';
}
function yoapsopo_net_svg($net)
{
    // Return empty string since we're removing SVG icons
    return '';
}
function yoapsopo_net_chip($net)
{
    $label = ucfirst($net);
    return '<span class="yoapsopo-net yoapsopo-net--' . $net . '"><span>' . $label . '</span></span>';
}
function yoapsopo_links_from_result($body)
{
    $links = array();
    $domain_map = array('facebook' => 'https://www.facebook.com', 'instagram' => 'https://www.instagram.com', 'youtube' => 'https://www.youtube.com', 'tiktok' => 'https://www.tiktok.com');
    if (isset($body['data']) && is_array($body['data'])) {
        foreach ($body['data'] as $net => $info) {
            if (is_array($info)) {
                $url = '';
                if (!empty($info['permalink']))
                    $url = $info['permalink'];
                elseif (!empty($info['url']))
                    $url = $info['url'];
                // Normalize relative permalinks
                if (!empty($url) && strpos($url, '/') === 0 && strpos($url, '//') !== 0) {
                    $base_net = strpos($net, ':') !== false ? explode(':', $net)[0] : $net;
                    $url = ($domain_map[$base_net] ?? 'https://www.facebook.com') . $url;
                }
                if (!empty($url))
                    $links[$net] = $url;
            }
        }
    }
    foreach (array('permalink', 'url') as $k) {
        if (!empty($body[$k]) && empty($links['post']))
            $links['post'] = $body[$k];
    }
    return $links;
}

// Pagination variables
$logs_per_page_options = array(10, 50, 100);
$logs_per_page = absint($_GET['per_page'] ?? 50);
if (!in_array($logs_per_page, $logs_per_page_options)) {
    $logs_per_page = 50;
}
$current_page = max(1, absint($_GET['paged'] ?? 1));
$offset = ($current_page - 1) * $logs_per_page;

// Get all log lines for pagination calculation
$all_log_lines = YOAPSOPO_Logger::get_lines(10000); // Get more logs for better pagination
$total_logs = count($all_log_lines);

// Filter and slice the logs for current page
$filtered_logs = array();
$shown = array('req_create_post_json', 'res_create_post_json', 'res_get_task_result', 'do_job_end', 'task_result_error', 'task_completed', 'task_failed', 'task_all_complete', 'task_has_errors', 'do_job_start', 'plugin_activated', 'plugin_deactivated', 'task_saved', 'task_deleted', 'task_processed');

foreach ($all_log_lines as $r) {
    $evt = $r['event'] ?? '';
    if (!in_array($evt, $shown, true))
        continue;
    $filtered_logs[] = $r;
}

// Reverse to show newest first and apply pagination
$filtered_logs = array_reverse($filtered_logs);
$total_filtered_logs = count($filtered_logs);
$total_pages = ceil($total_filtered_logs / $logs_per_page);
$paginated_logs = array_slice($filtered_logs, $offset, $logs_per_page);
?>

<div class="wrap">
    <!-- Enhanced header with gradient -->
    <div class="yoapsopo-logs-header" style="background:linear-gradient(135deg,#0ea5e9,#7c3aed);">
        <h1 class="!text-white !m-0 text-2xl font-semibold"><?php esc_html_e('YoApy Logs', 'yoapy-social-poster'); ?>
        </h1>
        <p class="opacity-90 mt-1">
            <?php esc_html_e('Send and API return events. Dates in your timezone using WordPress format.', 'yoapy-social-poster'); ?>
        </p>
    </div>

    <!-- Improved actions bar -->
    <div class="yoapsopo-logs-actions">
        <form method="post">
            <?php wp_nonce_field('yoapsopo_clear_logs'); ?>
            <input type="hidden" name="yoapsopo_clear_logs" value="1" />
            <button class="button" type="submit"><?php esc_html_e('Clear all', 'yoapy-social-poster'); ?></button>
        </form>
        <span
            class="yoapsopo-logs-tip"><?php
            /* translators: %s: the text "view details" wrapped in <em> tags. */
            printf(esc_html__('Tip: click %s to open the complete JSON.', 'yoapy-social-poster'), '<em>' . esc_html__('view details', 'yoapy-social-poster') . '</em>'); ?></span>
    </div>

    <!-- Per Page Selector -->
    <div class="yoapsopo-per-page">
        <label for="yoapsopo_logs_per_page"><?php esc_html_e('Logs per page:', 'yoapy-social-poster'); ?></label>
        <form method="get" id="yoapsopo-logs-per-page-form">
            <input type="hidden" name="page" value="yoapsopo_logs" />
            <select name="per_page" id="yoapsopo_logs_per_page" onchange="this.form.submit()">
                <?php foreach ($logs_per_page_options as $option): ?>
                    <option value="<?php echo esc_attr($option); ?>" <?php selected($logs_per_page, $option); ?>>
                        <?php echo esc_html($option); ?>
                    </option>
                <?php endforeach; ?>
            </select>
        </form>
    </div>

    <div class="overflow-x-auto">
        <?php
        // --- Process logs for current page ---
        $items = array();

        foreach ($paginated_logs as $r):
            $evt = $r['event'] ?? '';
            if (!in_array($evt, $shown, true))
                continue;

            $data = $r['data'] ?? array();
            $title = '';
            $summary = '';
            $details = '';

            if ($evt === 'req_create_post_json') {
                $title = __('Send', 'yoapy-social-poster') . ' → POST ' . esc_html($data['endpoint'] ?? '/v1/posts');
                $json = $data['json'] ?? yoapsopo_try_json($data['body_raw'] ?? '');
                $nets = (isset($json['account_ids']) && is_array($json['account_ids'])) ? $json['account_ids'] : array();
                $type = $json['post_type'] ?? '—';
                $text = isset($json['text']) ? wp_strip_all_tags($json['text']) : '';
                if (mb_strlen($text) > 140)
                    $text = mb_substr($text, 0, 140) . '…';
                $scheduled = !empty($json['scheduled_time']) ? '<span class="ml-2 text-slate-600">• ' . esc_html__('scheduled:', 'yoapy-social-poster') . ' ' . esc_html($json['scheduled_time']) . '</span>' : '';

                $netsHtml = '';
                foreach ($nets as $n)
                    $netsHtml .= yoapsopo_net_chip($n) . ' ';

                $summary = '<div class="flex flex-wrap items-center gap-2">' .
                    '<span class="inline-flex items-center rounded-full bg-slate-100 px-2.5 py-0.5 text-xs font-medium text-slate-700">' . $type . '</span>' .
                    $netsHtml . $scheduled .
                    '</div>' .
                    ($text ? '<div class="mt-2 text-sm text-slate-700">“' . esc_html($text) . '”</div>' : '');

                $details = '<pre class="text-xs leading-5 whitespace-pre-wrap break-words">' . esc_html(json_encode($json ?: $data, JSON_PRETTY_PRINT | JSON_UNESCAPED_SLASHES | JSON_UNESCAPED_UNICODE)) . '</pre>';
            }

            if ($evt === 'res_create_post_json') {
                $title = __('Send return', 'yoapy-social-poster');
                $body = yoapsopo_try_json($data['response_body'] ?? '');
                $code = intval($data['http_code'] ?? 0);
                $taskId = is_array($body) && !empty($body['task_id']) ? $body['task_id'] : '—';

                $summary = '<div class="flex flex-wrap items-center gap-2">' .
                    '<span class="inline-flex items-center rounded-full bg-slate-100 px-2.5 py-0.5 text-xs font-medium text-slate-700">HTTP ' . $code . '</span>' .
                    '<span class="inline-flex items-center rounded-full bg-slate-50 px-2.5 py-0.5 text-xs text-slate-500">task_id: ' . $taskId . '</span>' .
                    '</div>';

                $details = '<pre class="text-xs leading-5 whitespace-pre-wrap break-words">' . esc_html(json_encode($body ?: $data, JSON_PRETTY_PRINT | JSON_UNESCAPED_SLASHES | JSON_UNESCAPED_UNICODE)) . '</pre>';
            }

            if ($evt === 'res_get_task_result') {
                $title = __('Task status', 'yoapy-social-poster');
                $body = yoapsopo_try_json($data['response_body'] ?? '');
                $status = is_array($body) && !empty($body['status']) ? $body['status'] : '—';

                $summary = yoapsopo_status_chip($status);
                $links = yoapsopo_links_from_result($body);
                if ($links) {
                    $summary .= '<div class="mt-2 flex flex-wrap gap-2">';
                    foreach ($links as $net => $url) {
                        $summary .= '<a class="inline-flex items-center gap-2 rounded-md px-2.5 py-1 text-xs text-white no-underline yoapsopo-net yoapsopo-net--' . esc_attr($net) . '" target="_blank" rel="noopener" href="' . esc_url($url) . '">' . yoapsopo_net_svg($net) . ' <span>' . sprintf(
                            /* translators: %s: social network name (e.g., Facebook, Instagram, YouTube, TikTok). */
                            esc_html__('View on %s', 'yoapy-social-poster'),
                            esc_html($net)
                        ) . '</span></a> ';
                    }
                    $summary .= '</div>';
                }

                $details = '<pre class="text-xs leading-5 whitespace-pre-wrap break-words">' . esc_html(json_encode($body ?: $data, JSON_PRETTY_PRINT | JSON_UNESCAPED_SLASHES | JSON_UNESCAPED_UNICODE)) . '</pre>';
            }

            if ($evt === 'do_job_end') {
                $title = __('Job completion', 'yoapy-social-poster');
                $status = $data['status'] ?? '—';
                $summary = yoapsopo_status_chip($status);
                $details = '<pre class="text-xs leading-5 whitespace-pre-wrap break-words">' . esc_html(json_encode($data, JSON_PRETTY_PRINT | JSON_UNESCAPED_SLASHES | JSON_UNESCAPED_UNICODE)) . '</pre>';
            }

            $items[] = array(
                'idx' => intval($r['_i']),
                'when_br' => yoapsopo_fmt_br($r['t']),
                'title' => $title ?: $evt,
                'summary' => $summary,
                'details' => $details,
                'evt' => $evt,
            );
        endforeach;

        // allowed HTML para imprimir summary/details com ícones SVG
        $yoapsopo_allowed_html = array(
            'div' => array('class' => true),
            'span' => array('class' => true),
            'a' => array('class' => true, 'href' => true, 'target' => true, 'rel' => true),
            'pre' => array('class' => true),
            'code' => array('class' => true),
            'svg' => array(
                'viewBox' => true,
                'width' => true,
                'height' => true,
                'fill' => true,
                'xmlns' => true,
                'role' => true,
                'aria-hidden' => true,
                'focusable' => true
            ),
            'path' => array(
                'd' => true,
                'fill' => true,
                'stroke' => true,
                'stroke-width' => true,
                'stroke-linecap' => true,
                'stroke-linejoin' => true
            ),
        );
        ?>

        <!-- ===== MOBILE (cards) ===== -->
        <ul class="md:hidden space-y-4">
            <?php foreach ($items as $it): ?>
                <li class="yoapsopo-log-card">
                    <div class="yoapsopo-log-card-header">
                        <div>
                            <div class="yoapsopo-log-timestamp"><?php echo esc_html($it['when_br']); ?></div>
                            <div class="yoapsopo-log-title"><?php echo esc_html($it['title']); ?></div>
                        </div>
                        <form method="post">
                            <?php wp_nonce_field('yoapsopo_delete_log'); ?>
                            <input type="hidden" name="line" value="<?php echo esc_attr($it['idx']); ?>" />
                            <button class="yoapsopo-log-delete" name="yoapsopo_delete_log" value="1"
                                title="<?php esc_attr_e('Delete', 'yoapy-social-poster'); ?>">
                                <span class="dashicons dashicons-trash"></span>
                                <?php esc_html_e('Delete', 'yoapy-social-poster'); ?>
                            </button>
                        </form>
                    </div>

                    <div class="yoapsopo-log-summary">
                        <div class="yoapsopo-summary"><?php echo wp_kses($it['summary'], $yoapsopo_allowed_html); ?></div>
                    </div>

                    <button type="button" class="yoapsopo-log-toggle">
                        <span class="dashicons dashicons-visibility"></span>
                        <?php esc_html_e('View details', 'yoapy-social-poster'); ?>
                    </button>
                    <div class="yoapsopo-details hidden yoapsopo-log-details">
                        <?php echo wp_kses($it['details'], $yoapsopo_allowed_html); ?>
                    </div>
                </li>
            <?php endforeach; ?>
        </ul>

        <!-- ===== DESKTOP/TABLET (tabela) ===== -->
        <div class="hidden md:block">
            <table class="yoapsopo-logs-table">
                <thead>
                    <tr>
                        <th><?php esc_html_e('When (local)', 'yoapy-social-poster'); ?></th>
                        <th><?php esc_html_e('Action', 'yoapy-social-poster'); ?></th>
                        <th><?php esc_html_e('Summary', 'yoapy-social-poster'); ?></th>
                        <th><?php esc_html_e('Actions', 'yoapy-social-poster'); ?></th>
                    </tr>
                </thead>
                <tbody>
                    <?php foreach ($items as $it): ?>
                        <tr>
                            <td>
                                <div class="yoapsopo-log-timestamp"><?php echo esc_html($it['when_br']); ?></div>
                            </td>
                            <td>
                                <div class="yoapsopo-log-title"><?php echo esc_html($it['title']); ?></div>
                            </td>
                            <td>
                                <div class="yoapsopo-summary">
                                    <?php echo wp_kses($it['summary'], $yoapsopo_allowed_html); ?>
                                </div>
                                <button type="button" class="yoapsopo-log-toggle mt-3">
                                    <span class="dashicons dashicons-visibility"></span>
                                    <?php esc_html_e('View details', 'yoapy-social-poster'); ?>
                                </button>
                                <div class="yoapsopo-details hidden yoapsopo-log-details">
                                    <?php echo wp_kses($it['details'], $yoapsopo_allowed_html); ?>
                                </div>
                            </td>
                            <td>
                                <form method="post">
                                    <?php wp_nonce_field('yoapsopo_delete_log'); ?>
                                    <input type="hidden" name="line" value="<?php echo esc_attr($it['idx']); ?>" />
                                    <button class="yoapsopo-log-delete" name="yoapsopo_delete_log" value="1">
                                        <span class="dashicons dashicons-trash"></span>
                                        <?php esc_html_e('Delete', 'yoapy-social-poster'); ?>
                                    </button>
                                </form>
                            </td>
                        </tr>
                    <?php endforeach; ?>
                </tbody>
            </table>
        </div>

        <!-- Pagination -->
        <?php if ($total_pages > 1): ?>
            <div class="yoapsopo-pagination">
                <?php
                // Add per_page parameter to pagination links
                $page_links = paginate_links(array(
                    'base' => add_query_arg(array('paged' => '%#%', 'per_page' => $logs_per_page)),
                    'format' => '',
                    'prev_text' => '&laquo;',
                    'next_text' => '&raquo;',
                    'total' => $total_pages,
                    'current' => $current_page,
                    'type' => 'array',
                    'end_size' => 2,
                    'mid_size' => 2
                ));

                if (is_array($page_links)) {
                    foreach ($page_links as $link) {
                        echo wp_kses_post($link);
                    }
                }
                ?>
            </div>
        <?php endif; ?>
    </div>
</div>