<?php if ( ! defined( 'ABSPATH' ) ) { exit; }

// ===== Helpers & dados existentes =====================
if ( ! function_exists('yoapsopo_net_svg') ) {
  function yoapsopo_net_svg($net){
    // Return empty string since we're removing SVG icons
    return '';
  }
}

if ( ! function_exists('yoapsopo_net_chip') ) {
  function yoapsopo_net_chip($net){
    $map = array(
      'facebook'  => 'bg-[#1877F2]/10 text-[#1877F2] border-[#1877F2]/20',
      'instagram' => 'bg-gradient-to-r from-[#f58529]/10 via-[#dd2a7b]/10 to-[#515bd4]/10 text-[#af2a7b] border-pink-300/30',
      'youtube'   => 'bg-[#FF0000]/10 text-[#FF0000] border-[#FF0000]/20',
      'tiktok'    => 'bg-gradient-to-r from-[#69C9D0]/10 via-black/10 to-[#EE1D52]/10 text-[#111] border-slate-300/40',
    );
    $label = ucfirst($net);
    $cls = isset($map[$net]) ? $map[$net] : 'bg-slate-100 text-slate-700 border-slate-200';
    return '<span class="inline-flex items-center gap-1 rounded-full border px-2.5 py-1 text-xs font-medium '.$cls.'"><span>'.$label.'</span></span>';
  }
}

if ( ! function_exists('yoapsopo_status_badge') ) {
  function yoapsopo_status_badge($status){
    $s = strtolower((string)$status);
    $map = array(
      'complete'   => 'bg-emerald-50 text-emerald-700 ring-emerald-200',
      'processing' => 'bg-amber-50 text-amber-700 ring-amber-200',
      'scheduled'  => 'bg-sky-50 text-sky-700 ring-sky-200',
      'error'      => 'bg-rose-50 text-rose-700 ring-rose-200',
      'pending'    => 'bg-slate-50 text-slate-700 ring-slate-200',
    );
    $cls = $map[$s] ?? $map['pending'];
    return '<span class="inline-flex items-center rounded-full px-2.5 py-1 text-xs font-semibold ring-1 '.$cls.'">'.esc_html($status ?: '—').'</span>';
  }
}
