document.addEventListener('DOMContentLoaded', function () {
    // Handle network selection to show/hide TikTok fields
    const networkCheckboxes = document.querySelectorAll('input[name="networks[]"]');
    const tiktokFields = document.getElementById('yoapsopo_tiktok_fields');

    if (networkCheckboxes.length && tiktokFields) {
        function toggleTiktokFields() {
            let tiktokSelected = false;
            networkCheckboxes.forEach(checkbox => {
                if (checkbox.value === 'tiktok' && checkbox.checked) {
                    tiktokSelected = true;
                }
            });

            tiktokFields.style.display = tiktokSelected ? 'block' : 'none';
        }

        // Add event listeners to all network checkboxes
        networkCheckboxes.forEach(checkbox => {
            checkbox.addEventListener('change', toggleTiktokFields);
        });

        // Initial check
        toggleTiktokFields();
    }

    // Handle commercial content toggle
    const commercialToggle = document.getElementById('yoapsopo_tiktok_commercial_toggle');
    const commercialOptions = document.getElementById('yoapsopo_tiktok_commercial_options');
    const commercialYourBrand = document.getElementById('yoapsopo_tiktok_commercial_your_brand');
    const commercialBranded = document.getElementById('yoapsopo_tiktok_commercial_branded');
    const privacySelect = document.getElementById('yoapsopo_tiktok_privacy');
    const consentText = document.getElementById('yoapsopo_tiktok_consent_text');
    const consentCheckbox = document.getElementById('yoapsopo_tiktok_consent');

    // Track elements for commercial toggle
    const commercialTrack = commercialToggle ? commercialToggle.previousElementSibling : null;
    const commercialThumb = commercialTrack ? commercialTrack.querySelector('.yoapsopo-thumb') : null;

    if (commercialToggle && commercialTrack && commercialThumb) {
        commercialToggle.addEventListener('change', function () {
            if (this.checked) {
                commercialOptions.style.display = 'block';
                commercialTrack.style.backgroundColor = '#3b82f6';
                commercialThumb.style.transform = 'translateX(1.25rem)';
            } else {
                commercialOptions.style.display = 'none';
                commercialTrack.style.backgroundColor = '#e5e7eb';
                commercialThumb.style.transform = 'translateX(0)';
                if (commercialYourBrand) commercialYourBrand.checked = false;
                if (commercialBranded) commercialBranded.checked = false;
            }
        });
    }

    // Handle commercial content options
    if (commercialYourBrand && commercialBranded && consentText) {
        function updateConsentText() {
            const yourBrandChecked = commercialYourBrand && commercialYourBrand.checked;
            const brandedChecked = commercialBranded && commercialBranded.checked;

            // Use localized strings if available, else fallback
            const s_music = YOAPSOPO.i18n.tiktokMusicShort || "By posting, you agree to TikTok's Music Usage Confirmation";
            const s_branded = YOAPSOPO.i18n.tiktokBrandedShort || "By posting, you agree to TikTok's Branded Content Policy and Music Usage Confirmation";

            if (yourBrandChecked && !brandedChecked) {
                consentText.textContent = s_music;
            } else if (!yourBrandChecked && brandedChecked) {
                consentText.textContent = s_branded;
            } else if (yourBrandChecked && brandedChecked) {
                consentText.textContent = s_branded;
            } else {
                consentText.textContent = s_music;
            }
        }

        commercialYourBrand.addEventListener('change', updateConsentText);
        commercialBranded.addEventListener('change', updateConsentText);

        // Initial update
        updateConsentText();
    }

    // Handle privacy settings for branded content
    if (privacySelect && commercialBranded) {
        commercialBranded.addEventListener('change', function () {
            if (this.checked) {
                // If branded content is selected, show a warning if privacy is not public
                const currentPrivacy = privacySelect.value;
                if (currentPrivacy && currentPrivacy !== 'PUBLIC_TO_EVERYONE') {
                    const msg = YOAPSOPO.i18n.tiktokBrandedPrivacyWarning || 'Branded content visibility cannot be set to private. Privacy setting will be automatically changed to "Everyone".';
                    alert(msg);
                    privacySelect.value = 'PUBLIC_TO_EVERYONE';
                }
            }
        });

        privacySelect.addEventListener('change', function () {
            const brandedChecked = commercialBranded.checked;
            if (brandedChecked && this.value !== 'PUBLIC_TO_EVERYONE') {
                const msg = YOAPSOPO.i18n.tiktokBrandedPrivacyError || 'Branded content visibility cannot be set to private. Please select "Everyone" for branded content.';
                alert(msg);
                this.value = 'PUBLIC_TO_EVERYONE';
            }
        });
    }

    // Form submission validation
    const taskForm = document.getElementById('yoapsopo_form_task');
    if (taskForm) {
        taskForm.addEventListener('submit', function (e) {
            // Check if TikTok is selected
            let tiktokSelected = false;
            // Re-query checkboxes as they might have been dynamically updated or just to be safe
            const networks = document.querySelectorAll('input[name="networks[]"]');
            networks.forEach(checkbox => {
                if (checkbox.value === 'tiktok' && checkbox.checked) {
                    tiktokSelected = true;
                }
            });

            if (tiktokSelected) {
                // Validate privacy status
                const privacy = document.getElementById('yoapsopo_tiktok_privacy');
                if (privacy && !privacy.value) {
                    alert(YOAPSOPO.i18n.tiktokPrivacyRequired || 'Please select a privacy status for your TikTok post.');
                    e.preventDefault();
                    return false;
                }

                // Validate commercial content if toggle is on
                const commToggle = document.getElementById('yoapsopo_tiktok_commercial_toggle');
                const commYour = document.getElementById('yoapsopo_tiktok_commercial_your_brand');
                const commBrand = document.getElementById('yoapsopo_tiktok_commercial_branded');

                if (commToggle && commToggle.checked) {
                    if ((commYour && !commYour.checked) && (commBrand && !commBrand.checked)) {
                        alert(YOAPSOPO.i18n.tiktokCommercialRequired || 'You need to indicate if your content promotes yourself, a third party, or both.');
                        e.preventDefault();
                        return false;
                    }
                }

                // Validate consent
                const consent = document.getElementById('yoapsopo_tiktok_consent');
                if (consent && !consent.checked) {
                    alert(YOAPSOPO.i18n.tiktokConsentRequired || "You must agree to TikTok's terms before posting.");
                    e.preventDefault();
                    return false;
                }
            }
        });
    }
});
