/**
 * YoApy Planner - UI
 * General UI interactions (modals, toggles).
 */
(function ($) {
    'use strict';

    $(document).ready(function () {
        // REMOVED: Modal HTML and handlers to avoid conflicts with planner-modal.js
        // All modal functionality is now handled by planner-modal.js
    });

    // Ensure YoApyPlanner namespace exists
    if (typeof window.YoApyPlanner === 'undefined') {
        window.YoApyPlanner = {};
    }

    /**
     * Generic Modal
     */
    YoApyPlanner.modal = function (title, message, type = 'info') {        // Remove existing generic modal if any
        $('#yoapsopo-generic-modal').remove();

        const isError = type === 'error';
        const iconClass = isError ? 'dashicons-warning' : 'dashicons-info';
        const iconColor = isError ? 'text-red-500' : 'text-blue-500';
        const btnClass = isError ? 'bg-red-500 hover:bg-red-600' : 'bg-blue-500 hover:bg-blue-600';
        const titleColor = isError ? 'text-red-600' : 'text-slate-800';

        const modalHTML = `
            <div id="yoapsopo-generic-modal" class="yoapsopo-modal-overlay active flex items-center justify-center fixed inset-0 z-[100000] bg-slate-900/50 backdrop-blur-sm transition-opacity opacity-0" style="opacity: 0; transition: opacity 0.2s ease-out;">
                <div class="yoapsopo-modal bg-white rounded-2xl shadow-2xl w-full max-w-md mx-4 transform scale-95 transition-transform duration-200" style="transform: scale(0.95);">
                    <div class="p-6">
                        <div class="flex items-start gap-4">
                            <div class="flex-shrink-0 w-12 h-12 rounded-full ${isError ? 'bg-red-100' : 'bg-blue-100'} flex items-center justify-center">
                                <span class="dashicons ${iconClass} ${iconColor} text-2xl" style="font-size: 24px; width: 24px; height: 24px;"></span>
                            </div>
                            <div class="flex-1">
                                <h3 class="text-lg font-semibold ${titleColor} mb-2">${title}</h3>
                                <p class="text-slate-600 text-sm leading-relaxed">${message}</p>
                            </div>
                        </div>
                    </div>
                    <div class="bg-slate-50 px-6 py-4 rounded-b-2xl flex justify-end">
                        <button class="yoapsopo-modal-close px-5 py-2.5 rounded-lg text-white font-medium text-sm shadow-sm transition-colors ${btnClass}">
                            ${isError ? 'Fix Issue' : 'OK'}
                        </button>
                    </div>
                </div>
            </div>
        `;

        const $modal = $(modalHTML);
        $('body').append($modal);

        // Animate in
        requestAnimationFrame(() => {
            $modal.css('opacity', '1');
            $modal.find('.yoapsopo-modal').css('transform', 'scale(1)');
        });

        // Close handler with animation
        $modal.on('click', '.yoapsopo-modal-close', function () {
            $modal.css('opacity', '0');
            $modal.find('.yoapsopo-modal').css('transform', 'scale(0.95)');
            setTimeout(() => {
                $modal.remove();
            }, 200);
        });
    };

    // Toggle details
    document.addEventListener('click', function (e) {
        const btn = e.target.closest('.yoapsopo-toggle, .yoapsopo-log-toggle');
        if (!btn) return;

        e.preventDefault();

        const details = btn.nextElementSibling && btn.nextElementSibling.classList.contains('yoapsopo-details')
            ? btn.nextElementSibling
            : btn.parentElement.querySelector('.yoapsopo-details');

        if (!details) return;

        details.style.display = '';
        const isHidden = details.classList.contains('hidden');
        details.classList.toggle('hidden', !isHidden);

        if (btn.classList.contains('yoapsopo-log-toggle')) {
            btn.innerHTML = isHidden
                ? '<span class="dashicons dashicons-hidden"></span> Hide details'
                : '<span class="dashicons dashicons-visibility"></span> View details';
        } else {
            btn.innerHTML = isHidden
                ? '<span class="dashicons dashicons-hidden"></span> hide details'
                : '<span class="dashicons dashicons-visibility"></span> view details';
        }
    });

})(jQuery);
