<?php

/**
 * Plugin Name: YeeDiscounts - Dynamic Discounts for WooCommerce
 * Requires Plugins: woocommerce
 * Description: Easily create and manage dynamic pricing and discount rules for your WooCommerce store.
 * Version: 1.0.3
 * Author: add-ons.org
 * Author URI: https://add-ons.org
 * Tested up to: 6.9
 * WC requires at least: 4.0
 * WC tested up to: 10.5
 * License: GPL v2 or later
 * License URI: https://www.gnu.org/licenses/gpl-2.0.html
 */
if (! defined('ABSPATH')) exit; // Exit if accessed directly
define('YEEKIT_DYNAMIC_DISCOUNTS_WOOCOMMERCE_URL', plugin_dir_url(__FILE__));
define('YEEKIT_DYNAMIC_DISCOUNTS_WOOCOMMERCE_PATH', plugin_dir_path(__FILE__));
define('YEEKIT_DYNAMIC_DISCOUNTS_VERSION', time());
class Yeekit_Dynamic_Discounts_Woocommerce_Builder
{
    function __construct()
    {
        include YEEKIT_DYNAMIC_DISCOUNTS_WOOCOMMERCE_PATH . "backend/table.php";
        include YEEKIT_DYNAMIC_DISCOUNTS_WOOCOMMERCE_PATH . "backend/rules.php";
        include YEEKIT_DYNAMIC_DISCOUNTS_WOOCOMMERCE_PATH . "backend/settings.php";
        include YEEKIT_DYNAMIC_DISCOUNTS_WOOCOMMERCE_PATH . "backend/reports.php";
        include YEEKIT_DYNAMIC_DISCOUNTS_WOOCOMMERCE_PATH . "backend/orders.php";
        include YEEKIT_DYNAMIC_DISCOUNTS_WOOCOMMERCE_PATH . "frontend/discounts.php";
        include YEEKIT_DYNAMIC_DISCOUNTS_WOOCOMMERCE_PATH . "frontend/discount_bar.php";
        include YEEKIT_DYNAMIC_DISCOUNTS_WOOCOMMERCE_PATH . "frontend/bulk_table.php";
        include YEEKIT_DYNAMIC_DISCOUNTS_WOOCOMMERCE_PATH . "frontend/set_table.php";
        include YEEKIT_DYNAMIC_DISCOUNTS_WOOCOMMERCE_PATH . "frontend/bxgy_table.php";
        include YEEKIT_DYNAMIC_DISCOUNTS_WOOCOMMERCE_PATH . "frontend/sale_badge.php";
        include YEEKIT_DYNAMIC_DISCOUNTS_WOOCOMMERCE_PATH . "frontend/price_display.php";
        // Initialize Reports class to register AJAX hooks
        new Yeekit_Dynamic_Discounts_Reports();
        add_action('before_woocommerce_init', array($this, 'before_woocommerce_init'));
        add_filter('plugin_action_links_' . plugin_basename(__FILE__), array($this, 'add_link'));
    }
    function before_woocommerce_init()
    {
        if (class_exists(\Automattic\WooCommerce\Utilities\FeaturesUtil::class)) {
            \Automattic\WooCommerce\Utilities\FeaturesUtil::declare_compatibility(
                'custom_order_tables',
                __FILE__,
                true
            );
        }
    }
    function add_link($actions)
    {
        $actions[] = '<a href="' . esc_url(get_admin_url(null, 'admin.php?page=wc-settings&tab=yeekit_dynamic_discounts')) . '">' . esc_html__("Settings", 'yeediscounts') . '</a>';
        $actions[] = '<a href="' . esc_url('https://yeeplugin.github.io/YeeDiscounts/index.html') . '" target="_blank">' . esc_html__("Documentation", 'yeediscounts') . '</a>';
        return $actions;
    }
}
new Yeekit_Dynamic_Discounts_Woocommerce_Builder;
