<?php
if (! defined('ABSPATH')) exit;
if (! class_exists('WP_List_Table')) {
    require_once ABSPATH . 'wp-admin/includes/class-wp-list-table.php';
}
class Yeekit_Dynamic_Discounts_Rules_Table extends WP_List_Table
{
    public function get_columns()
    {
        return [
            'cb'     => '<input type="checkbox" />',
            'title'  => __('Rule name', 'yeediscounts'),
            'description' => __('Description', 'yeediscounts'),
            'apply'  => __('Apply', 'yeediscounts'),
            'value'  => __('Discount', 'yeediscounts'),
            'status' => __('Status', 'yeediscounts'),
        ];
    }
    protected function column_cb($item)
    {
        return sprintf(
            '<input type="checkbox" name="rule_ids[]" value="%d" />',
            esc_attr($item['_id'])
        );
    }
    protected function column_title($item)
    {
        $edit_url = add_query_arg([
            'tab'     => 'yeekit_dynamic_discounts',
            'section' => 'rules',
            'action'  => 'edit',
            'rule_id' => $item['_id'],
        ], admin_url('admin.php?page=wc-settings'));

        $delete_url = wp_nonce_url(add_query_arg([
            'tab'     => 'yeekit_dynamic_discounts',
            'section' => 'rules',
            'action'  => 'delete',
            'rule_id' => $item['_id'],
        ], admin_url('admin.php?page=wc-settings')), 'yeekit_delete_rule_' . $item['_id']);

        $actions = [
            'edit' => '<a href="' . esc_url($edit_url) . '">' .
                esc_html__('Edit', 'yeediscounts') . '</a>',
            'delete' => '<a href="' . esc_url($delete_url) . '" class="yeekit-dd-delete" onclick="return confirm(\'' . esc_js(__('Are you sure?', 'yeediscounts')) . '\');">' .
                esc_html__('Delete', 'yeediscounts') . '</a>',
        ];

        return sprintf(
            '<strong>%1$s</strong> %2$s',
            esc_html($item['title'] ?? ''),
            $this->row_actions($actions)
        );
    }
    protected function column_description($item)
    {
        return esc_html($item['description'] ?? '');
    }

    protected function column_apply($item)
    {
        $type = $item['type'] ?? '';
        $types = [
            'yeekit_simple_discount' => __('Simple Discount', 'yeediscounts'),
            'yeekit_cart_discount'   => __('Cart Discount', 'yeediscounts'),
            'yeekit_bulk_discount'   => __('Bulk Discount', 'yeediscounts'),
            'yeekit_set_discount'    => __('Set Discount', 'yeediscounts'),
            'yeekit_buy_x_get_x'     => __('BOGO (Buy X Get X)', 'yeediscounts'),
            'yeekit_buy_x_get_y'     => __('Buy X Get Y', 'yeediscounts'),
            'yeekit_free_shipping'   => __('Free Shipping', 'yeediscounts'),
        ];
        return isset($types[$type]) ? esc_html($types[$type]) : esc_html($type);
    }

    protected function column_value($item)
    {
        if (empty($item['discount'])) {
            // For some types like BOGO/Set, discount info might be in tiers/adjustments
            // We can improve this display later if needed
            return '—';
        }

        $type  = $item['discount']['type'] ?? '';
        $value = $item['discount']['value'] ?? '';

        if ($type === 'percentage') {
            return esc_html($value . '%');
        }

        if ($type === 'fixed') {
            return wp_kses_post(wc_price($value));
        }

        return esc_html($value);
    }

    protected function column_status($item)
    {
        return ! empty($item['enabled'])
            ? '<span style="color:green;font-weight:600;">Enabled</span>'
            : '<span style="color:#999;">Disabled</span>';
    }
    protected function column_default($item, $column_name)
    {
        return esc_html($item[$column_name] ?? '');
    }
    public function prepare_items()
    {
        $rules = Yeekit_Dynamic_Discounts_Rules_Manager::get_rules();

        $items = [];
        foreach ($rules as $index => $rule) {
            $rule['_id'] = $index; // internal table ID
            $items[] = $rule;
        }

        $this->items = $items;
        $this->_column_headers = [$this->get_columns(), [], []];
    }
}
