<?php
if (! defined('ABSPATH')) exit;

class Yeekit_Dynamic_Discounts_Order_Tracker
{
    public function __construct()
    {
        // Save Rule ID to Order Items (Product Line Items)
        add_action('woocommerce_checkout_create_order_line_item', [$this, 'save_line_item_meta'], 10, 4);

        // Save Rule ID to Fees (Cart Discount)
        add_action('woocommerce_checkout_create_order_fee_item', [$this, 'save_fee_item_meta'], 10, 4);
        add_action('woocommerce_order_status_completed', [$this, "woocommerce_order_status_completed"]);
    }
    function woocommerce_order_status_completed($order_id)
    {
        global $wpdb;
        $wpdb->query("DELETE FROM {$wpdb->options} WHERE option_name LIKE '_transient_yeekit_report_%'");
    }
    /**
     * Save metadata to product line items in the order
     */
    public function save_line_item_meta($item, $cart_item_key, $values, $order)
    {
        if (!empty($values['_yeekit_free_item'])) {
            $meta = $values['_yeekit_free_item'];

            // Save Rule ID (use isset instead of !empty to allow 0)
            if (isset($meta['rule_id'])) {
                $item->add_meta_data('_yeekit_rule_id', $meta['rule_id']);
            }

            // Save Discount Type and Value

            if (isset($meta['type'])) {
                $item->add_meta_data('_yeekit_discount_type', $meta['type']);
            }
            if (isset($meta['value'])) {
                $item->add_meta_data('_yeekit_discount_value', $meta['value']); // Rate (10%, $5)
            }

            // Save Price Information
            if (isset($meta['original_price'])) {
                $item->add_meta_data('_yeekit_original_price', $meta['original_price']);
            }
            if (isset($meta['discount_amount'])) {
                $item->add_meta_data('_yeekit_discount_amount', $meta['discount_amount']); // Actual $ saved
            }
            if (isset($meta['final_price'])) {
                $item->add_meta_data('_yeekit_final_price', $meta['final_price']);
            }
        }
    }

    /**
     * Save metadata to fee items (Cart Discounts)
     */
    public function save_fee_item_meta($item, $fee_key, $fee, $order)
    {
        // Challenges: WC Fees don't easily link back to a "rule" unless we stored it in the cart fee object somehow.
        // However, we only apply fees if a Cart Discount Rule matches.
        // In cart_discount.php, we utilize add_fee(). checking if we can attach data there.
        // WC_Cart::add_fee doesn't support custom data directly passed to order.
        // So we might need to rely on the tracking of the matched rule during checkout.

        // For now, let's try to match the fee name OR check the currently matched rule if it's a Cart Discount.
        // Since checkout flow re-evaluates rules, get_matched_rule() should give us the active rule.

        $rule = Yeekit_Dynamic_Discounts_Rules_Manager::get_matched_rule();
        if ($rule && $rule['type'] === 'yeekit_cart_discount') {
            // We assume this fee belongs to this rule. 
            // To be safer, we could check if fee name matches rule title, but let's assume single rule application for now.
            $item->add_meta_data('_yeekit_rule_id', $rule['id']);
        }
    }
}
new Yeekit_Dynamic_Discounts_Order_Tracker();
