<?php
if (! defined('ABSPATH')) exit;
class Yeekit_Dynamic_Discounts_Import_Export
{
    public function __construct()
    {
        add_action('admin_init', [$this, 'handle_export']);
        add_action('admin_init', [$this, 'handle_import']);
    }
    public function handle_export()
    {
        if (
            isset($_POST['yeekit_action']) &&
            $_POST['yeekit_action'] === 'export_rules' &&
            check_admin_referer('yeekit_dd_export', 'yeekit_dd_export_nonce')
        ) {
            if (! current_user_can('manage_woocommerce')) {
                return;
            }
            $rules = Yeekit_Dynamic_Discounts_Rules_Manager::get_rules();
            $data = wp_json_encode($rules, JSON_PRETTY_PRINT);
            $filename = 'rules-export-' . current_time('Y-m-d-H-i-s') . '.json';
            header('Content-Description: File Transfer');
            header('Content-Type: application/json; charset=utf-8');
            header('Content-Disposition: attachment; filename="' . $filename . '"');
            header('Expires: 0');
            header('Cache-Control: must-revalidate');
            header('Pragma: public');
            header('Content-Length: ' . strlen($data));
            echo $data; // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped
            exit;
        }
    }
    public function handle_import()
    {
        if (
            isset($_POST['yeekit_action']) &&
            $_POST['yeekit_action'] === 'import_rules' &&
            check_admin_referer('yeekit_dd_import', 'yeekit_dd_import_nonce')
        ) {
            if (! current_user_can('manage_woocommerce')) {
                return;
            }
            // phpcs:ignore WordPress.Security.ValidatedSanitizedInput.InputNotValidated -- Validation happens below.
            if (!empty($_FILES['import_file']['tmp_name'])) {
                // Validate upload error.
                // phpcs:ignore WordPress.Security.ValidatedSanitizedInput.InputNotValidated
                if (isset($_FILES['import_file']['error']) && $_FILES['import_file']['error'] !== UPLOAD_ERR_OK) {
                    add_settings_error(
                        'yeekit_dd_messages',
                        'yeekit_dd_upload_error',
                        __('File upload error. Please try again.', 'yeediscounts'),
                        'error'
                    );
                    return;
                }

                // Validate file size (max 5MB).
                // phpcs:ignore WordPress.Security.ValidatedSanitizedInput.InputNotValidated
                $file_size = isset($_FILES['import_file']['size']) ? intval($_FILES['import_file']['size']) : 0;
                $max_size = 5 * 1024 * 1024; // 5MB
                if ($file_size > $max_size) {
                    add_settings_error(
                        'yeekit_dd_messages',
                        'yeekit_dd_file_too_large',
                        __('File is too large. Maximum size is 5MB.', 'yeediscounts'),
                        'error'
                    );
                    return;
                }

                // Validate file extension.
                // phpcs:ignore WordPress.Security.ValidatedSanitizedInput.InputNotValidated
                $file_name = isset($_FILES['import_file']['name']) ? sanitize_file_name(wp_unslash($_FILES['import_file']['name'])) : '';
                $file_ext = strtolower(pathinfo($file_name, PATHINFO_EXTENSION));
                if ($file_ext !== 'json') {
                    add_settings_error(
                        'yeekit_dd_messages',
                        'yeekit_dd_invalid_file_type',
                        __('Invalid file type. Only .json files are allowed.', 'yeediscounts'),
                        'error'
                    );
                    return;
                }

                // Use WP_Filesystem for secure file reading.
                global $wp_filesystem;
                if (empty($wp_filesystem)) {
                    require_once ABSPATH . '/wp-admin/includes/file.php';
                    WP_Filesystem();
                }


                $content = $wp_filesystem->get_contents($_FILES['import_file']['tmp_name']); //phpcs:ignore WordPress.Security.ValidatedSanitizedInput.InputNotSanitized -- tmp_name is validated above and used only for reading.

                if (false === $content) {
                    add_settings_error(
                        'yeekit_dd_messages',
                        'yeekit_dd_read_error',
                        __('Failed to read file contents.', 'yeediscounts'),
                        'error'
                    );
                    return;
                }

                $new_rules = json_decode($content, true);
                if (is_array($new_rules)) {
                    $existing_rules = Yeekit_Dynamic_Discounts_Rules_Manager::get_rules();
                    // Simple logic: Append new rules
                    // Reset keys to ensure continuous indexing
                    $merged_rules = array_merge(array_values($existing_rules), array_values($new_rules));
                    Yeekit_Dynamic_Discounts_Rules_Manager::save_rules($merged_rules);
                    add_settings_error(
                        'yeekit_dd_messages',
                        'yeekit_dd_import_success',
                        __('Rules imported successfully!', 'yeediscounts'),
                        'success'
                    );
                } else {
                    add_settings_error(
                        'yeekit_dd_messages',
                        'yeekit_dd_import_error',
                        __('Invalid JSON file.', 'yeediscounts'),
                        'error'
                    );
                }
            }
        }
    }
}
new Yeekit_Dynamic_Discounts_Import_Export();
