<?php
if (! defined('ABSPATH')) {
    exit;
}

/**
 * Render Bundle (Set) Discount Block
 *
 * @param array $rule The discount rule data.
 */
function yeekit_render_set_discount_block($rule)
{
?>
    <div class="yeekit-dd-block yeekit-set-discount-block" style="display:none;">
        <h3 class="yeekit-dd-block-title"><?php esc_html_e('Bundle (Set) Discount Rates', 'yeediscounts'); ?></h3>
        <div class="yeekit-dd-block-content">
            <p class="description yeekit-block-desc">
                <?php esc_html_e(
                    'Apply a discount when a set of products is purchased (e.g. 5 items for $100).',
                    'yeediscounts'
                ); ?>
            </p>
            <p class="form-field">
                <label for="yeekit-set-count-mode"><?php esc_html_e('Count Quantities by:', 'yeediscounts'); ?></label>
                <select name="rule[set_adjustments][operator]" id="yeekit-set-count-mode" class="wdr-set-type set_discount_select awdr_mode_of_operator" style="width:100%; max-width:400px;">
                    <option value="product_cumulative" title="<?php esc_attr_e('This will count the quantities of products set in the "Filter" section.', 'yeediscounts'); ?>" <?php selected(($rule['set_adjustments']['operator'] ?? ''), 'product_cumulative'); ?>>
                        <?php esc_html_e('Filters set above', 'yeediscounts'); ?>
                    </option>
                    <option value="product" title="<?php esc_attr_e('This counts the total quantity of each product / line item separately.', 'yeediscounts'); ?>" <?php selected(($rule['set_adjustments']['operator'] ?? ''), 'product'); ?>>
                        <?php esc_html_e('Individual product', 'yeediscounts'); ?>
                    </option>
                    <option value="variation" title="<?php esc_attr_e('Useful when applying discounts based on variable products.', 'yeediscounts'); ?>" <?php selected(($rule['set_adjustments']['operator'] ?? ''), 'variation'); ?>>
                        <?php esc_html_e('All variants in each product together', 'yeediscounts'); ?>
                    </option>
                </select>
            </p>
            <div class="yeekit-tiers-list yeekit-set-list" id="yeekit-set-tiers-container">
                <?php
                $set_ranges = $rule['set_adjustments']['ranges'] ?? [];
                if (empty($set_ranges)) {
                    $set_ranges[] = ['qty' => 1, 'type' => 'fixed_set_price', 'value' => 0, 'label' => '', 'is_recursive' => 0];
                }
                foreach ($set_ranges as $i => $range):
                ?>
                    <div class="yeekit-tier-row yeekit-set-tier-row">
                        <div class="tier-content">
                            <div class="tier-line-1">
                                <div class="yeekit-form-group">
                                    <label class="yeekit-set-qty-header"><?php esc_html_e('Minimum Quantity', 'yeediscounts'); ?></label>
                                    <input type="number" name="rule[set_adjustments][ranges][<?php echo esc_attr($i); ?>][qty]" value="<?php echo esc_attr($range['qty']); ?>" min="1" step="1">
                                </div>
                                <div class="yeekit-form-group">
                                    <label><?php esc_html_e('Discount Type', 'yeediscounts'); ?></label>
                                    <select name="rule[set_adjustments][ranges][<?php echo esc_attr($i); ?>][type]" class="set-discount-type">
                                        <option value="fixed_set_price" <?php selected($range['type'], 'fixed_set_price'); ?>><?php esc_html_e('Fixed price for set', 'yeediscounts'); ?></option>
                                        <option value="percentage" <?php selected($range['type'], 'percentage'); ?>><?php esc_html_e('Percentage', 'yeediscounts'); ?></option>
                                        <option value="flat" <?php selected($range['type'], 'flat'); ?>><?php esc_html_e('Fixed discount', 'yeediscounts'); ?></option>
                                    </select>
                                </div>
                                <div class="yeekit-form-group">
                                    <label><?php esc_html_e('Value', 'yeediscounts'); ?></label>
                                    <input type="number" name="rule[set_adjustments][ranges][<?php echo esc_attr($i); ?>][value]" value="<?php echo esc_attr($range['value']); ?>" step="0.01">
                                </div>
                                <div class="yeekit-form-group tier-grow">
                                    <label><?php esc_html_e('Label', 'yeediscounts'); ?></label>
                                    <input type="text" name="rule[set_adjustments][ranges][<?php echo esc_attr($i); ?>][label]" value="<?php echo esc_attr($range['label'] ?? ''); ?>">
                                </div>
                                <div class="yeekit-form-group">
                                    <label><?php esc_html_e('Recursive', 'yeediscounts'); ?></label>
                                    <div class="yeekit-checkbox-wrapper">
                                        <input type="checkbox" name="rule[set_adjustments][ranges][<?php echo esc_attr($i); ?>][is_recursive]" value="1" <?php checked(! empty($range['is_recursive'])); ?> class="yeekit-set-recursive-check">
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="tier-actions">
                            <span class="yeekit-remove-set-tier dashicons dashicons-no-alt" title="<?php esc_attr_e('Remove range', 'yeediscounts'); ?>"></span>
                        </div>
                    </div>
                <?php endforeach; ?>
            </div>
            <p>
                <button type="button" class="button" id="yeekit-add-set-tier"><?php esc_html_e('Add Range', 'yeediscounts'); ?></button>
            </p>
        </div>
    </div>
<?php
}

// Call the render function.
yeekit_render_set_discount_block($rule);
