<?php
if (! defined('ABSPATH')) {
    exit;
}

/**
 * Render General Settings Block
 *
 * @param array $rule The discount rule data.
 */
function yeekit_render_general_block($rule)
{
?>
    <div class="yeekit-dd-block">
        <h3 class="yeekit-dd-block-title"><?php esc_html_e('General', 'yeediscounts'); ?></h3>
        <div class="yeekit-dd-block-content">
            <table class="form-table">
                <tr>
                    <th><?php esc_html_e('Enable rule', 'yeediscounts'); ?></th>
                    <td>
                        <label>
                            <input type="checkbox"
                                name="rule[enabled]"
                                value="1"
                                <?php checked(! empty($rule['enabled'])); ?>>
                            <?php esc_html_e('Enable this discount rule', 'yeediscounts'); ?>
                        </label>
                        <br>
                        <label>
                            <input type="checkbox"
                                name="rule[ignore_other_rules]"
                                value="1"
                                <?php checked(! empty($rule['ignore_other_rules'])); ?>>
                            <?php esc_html_e('Apply this rule if matched and ignore all other rules', 'yeediscounts'); ?>
                        </label>
                    </td>
                </tr>
                <tr>
                    <th><?php esc_html_e('Rule name', 'yeediscounts'); ?></th>
                    <td>
                        <input type="text"
                            name="rule[title]"
                            class="regular-text"
                            required
                            value="<?php echo esc_attr($rule['title'] ?? ''); ?>">
                    </td>
                </tr>
                <tr>
                    <th><?php esc_html_e('Description', 'yeediscounts'); ?></th>
                    <td>
                        <textarea name="rule[description]"
                            rows="3"
                            class="large-text"><?php echo esc_textarea($rule['description'] ?? ''); ?></textarea>
                    </td>
                </tr>
                <tr>
                    <th><?php esc_html_e('Discount type', 'yeediscounts'); ?></th>
                    <td>
                        <select name="rule[type]"
                            class="yeekit-product-discount-type yeekit-discount-type-selector">
                            <option value="not_selected"><?php esc_html_e('Select Discount Type', 'yeediscounts'); ?></option>
                            <optgroup label="<?php esc_attr_e('Simple Discount', 'yeediscounts'); ?>">
                                <option value="yeekit_simple_discount" <?php selected($rule['type'] ?? '', 'yeekit_simple_discount'); ?>><?php esc_html_e('Product Adjustment', 'yeediscounts'); ?></option>
                                <option value="yeekit_cart_discount" <?php selected($rule['type'] ?? '', 'yeekit_cart_discount'); ?>><?php esc_html_e('Cart Adjustment', 'yeediscounts'); ?></option>
                                <option value="yeekit_free_shipping" <?php selected($rule['type'] ?? '', 'yeekit_free_shipping'); ?>><?php esc_html_e('Free Shipping', 'yeediscounts'); ?></option>
                            </optgroup>
                            <optgroup label="<?php esc_attr_e('Bulk Discount', 'yeediscounts'); ?>">
                                <option value="yeekit_bulk_discount" <?php selected($rule['type'] ?? '', 'yeekit_bulk_discount'); ?>><?php esc_html_e('Bulk Discount', 'yeediscounts'); ?></option>
                                <option value="yeekit_set_discount" <?php selected($rule['type'] ?? '', 'yeekit_set_discount'); ?>><?php esc_html_e('Bundle (Set) Discount', 'yeediscounts'); ?></option>
                            </optgroup>
                            <optgroup label="<?php esc_attr_e('Bogo Discount', 'yeediscounts'); ?>">
                                <option value="yeekit_buy_x_get_x" <?php selected($rule['type'] ?? '', 'yeekit_buy_x_get_x'); ?>><?php esc_html_e('Buy X get X', 'yeediscounts'); ?></option>
                                <option value="yeekit_buy_x_get_y" <?php selected($rule['type'] ?? '', 'yeekit_buy_x_get_y'); ?>><?php esc_html_e('Buy X get Y', 'yeediscounts'); ?></option>
                            </optgroup>
                        </select>
                        <div class="yeekit-discount-type-desc-wrapper">
                            <p class="description yeekit-type-desc yeekit-desc-yeekit_simple_discount"><?php esc_html_e('Product Adjustment: Discount specific products based on rules.', 'yeediscounts'); ?></p>
                            <p class="description yeekit-type-desc yeekit-desc-yeekit_cart_discount"><?php esc_html_e('Cart Adjustment: Discount the entire cart (e.g. 10% off total order).', 'yeediscounts'); ?></p>
                            <p class="description yeekit-type-desc yeekit-desc-yeekit_free_shipping"><?php esc_html_e('Free Shipping: Grant free shipping if conditions are met.', 'yeediscounts'); ?></p>
                            <p class="description yeekit-type-desc yeekit-desc-yeekit_bulk_discount"><?php esc_html_e('Bulk Discount: Tiered discounts based on quantity (e.g. Buy 10 get 5% off).', 'yeediscounts'); ?></p>
                            <p class="description yeekit-type-desc yeekit-desc-yeekit_set_discount"><?php esc_html_e('Bundle (Set) Discount: Buy a set of items (e.g. A+B+C) for a fixed price or discount.', 'yeediscounts'); ?></p>
                            <p class="description yeekit-type-desc yeekit-desc-yeekit_buy_x_get_x"><?php esc_html_e('BOGO: Buy X quantity, get the same product (X) for free or discounted.', 'yeediscounts'); ?></p>
                            <p class="description yeekit-type-desc yeekit-desc-yeekit_buy_x_get_y"><?php esc_html_e('Buy X Get Y: Buy product X, get a different product (Y) for free or discounted.', 'yeediscounts'); ?></p>
                        </div>
                    </td>
                </tr>
            </table>
        </div>
    </div>
<?php
}

// Call the render function.
yeekit_render_general_block($rule);
