<?php
if (! defined('ABSPATH')) {
    exit;
}

/**
 * Render Filter Block
 *
 * @param array $rule The discount rule data.
 */
function yeekit_render_filter_block($rule)
{
?>
    <div class="yeekit-dd-block">
        <h3 class="yeekit-dd-block-title"><?php esc_html_e('Filter', 'yeediscounts'); ?></h3>

        <div class="yeekit-dd-block-content">
            <p class="description yeekit-block-desc">
                <?php esc_html_e(
                    'Choose items (Products, Categories, etc.) eligible for the discount using "In list". To exclude items, use "Not in list". You can combine multiple filters.',
                    'yeediscounts'
                ); ?>
            </p>
            <div class="yeekit-filters-wrap">
                <?php
                $filters = $rule['filters'] ?? [];
                if (!empty($filters)) {
                    foreach ($filters as $index => $filter):
                ?>
                        <div class="yeekit-filter-row" data-index="<?php echo esc_attr($index); ?>">
                            <select name="filters[<?php echo esc_attr($index); ?>][type]" class="yeekit-filter-type">
                                <option value="cart_item_products" <?php selected($filter['type'], 'cart_item_products'); ?>>
                                    <?php esc_html_e('Products', 'yeediscounts'); ?>
                                </option>
                                <option value="cart_item_product_category" <?php selected($filter['type'], 'cart_item_product_category'); ?>>
                                    <?php esc_html_e('Category', 'yeediscounts'); ?>
                                </option>
                                <option value="cart_item_product_tags" <?php selected($filter['type'], 'cart_item_product_tags'); ?>>
                                    <?php esc_html_e('Tags', 'yeediscounts'); ?>
                                </option>
                                <option value="cart_item_product_attributes" <?php selected($filter['type'], 'cart_item_product_attributes'); ?>>
                                    <?php esc_html_e('Attributes', 'yeediscounts'); ?>
                                </option>
                                <option value="cart_item_product_sku" <?php selected($filter['type'], 'cart_item_product_sku'); ?>>
                                    <?php esc_html_e('SKUs', 'yeediscounts'); ?>
                                </option>
                                <option value="cart_item_product_onsale" <?php selected($filter['type'], 'cart_item_product_onsale'); ?>>
                                    <?php esc_html_e('On sale products', 'yeediscounts'); ?>
                                </option>
                            </select>
                            <select name="filters[<?php echo esc_attr($index); ?>][operator]" class="yeekit-filter-operator">
                                <option value="in" <?php selected($filter['operator'], 'in'); ?>><?php esc_html_e('In list', 'yeediscounts'); ?></option>
                                <option value="not_in" <?php selected($filter['operator'], 'not_in'); ?>><?php esc_html_e('Not in list', 'yeediscounts'); ?></option>
                            </select>
                            <div class="yeekit-filter-value">
                                <?php if ($filter['type'] === 'cart_item_products') : ?>
                                    <select class="yeekit-product-ajax-select"
                                        name="filters[<?php echo esc_attr($index); ?>][value][]"
                                        multiple>
                                        <?php
                                        $saved_products = array_map('absint', (array) ($filter['value'] ?? []));
                                        foreach ($saved_products as $pid) :
                                            $product = wc_get_product($pid);
                                            if (! $product) {
                                                continue;
                                            }
                                        ?>
                                            <option value="<?php echo esc_attr($pid); ?>" <?php if (in_array($pid, $saved_products)) echo esc_attr(' selected'); ?>>
                                                <?php echo esc_html($product->get_name()); ?>
                                            </option>
                                        <?php endforeach; ?>
                                    </select>
                                <?php elseif (in_array($filter['type'], ['cart_item_product_category', 'cart_item_product_tags'], true)) : ?>
                                    <?php
                                    $saved = (array) ($filter['value'] ?? []);
                                    ?>
                                    <select class="wc-enhanced-select"
                                        name="filters[<?php echo esc_attr($index); ?>][value][]"
                                        multiple>
                                        <?php
                                        $terms = get_terms([
                                            'taxonomy'   => $filter['type'] === 'cart_item_product_category' ? 'product_cat' : 'product_tag',
                                            'hide_empty' => false,
                                        ]);
                                        $saved = (array) ($filter['value'] ?? []);
                                        foreach ($terms as $term) :
                                        ?>
                                            <option value="<?php echo esc_attr($term->term_id); ?>"
                                                <?php if (in_array($term->term_id, $saved)) echo esc_attr(' selected'); ?>>
                                                <?php echo esc_html($term->name); ?>
                                            </option>
                                        <?php endforeach; ?>
                                    </select>
                                <?php elseif ($filter['type'] === 'cart_item_product_sku') : ?>
                                    <textarea name="filters[<?php echo esc_attr($index); ?>][value]"
                                        rows="3"><?php echo esc_textarea(is_array($filter['value']) ? implode(", ", $filter['value']) : $filter['value']); ?></textarea>
                                <?php else : ?>
                                    <input type="hidden"
                                        name="filters[<?php echo esc_attr($index); ?>][value]"
                                        value="<?php echo esc_attr(is_array($filter['value']) ? implode(',', $filter['value']) : $filter['value']); ?>">
                                <?php endif; ?>
                            </div>
                            <span class="yeekit-filter-remove dashicons dashicons-no-alt"
                                title="<?php esc_attr_e('Remove filter', 'yeediscounts'); ?>"></span>

                            <p class="yeekit-filter-desc yeekit-desc-cart_item_products"><?php esc_html_e('Choose products that get the discount using "In list". To exclude products, use "Not in list".', 'yeediscounts'); ?></p>
                            <p class="yeekit-filter-desc yeekit-desc-cart_item_product_category"><?php esc_html_e('Choose categories to include using "In list". To exclude categories, use "Not in list".', 'yeediscounts'); ?></p>
                            <p class="yeekit-filter-desc yeekit-desc-cart_item_product_tags"><?php esc_html_e('Choose tags to include using "In list". To exclude tags, use "Not in list".', 'yeediscounts'); ?></p>
                            <p class="yeekit-filter-desc yeekit-desc-cart_item_product_attributes"><?php esc_html_e('Choose attributes to include using "In list". To exclude attributes, use "Not in list".', 'yeediscounts'); ?></p>
                            <p class="yeekit-filter-desc yeekit-desc-cart_item_product_sku"><?php esc_html_e('Enter SKUs, separated by commas (e.g. 94651, 94652, 9463). Use "In list" to include, "Not in list" to exclude.', 'yeediscounts'); ?></p>
                            <p class="yeekit-filter-desc yeekit-desc-cart_item_product_onsale"><?php esc_html_e('Matches items that are On Sale. Use "In list" to include them, "Not in list" to exclude them.', 'yeediscounts'); ?></p>
                        </div>
                <?php endforeach;
                } ?>
            </div>
            <p class="yeekit-filter-actions">
                <button type="button"
                    class="button yeekit-add-filter">
                    <?php esc_html_e('Add filter', 'yeediscounts'); ?>
                </button>
            </p>

        </div>
    </div>
<?php
}

// Call the render function.
yeekit_render_filter_block($rule);
