<?php
if (! defined('ABSPATH')) {
    exit;
}
/**
 * Render Discount Block
 *
 * @param array $rule The discount rule data.
 */
function yeekit_render_discount_block($rule)
{
?>
    <div class="yeekit-dd-block">
        <h3 class="yeekit-dd-block-title"><?php esc_html_e('Discount', 'yeediscounts'); ?></h3>
        <div class="yeekit-dd-block-content">
            <p class="description yeekit-block-desc">
                <?php esc_html_e('Configure the discount logic. Select the type of calculation and the amount to apply.', 'yeediscounts'); ?>
            </p>
            <table class="form-table">
                <tr>
                    <th><?php esc_html_e('Discount type', 'yeediscounts'); ?></th>
                    <td>
                        <select name="yeekit_discount_type" class="yeekit-discount-type">
                            <option value="percentage" <?php selected($rule['discount']['type'] ?? '', 'percentage'); ?>><?php esc_html_e('Percentage discount', 'yeediscounts'); ?></option>
                            <option value="fixed" <?php selected($rule['discount']['type'] ?? '', 'fixed'); ?>><?php esc_html_e('Fixed discount', 'yeediscounts'); ?></option>
                            <option value="fixed_price" <?php selected($rule['discount']['type'] ?? '', 'fixed_price'); ?>><?php esc_html_e('Fixed price per item', 'yeediscounts'); ?></option>
                        </select>
                        <p class="yeekit-discount-type-desc yeekit-desc-percentage"><?php esc_html_e('Apply a percentage based discount.', 'yeediscounts'); ?></p>
                        <p class="yeekit-discount-type-desc yeekit-desc-fixed"><?php esc_html_e('Apply a fixed amount discount for each matching item.', 'yeediscounts'); ?></p>
                        <p class="yeekit-discount-type-desc yeekit-desc-fixed_per_item"><?php esc_html_e('Apply a fixed amount discount for each matching item.', 'yeediscounts'); ?></p>
                        <p class="yeekit-discount-type-desc yeekit-desc-fixed_price"><?php esc_html_e('Set the price of matching items to a fixed amount.', 'yeediscounts'); ?></p>
                    </td>
                </tr>
                <tr>
                    <th><?php esc_html_e('Value', 'yeediscounts'); ?></th>
                    <td>
                        <input type="number" step="0.01" name="yeekit_discount_value"
                            value="<?php echo esc_attr($rule['discount']['value'] ?? ''); ?>">
                        <p class="yeekit-value-desc yeekit-val-desc-percentage"><?php esc_html_e('Enter the percentage (e.g. 20 for 20%).', 'yeediscounts'); ?></p>
                        <p class="yeekit-value-desc yeekit-val-desc-currency"><?php esc_html_e('Enter the amount in your store currency.', 'yeediscounts'); ?></p>
                    </td>
                </tr>
                <tr class="yeekit-discount-title-row">
                    <th><?php esc_html_e('Title', 'yeediscounts'); ?></th>
                    <td>
                        <input type="text" name="yeekit_discount_title"
                            class="regular-text"
                            placeholder="<?php esc_attr_e('e.g. Summer Sale', 'yeediscounts'); ?>"
                            value="<?php echo esc_attr($rule['discount']['title'] ?? ''); ?>">
                        <p class="description"><?php esc_html_e('Label shown in cart/checkout', 'yeediscounts'); ?></p>
                    </td>
                </tr>
            </table>
        </div>
    </div>
<?php
}
// Call the render function.
yeekit_render_discount_block($rule);
