<?php
if (! defined('ABSPATH')) {
    exit;
}

/**
 * Render Discount Bar Block
 *
 * @param array $rule The discount rule data.
 */
function yeekit_render_discount_bar_block($rule)
{
?>
    <div class="yeekit-dd-block yeekit-discount-bar-block">
        <h3 class="yeekit-dd-block-title"><?php esc_html_e('Discount Bar', 'yeediscounts'); ?></h3>
        <div class="yeekit-dd-block-content">
            <p class="description yeekit-block-desc">
                <?php esc_html_e(
                    'Display a notification bar to encourage customers to purchase more items to reach the discount offer. You can adjust the display location in the Settings.',
                    'yeediscounts'
                ); ?>
            </p>
            <div class="yeekit-form-group">
                <label>
                    <input type="checkbox" name="rule[discount_bar_enabled]" value="1" <?php checked(!empty($rule['discount_bar_enabled'])); ?>>
                    <?php esc_html_e('Enable Discount Bar', 'yeediscounts'); ?>
                </label>
            </div>
            <div class="yeekit-db-colors-row">
                <div class="yeekit-form-group">
                    <label><?php esc_html_e('Badge Background Color', 'yeediscounts'); ?></label>
                    <div class="yeekit-color-picker-wrapper">
                        <input type="color" name="rule[discount_bar_bg_color]" value="<?php echo esc_attr($rule['discount_bar_bg_color'] ?? '#3d9cd2'); ?>">
                    </div>
                </div>
                <div class="yeekit-form-group">
                    <label><?php esc_html_e('Badge Color', 'yeediscounts'); ?></label>
                    <div class="yeekit-color-picker-wrapper">
                        <input type="color" name="rule[discount_bar_text_color]" value="<?php echo esc_attr($rule['discount_bar_text_color'] ?? '#ffffff'); ?>">
                    </div>
                </div>
            </div>
            <div class="yeekit-form-group yeekit-db-message-row">
                <label><?php esc_html_e('Message', 'yeediscounts'); ?></label>
                <?php
                $default_msg = __('Discount {discount_title}', 'yeediscounts');
                $msg = isset($rule['discount_bar_message']) ? $rule['discount_bar_message'] : $default_msg;
                ?>
                <textarea name="rule[discount_bar_message]" rows="3" placeholder="<?php esc_attr_e('Display discount information', 'yeediscounts'); ?>"><?php echo esc_textarea($msg); ?></textarea>
                <p class="description"><?php esc_html_e('Message to display on the frontend. Use {discount_title} to insert the rule title.', 'yeediscounts'); ?></p>
            </div>
        </div>
    </div>
<?php
}

// Call the render function.
yeekit_render_discount_bar_block($rule);
