<?php
if (! defined('ABSPATH')) {
    exit;
}

/**
 * Render Buy X Get Y (BXGY) Block
 *
 * @param array $rule The discount rule data.
 */
function yeekit_render_bxgy_block($rule)
{
?>
    <div class="yeekit-dd-block yeekit-buyx-gety-block">
        <h3 class="yeekit-dd-block-title"><?php esc_html_e('Buy X Get Y', 'yeediscounts'); ?></h3>
        <div class="yeekit-dd-block-content">
            <p class="description yeekit-block-desc">
                <?php esc_html_e(
                    'Buy specific quantity of products/categories and get same or other products/categories for free or with discount.',
                    'yeediscounts'
                ); ?>
            </p>
            <!-- SETTINGS -->
            <table class="form-table">
                <tr>
                    <th><?php esc_html_e('Discount type', 'yeediscounts'); ?></th>
                    <td>
                        <select name="rule[buyx_gety_adjustments][type]" class="select_bxgy_type" style="width:100%; max-width:400px;">
                            <option value="bxgy_product" <?php selected($rule['buyx_gety_adjustments']['type'] ?? '', 'bxgy_product'); ?>><?php esc_html_e('Buy X Get Y - Products', 'yeediscounts'); ?></option>
                            <option value="bxgy_category" <?php selected($rule['buyx_gety_adjustments']['type'] ?? '', 'bxgy_category'); ?>><?php esc_html_e('Buy X Get Y - Categories', 'yeediscounts'); ?></option>
                            <option value="bxgy_all" <?php selected($rule['buyx_gety_adjustments']['type'] ?? '', 'bxgy_all'); ?>><?php esc_html_e('Buy X Get Y - All', 'yeediscounts'); ?></option>
                        </select>
                    </td>
                </tr>
                <tr>
                    <th><?php esc_html_e('Buy X Count Based on', 'yeediscounts'); ?></th>
                    <td>
                        <select name="rule[buyx_gety_adjustments][operator]" class="awdr_mode_of_operator" style="width:100%; max-width:400px;">
                            <option value="product_cumulative" title="<?php esc_attr_e('Filter set above...', 'yeediscounts'); ?>" <?php selected($rule['buyx_gety_adjustments']['operator'] ?? '', 'product_cumulative'); ?>><?php esc_html_e('Filters set above', 'yeediscounts'); ?></option>
                            <option value="product" title="<?php esc_attr_e('Individual Product...', 'yeediscounts'); ?>" <?php selected($rule['buyx_gety_adjustments']['operator'] ?? '', 'product'); ?>><?php esc_html_e('Individual Product', 'yeediscounts'); ?></option>
                            <option value="variation" title="<?php esc_attr_e('All variants...', 'yeediscounts'); ?>" <?php selected($rule['buyx_gety_adjustments']['operator'] ?? '', 'variation'); ?>><?php esc_html_e('All variants in each product together', 'yeediscounts'); ?></option>
                        </select>
                    </td>
                </tr>
                <tr>
                    <th><?php esc_html_e('Mode of Apply', 'yeediscounts'); ?></th>
                    <td>
                        <select name="rule[buyx_gety_adjustments][apply_mode]" style="width:100%; max-width:400px;">
                            <option value="auto_add" <?php selected($rule['buyx_gety_adjustments']['apply_mode'] ?? '', 'auto_add'); ?>><?php esc_html_e('Auto add', 'yeediscounts'); ?></option>
                            <option value="cheapest" <?php selected($rule['buyx_gety_adjustments']['apply_mode'] ?? '', 'cheapest'); ?>><?php esc_html_e('Cheapest', 'yeediscounts'); ?></option>
                            <option value="highest" <?php selected($rule['buyx_gety_adjustments']['apply_mode'] ?? '', 'highest'); ?>><?php esc_html_e('Highest', 'yeediscounts'); ?></option>
                        </select>
                    </td>
                </tr>
            </table>
            <!-- REPEATER -->
            <div class="yeekit-tiers-list yeekit-bxgy-list" id="yeekit-buyx-gety-tiers-container">
                <?php
                $bxgy_ranges = $rule['buyx_gety_adjustments']['ranges'] ?? [];
                if (empty($bxgy_ranges)) {
                    $bxgy_ranges[] = [
                        'min_qty' => 1,
                        'max_qty' => '',
                        'get_product' => '',
                        'get_qty' => 1,
                        'discount_type' => 'free_product',
                        'discount_value' => '',
                    ];
                }
                foreach ($bxgy_ranges as $i => $range):
                    $product_id = absint($range['get_product'] ?? 0);
                    $product_name = '';
                    if ($product_id > 0) {
                        $prod = wc_get_product($product_id);
                        if ($prod) $product_name = $prod->get_name();
                    }
                ?>
                    <div class="yeekit-tier-row yeekit-buyx-gety-tier-row">
                        <div class="tier-content">
                            <div class="tier-line-1">
                                <div class="yeekit-fieldset-group">
                                    <div class="yeekit-fieldset-legend"><?php esc_html_e('Buy Quantity', 'yeediscounts'); ?></div>
                                    <div class="yeekit-fieldset-content">
                                        <div class="yeekit-form-group">
                                            <label class="yeekit-bxgy-min-qty-header"><?php esc_html_e('Min Qty', 'yeediscounts'); ?></label>
                                            <input type="number" name="rule[buyx_gety_adjustments][ranges][<?php echo esc_attr($i); ?>][min_qty]" value="<?php echo esc_attr($range['min_qty']); ?>" min="1" step="1">
                                        </div>
                                        <div class="yeekit-form-group yeekit-bxgy-max-qty-wrapper">
                                            <label class="yeekit-bxgy-max-qty-header"><?php esc_html_e('Max Qty', 'yeediscounts'); ?></label>
                                            <input type="number" name="rule[buyx_gety_adjustments][ranges][<?php echo esc_attr($i); ?>][max_qty]" value="<?php echo esc_attr($range['max_qty'] ?? ''); ?>" min="1" step="1" class="yeekit-bxgy-max-qty">
                                        </div>
                                    </div>
                                </div>
                                <div class="yeekit-fieldset-group tier-grow">
                                    <div class="yeekit-fieldset-legend"><?php esc_html_e('Get Quantity', 'yeediscounts'); ?></div>
                                    <div class="yeekit-fieldset-content">
                                        <div class="yeekit-form-group tier-grow yeekit-bxgy-get-item-wrapper" data-type="<?php echo esc_attr($rule['buyx_gety_adjustments']['type'] ?? 'bxgy_product'); ?>">
                                            <?php
                                            $bxgy_type = $rule['buyx_gety_adjustments']['type'] ?? 'bxgy_product';
                                            $name_prefix = "rule[buyx_gety_adjustments][ranges][" . esc_attr($i) . "][get_product]";
                                            $saved_values = !empty($range['get_product']) ? (array) $range['get_product'] : [];

                                            if ($bxgy_type === 'bxgy_all') : ?>
                                                <label><?php esc_html_e('Get Any Product', 'yeediscounts'); ?></label>
                                                <input type="hidden" name="<?php echo esc_attr($name_prefix); ?>" value="all">
                                                <span class="description"><?php esc_html_e('Customer gets any product from store', 'yeediscounts'); ?></span>
                                            <?php elseif ($bxgy_type === 'bxgy_category') : ?>
                                                <label><?php esc_html_e('Get Category', 'yeediscounts'); ?></label>
                                                <select name="<?php echo esc_attr($name_prefix); ?>[]" class="wc-enhanced-select" multiple style="min-width:150px;">
                                                    <?php
                                                    $cats = get_terms(['taxonomy' => 'product_cat', 'hide_empty' => false]);
                                                    foreach ($cats as $cat) {
                                                    ?>
                                                        <option value="<?php echo esc_attr($cat->term_id); ?>" <?php if (in_array($cat->term_id, $saved_values)) echo wp_kses_post(' selected="selected"'); ?>><?php echo esc_html($cat->name); ?></option>
                                                    <?php
                                                    }
                                                    ?>
                                                </select>
                                            <?php else : // bxgy_product 
                                            ?>
                                                <label><?php esc_html_e('Get Product', 'yeediscounts'); ?></label>
                                                <select name="<?php echo esc_attr($name_prefix); ?>[]" class="yeekit-product-ajax-select" multiple style="min-width:150px;">
                                                    <?php
                                                    foreach ($saved_values as $p_id) :
                                                        $p_id = absint($p_id);
                                                        if ($p_id > 0) {
                                                            $prod = wc_get_product($p_id);
                                                            if ($prod) :
                                                    ?>
                                                                <option value="<?php echo esc_attr($p_id); ?>" selected>
                                                                    <?php echo esc_html($prod->get_name()); ?>
                                                                </option>
                                                    <?php
                                                            endif;
                                                        }
                                                    endforeach;
                                                    ?>
                                                </select>
                                            <?php endif; ?>
                                        </div>
                                        <div class="yeekit-form-group">
                                            <label><?php esc_html_e('Get Qty', 'yeediscounts'); ?></label>
                                            <input type="number" name="rule[buyx_gety_adjustments][ranges][<?php echo esc_attr($i); ?>][get_qty]" value="<?php echo esc_attr($range['get_qty']); ?>" min="1" step="1">
                                        </div>
                                        <div class="yeekit-form-group">
                                            <label><?php esc_html_e('Discount Type', 'yeediscounts'); ?></label>
                                            <select name="rule[buyx_gety_adjustments][ranges][<?php echo esc_attr($i); ?>][discount_type]" class="buyx_gety_discount_select">
                                                <option value="free_product" <?php selected($range['discount_type'] ?? '', 'free_product'); ?>><?php esc_html_e('Free', 'yeediscounts'); ?></option>
                                                <option value="percentage" <?php selected($range['discount_type'] ?? '', 'percentage'); ?>><?php esc_html_e('Percentage discount', 'yeediscounts'); ?></option>
                                                <option value="flat" <?php selected($range['discount_type'] ?? '', 'flat'); ?>><?php esc_html_e('Fixed discount', 'yeediscounts'); ?></option>
                                                <option value="fixed_price" <?php selected($range['discount_type'] ?? '', 'fixed_price'); ?>><?php esc_html_e('Fixed Price per item', 'yeediscounts'); ?></option>
                                            </select>
                                        </div>
                                        <div class="yeekit-form-group yeekit-bxgy-discount-value-wrapper">
                                            <label><?php esc_html_e('Value', 'yeediscounts'); ?></label>
                                            <input type="number" name="rule[buyx_gety_adjustments][ranges][<?php echo esc_attr($i); ?>][discount_value]" value="<?php echo esc_attr($range['discount_value'] ?? ''); ?>" step="0.01" class="yeekit-bxgy-discount-value">
                                        </div>
                                    </div>
                                </div>
                                <div class="yeekit-form-group">
                                    <label><?php esc_html_e('Recursive', 'yeediscounts'); ?></label>
                                    <div class="yeekit-checkbox-wrapper">
                                        <input type="checkbox" name="rule[buyx_gety_adjustments][ranges][<?php echo esc_attr($i); ?>][is_recursive]" value="1" <?php checked(! empty($range['is_recursive'])); ?> class="yeekit-bxgy-recursive-check">
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="tier-actions">
                            <span class="yeekit-remove-bxgy-tier dashicons dashicons-no-alt" title="<?php esc_attr_e('Remove range', 'yeediscounts'); ?>"></span>
                        </div>
                    </div>
                <?php endforeach; ?>
            </div>
            <p>
                <button type="button" class="button" id="yeekit-add-bxgy-tier"><?php esc_html_e('Add Range', 'yeediscounts'); ?></button>
            </p>
        </div>
    </div>
<?php
}

// Call the render function.
yeekit_render_bxgy_block($rule);
