<?php
if (! defined('ABSPATH')) {
    exit;
}

/**
 * Render Bulk Discount Block
 *
 * @param array $rule The discount rule data.
 */
function yeekit_render_bulk_discount_block($rule)
{
?>
    <div class="yeekit-dd-block yeekit-bulk-discount-block" style="display:none;">
        <h3 class="yeekit-dd-block-title"><?php esc_html_e('Bulk Discount Rates', 'yeediscounts'); ?></h3>
        <div class="yeekit-dd-block-content">
            <p class="description yeekit-block-desc">
                <?php esc_html_e(
                    'Apply a percentage or fixed discount based on the quantity of items purchased.',
                    'yeediscounts'
                ); ?>
            </p>
            <p class="form-field">
                <label for="yeekit-bulk-count-mode"><?php esc_html_e('Count Quantities by:', 'yeediscounts'); ?></label>
                <select name="rule[bulk_adjustments][operator]" id="yeekit-bulk-count-mode" class="wdr-bulk-type bulk_discount_select awdr_mode_of_operator" style="width:100%; max-width:400px;">
                    <option value="product_cumulative" title="<?php esc_attr_e('This will count the quantities of products set in the "Filter" section.', 'yeediscounts'); ?>" <?php selected(($rule['bulk_adjustments']['operator'] ?? ''), 'product_cumulative'); ?>>
                        <?php esc_html_e('Filters set above', 'yeediscounts'); ?>
                    </option>
                    <option value="product" title="<?php esc_attr_e('This counts the total quantity of each product / line item separately.', 'yeediscounts'); ?>" <?php selected(($rule['bulk_adjustments']['operator'] ?? ''), 'product'); ?>>
                        <?php esc_html_e('Individual product', 'yeediscounts'); ?>
                    </option>
                    <option value="variation" title="<?php esc_attr_e('Useful when applying discounts based on variable products.', 'yeediscounts'); ?>" <?php selected(($rule['bulk_adjustments']['operator'] ?? ''), 'variation'); ?>>
                        <?php esc_html_e('All variants in each product together', 'yeediscounts'); ?>
                    </option>
                </select>
            </p>
            <div class="yeekit-tiers-list yeekit-bulk-list" id="yeekit-bulk-tiers-container">
                <?php
                $tiers = $rule['bulk_tiers'] ?? [];
                if (empty($tiers)) {
                    $tiers[] = ['min_qty' => 1, 'max_qty' => '', 'type' => 'percentage', 'value' => 10, 'label' => ''];
                }
                foreach ($tiers as $i => $tier):
                ?>
                    <div class="yeekit-tier-row yeekit-bulk-tier-row">
                        <div class="tier-content">
                            <div class="tier-line-1">
                                <div class="yeekit-form-group">
                                    <label><?php esc_html_e('Min Qty', 'yeediscounts'); ?></label>
                                    <input type="number" name="rule[bulk_tiers][<?php echo esc_attr($i); ?>][min_qty]" value="<?php echo esc_attr($tier['min_qty']); ?>" min="0" step="1">
                                </div>
                                <div class="yeekit-form-group">
                                    <label><?php esc_html_e('Max Qty', 'yeediscounts'); ?></label>
                                    <input type="number" name="rule[bulk_tiers][<?php echo esc_attr($i); ?>][max_qty]" value="<?php echo esc_attr($tier['max_qty'] ?? ''); ?>" min="0" step="1" placeholder="Any">
                                </div>
                                <div class="yeekit-form-group">
                                    <label><?php esc_html_e('Discount Type', 'yeediscounts'); ?></label>
                                    <select name="rule[bulk_tiers][<?php echo esc_attr($i); ?>][type]">
                                        <option value="percentage" <?php selected($tier['type'], 'percentage'); ?>><?php esc_html_e('Percentage', 'yeediscounts'); ?></option>
                                        <option value="fixed" <?php selected($tier['type'], 'fixed'); ?>><?php esc_html_e('Fixed Discount', 'yeediscounts'); ?></option>
                                        <option value="fixed_price" <?php selected($tier['type'], 'fixed_price'); ?>><?php esc_html_e('Fixed price for item', 'yeediscounts'); ?></option>
                                    </select>
                                </div>
                                <div class="yeekit-form-group">
                                    <label><?php esc_html_e('Value', 'yeediscounts'); ?></label>
                                    <input type="number" name="rule[bulk_tiers][<?php echo esc_attr($i); ?>][value]" value="<?php echo esc_attr($tier['value']); ?>" step="0.01">
                                </div>
                                <div class="yeekit-form-group tier-grow">
                                    <label><?php esc_html_e('Label', 'yeediscounts'); ?></label>
                                    <input type="text" name="rule[bulk_tiers][<?php echo esc_attr($i); ?>][label]" value="<?php echo esc_attr($tier['label'] ?? ''); ?>">
                                </div>
                            </div>
                        </div>
                        <div class="tier-actions">
                            <span class="yeekit-remove-tier dashicons dashicons-no-alt" title="<?php esc_attr_e('Remove range', 'yeediscounts'); ?>"></span>
                        </div>
                    </div>
                <?php endforeach; ?>
            </div>
            <p>
                <button type="button" class="button" id="yeekit-add-bulk-tier"><?php esc_html_e('Add Range', 'yeediscounts'); ?></button>
            </p>
            <p>
                <label>
                    <input type="checkbox"
                        name="rule[settings][apply_as_coupon]"
                        value="1"
                        <?php checked(! empty($rule['settings']['apply_as_coupon'])); ?>>
                    <?php esc_html_e('Show discount in cart as coupon instead of changing the product price', 'yeediscounts'); ?>
                </label>
            </p>
        </div>
    </div>
<?php
}

// Call the render function.
yeekit_render_bulk_discount_block($rule);
