<?php
if (! defined('ABSPATH')) {
    exit;
}

/**
 * Render Buy X Get X (BOGO) Block
 *
 * @param array $rule The discount rule data.
 */
function yeekit_render_bogo_block($rule)
{
?>
    <div class="yeekit-dd-block yeekit-buyx-getx-block">
        <h3 class="yeekit-dd-block-title"><?php esc_html_e('Buy X Get X (BOGO)', 'yeediscounts'); ?></h3>
        <div class="yeekit-dd-block-content">
            <div class="yeekit-dd-block-content">
                <p class="description yeekit-block-desc">
                    <?php esc_html_e(
                        'Buy X quantity of a product and get X quantity of the same product for free/discount (e.g. Buy 2 Get 1 Free).',
                        'yeediscounts'
                    ); ?>
                </p>
                <div class="yeekit-tiers-list yeekit-bogo-list" id="yeekit-buyx-getx-tiers-container">
                    <?php
                    $bogo_ranges = $rule['buyx_getx_adjustments']['ranges'] ?? [];
                    if (empty($bogo_ranges)) {
                        $bogo_ranges[] = ['min_qty' => 1, 'max_qty' => '', 'free_qty' => 1, 'free_type' => 'free_product', 'is_recursive' => 0];
                    }
                    foreach ($bogo_ranges as $i => $range):
                    ?>
                        <div class="yeekit-tier-row yeekit-buyx-getx-tier-row">
                            <div class="tier-content">
                                <div class="tier-line-1">
                                    <div class="yeekit-form-group">
                                        <label><?php esc_html_e('Min Qty', 'yeediscounts'); ?></label>
                                        <input type="number" name="rule[buyx_getx_adjustments][ranges][<?php echo esc_attr($i); ?>][min_qty]" value="<?php echo esc_attr($range['min_qty']); ?>" min="1" step="1">
                                    </div>
                                    <div class="yeekit-form-group yeekit-bogo-max-qty-wrapper">
                                        <label class="yeekit-bogo-max-qty-header"><?php esc_html_e('Max Qty', 'yeediscounts'); ?></label>
                                        <input type="number" name="rule[buyx_getx_adjustments][ranges][<?php echo esc_attr($i); ?>][max_qty]" value="<?php echo esc_attr($range['max_qty'] ?? ''); ?>" min="1" step="1" class="yeekit-bogo-max-qty">
                                    </div>
                                    <div class="yeekit-form-group">
                                        <label><?php esc_html_e('Free Qty', 'yeediscounts'); ?></label>
                                        <input type="number" name="rule[buyx_getx_adjustments][ranges][<?php echo esc_attr($i); ?>][free_qty]" value="<?php echo esc_attr($range['free_qty']); ?>" min="1" step="1">
                                    </div>
                                    <div class="yeekit-form-group">
                                        <label><?php esc_html_e('Discount Type', 'yeediscounts'); ?></label>
                                        <select name="rule[buyx_getx_adjustments][ranges][<?php echo esc_attr($i); ?>][free_type]" class="awdr-bogo-discount-type buyx_getx_discount_select">
                                            <option value="free_product" <?php selected($range['free_type'] ?? '', 'free_product'); ?>><?php esc_html_e('Free', 'yeediscounts'); ?></option>
                                            <option value="percentage" <?php selected($range['free_type'] ?? '', 'percentage'); ?>><?php esc_html_e('Percentage discount', 'yeediscounts'); ?></option>
                                            <option value="flat" <?php selected($range['free_type'] ?? '', 'flat'); ?>><?php esc_html_e('Fixed discount', 'yeediscounts'); ?></option>
                                        </select>
                                    </div>
                                    <div class="yeekit-form-group yeekit-bogo-amount-wrapper">
                                        <label><?php esc_html_e('Value', 'yeediscounts'); ?></label>
                                        <input type="number" name="rule[buyx_getx_adjustments][ranges][<?php echo esc_attr($i); ?>][amount]" value="<?php echo esc_attr($range['amount'] ?? ''); ?>" step="0.01" class="yeekit-bogo-amount">
                                    </div>
                                    <div class="yeekit-form-group">
                                        <label><?php esc_html_e('Recursive', 'yeediscounts'); ?></label>
                                        <div class="yeekit-checkbox-wrapper">
                                            <input type="checkbox" name="rule[buyx_getx_adjustments][ranges][<?php echo esc_attr($i); ?>][is_recursive]" value="1" <?php checked(! empty($range['is_recursive'])); ?> class="yeekit-bogo-recursive-check">
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="tier-actions">
                                <span class="yeekit-remove-bogo-tier dashicons dashicons-no-alt" title="<?php esc_attr_e('Remove range', 'yeediscounts'); ?>"></span>
                            </div>
                        </div>
                    <?php endforeach; ?>
                </div>
                <p>
                    <button type="button" class="button" id="yeekit-add-bogo-tier"><?php esc_html_e('Add Range', 'yeediscounts'); ?></button>
                </p>
            </div>
        </div>
    </div>
<?php
}

// Call the render function.
yeekit_render_bogo_block($rule);
